/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ConcurrentHashSet;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

@ChannelHandler.Sharable
class BuildMessageDispatcher
extends SimpleChannelInboundHandlerAdapter<CmdlineRemoteProto.Message> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.BuildMessageDispatcher");
    private static final AttributeKey<SessionData> SESSION_DATA = AttributeKey.valueOf((String)"BuildMessageDispatcher.sessionData");
    private final Map<UUID, SessionData> myMessageHandlers = new ConcurrentHashMap<UUID, SessionData>(16, 0.75f, 1);
    private final Set<UUID> myCanceledSessions = new ConcurrentHashSet();

    BuildMessageDispatcher() {
    }

    public void registerBuildMessageHandler(UUID sessionId, BuilderMessageHandler handler, CmdlineRemoteProto.Message.ControllerMessage params) {
        this.myMessageHandlers.put(sessionId, new SessionData(sessionId, handler, params));
    }

    @Nullable
    public BuilderMessageHandler unregisterBuildMessageHandler(UUID sessionId) {
        this.myCanceledSessions.remove(sessionId);
        SessionData data = this.myMessageHandlers.remove(sessionId);
        return data != null ? data.handler : null;
    }

    public void cancelSession(UUID sessionId) {
        Channel channel;
        if (this.myCanceledSessions.add(sessionId) && (channel = this.getConnectedChannel(sessionId)) != null) {
            channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
        }
    }

    @Nullable
    public Channel getConnectedChannel(UUID sessionId) {
        Channel channel = this.getAssociatedChannel(sessionId);
        return channel != null && channel.isActive() ? channel : null;
    }

    @Nullable
    public Channel getAssociatedChannel(UUID sessionId) {
        SessionData data = this.myMessageHandlers.get(sessionId);
        return data != null ? data.channel : null;
    }

    @Override
    protected void messageReceived(ChannelHandlerContext context, CmdlineRemoteProto.Message message) throws Exception {
        BuilderMessageHandler handler;
        UUID sessionId;
        SessionData sessionData = (SessionData)context.attr(SESSION_DATA).get();
        if (sessionData == null) {
            CmdlineRemoteProto.Message.UUID id = message.getSessionId();
            sessionId = new UUID(id.getMostSigBits(), id.getLeastSigBits());
            sessionData = this.myMessageHandlers.get(sessionId);
            if (sessionData != null) {
                sessionData.channel = context.channel();
                context.attr(SESSION_DATA).set((Object)sessionData);
            }
            if (this.myCanceledSessions.contains(sessionId)) {
                context.channel().writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)CmdlineProtoUtil.createCancelCommand()));
            }
        } else {
            sessionId = sessionData.sessionId;
        }
        BuilderMessageHandler builderMessageHandler = handler = sessionData != null ? sessionData.handler : null;
        if (handler == null) {
            LOG.info("No message handler registered for session " + sessionId);
            return;
        }
        CmdlineRemoteProto.Message.Type messageType = message.getType();
        switch (messageType) {
            case FAILURE: {
                handler.handleFailure(sessionId, message.getFailure());
                break;
            }
            case BUILDER_MESSAGE: {
                CmdlineRemoteProto.Message.BuilderMessage builderMessage = message.getBuilderMessage();
                CmdlineRemoteProto.Message.BuilderMessage.Type msgType = builderMessage.getType();
                if (msgType == CmdlineRemoteProto.Message.BuilderMessage.Type.PARAM_REQUEST) {
                    CmdlineRemoteProto.Message.ControllerMessage params = sessionData.params;
                    if (params != null) {
                        handler.buildStarted(sessionId);
                        sessionData.params = null;
                        context.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)params));
                        break;
                    }
                    this.cancelSession(sessionId);
                    break;
                }
                handler.handleBuildMessage(context.channel(), sessionId, builderMessage);
                break;
            }
            default: {
                LOG.info("Unsupported message type " + messageType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        BuilderMessageHandler handler;
        try {
            super.channelInactive(context);
        }
        catch (Throwable throwable) {
            BuilderMessageHandler handler2;
            SessionData sessionData = (SessionData)context.attr(SESSION_DATA).get();
            if (sessionData != null && (handler2 = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
                handler2.sessionTerminated(sessionData.sessionId);
            }
            throw throwable;
        }
        SessionData sessionData = (SessionData)context.attr(SESSION_DATA).get();
        if (sessionData != null && (handler = this.unregisterBuildMessageHandler(sessionData.sessionId)) != null) {
            handler.sessionTerminated(sessionData.sessionId);
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        if (cause != null) {
            LOG.info(cause);
        }
    }

    private static final class SessionData {
        final UUID sessionId;
        final BuilderMessageHandler handler;
        volatile CmdlineRemoteProto.Message.ControllerMessage params;
        volatile Channel channel;

        private SessionData(UUID sessionId, BuilderMessageHandler handler, CmdlineRemoteProto.Message.ControllerMessage params) {
            this.sessionId = sessionId;
            this.handler = handler;
            this.params = params;
        }
    }
}

