/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.frame.XExecutionStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaExecutionStack
extends XExecutionStack {
    private final ThreadReferenceProxyImpl myThreadProxy;
    private final DebugProcessImpl myDebugProcess;
    private volatile JavaStackFrame myTopFrame;
    private volatile boolean myTopFrameReady;
    private final MethodsTracker myTracker;

    public JavaExecutionStack(@NotNull ThreadReferenceProxyImpl threadProxy, @NotNull DebugProcessImpl debugProcess, boolean current) {
        if (threadProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadProxy", "com/intellij/debugger/engine/JavaExecutionStack", "<init>"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/engine/JavaExecutionStack", "<init>"));
        }
        super(JavaExecutionStack.calcRepresentation(threadProxy), JavaExecutionStack.calcIcon(threadProxy, current));
        this.myTopFrameReady = false;
        this.myTracker = new MethodsTracker();
        this.myThreadProxy = threadProxy;
        this.myDebugProcess = debugProcess;
        if (current) {
            this.myTopFrame = this.calcTopFrame();
        }
    }

    private static Icon calcIcon(ThreadReferenceProxyImpl threadProxy, boolean current) {
        if (current) {
            return AllIcons.Debugger.ThreadCurrent;
        }
        if (threadProxy.getThreadReference().isAtBreakpoint()) {
            return AllIcons.Debugger.ThreadAtBreakpoint;
        }
        if (threadProxy.isSuspended()) {
            return AllIcons.Debugger.ThreadSuspended;
        }
        return AllIcons.Debugger.ThreadRunning;
    }

    @NotNull
    ThreadReferenceProxyImpl getThreadProxy() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.myThreadProxy;
        if (threadReferenceProxyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaExecutionStack", "getThreadProxy"));
        }
        return threadReferenceProxyImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaStackFrame calcTopFrame() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            StackFrameProxyImpl frame = this.myThreadProxy.frame(0);
            if (frame != null) {
                JavaStackFrame javaStackFrame = new JavaStackFrame(frame, this.myTracker);
                return javaStackFrame;
            }
        }
        catch (EvaluateException e) {
            e.printStackTrace();
        }
        finally {
            this.myTopFrameReady = true;
        }
        return null;
    }

    @Nullable
    public JavaStackFrame getTopFrame() {
        assert (this.myTopFrameReady) : "Top frame must be already calculated here";
        return this.myTopFrame;
    }

    public void computeStackFrames(final int firstFrameIndex, final XExecutionStack.XStackFrameContainer container) {
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction() {
                if (!JavaExecutionStack.this.myThreadProxy.isCollected() && JavaExecutionStack.this.myDebugProcess.getSuspendManager().isSuspended(JavaExecutionStack.this.myThreadProxy)) {
                    int status = JavaExecutionStack.this.myThreadProxy.status();
                    if (status != -1 && status != 5 && status != 0) {
                        try {
                            int added = 0;
                            Iterator<StackFrameProxyImpl> iterator = JavaExecutionStack.this.myThreadProxy.frames().iterator();
                            if (iterator.hasNext() && firstFrameIndex > 0) {
                                iterator.next();
                                ++added;
                            }
                            JavaExecutionStack.this.myDebugProcess.getManagerThread().schedule(new AppendFrameCommand(this.getSuspendContext(), iterator, container, added, firstFrameIndex));
                        }
                        catch (EvaluateException e) {
                            container.errorOccurred(e.getMessage());
                        }
                    }
                } else {
                    container.errorOccurred(DebuggerBundle.message((String)"frame.panel.frames.not.available", (Object[])new Object[0]));
                }
            }
        });
    }

    private static String calcRepresentation(ThreadReferenceProxyImpl thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        String name = thread.name();
        ThreadGroupReferenceProxyImpl gr = thread.threadGroupProxy();
        String grname = gr != null ? gr.name() : null;
        String threadStatusText = DebuggerUtilsEx.getThreadStatusText(thread.status());
        if (grname != null && !"SYSTEM".equalsIgnoreCase(grname)) {
            return DebuggerBundle.message((String)"label.thread.node.in.group", (Object[])new Object[]{name, thread.uniqueID(), threadStatusText, grname});
        }
        return DebuggerBundle.message((String)"label.thread.node", (Object[])new Object[]{name, thread.uniqueID(), threadStatusText});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JavaExecutionStack stack = (JavaExecutionStack)((Object)o);
        return this.myThreadProxy.equals(stack.myThreadProxy);
    }

    public int hashCode() {
        return this.myThreadProxy.hashCode();
    }

    private class AppendFrameCommand
    extends SuspendContextCommandImpl {
        private final Iterator<StackFrameProxyImpl> myStackFramesIterator;
        private final XExecutionStack.XStackFrameContainer myContainer;
        private int myAdded;
        private final int mySkip;

        public AppendFrameCommand(SuspendContextImpl suspendContext, Iterator<StackFrameProxyImpl> stackFramesIterator, XExecutionStack.XStackFrameContainer container, int added, int skip) {
            super(suspendContext);
            this.myStackFramesIterator = stackFramesIterator;
            this.myContainer = container;
            this.myAdded = added;
            this.mySkip = skip;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return this.myAdded <= 10 ? PrioritizedTask.Priority.NORMAL : PrioritizedTask.Priority.LOW;
        }

        @Override
        public void contextAction() throws Exception {
            if (this.myStackFramesIterator.hasNext()) {
                JavaStackFrame frame;
                boolean first;
                boolean bl = first = this.myAdded == 0;
                if (first && JavaExecutionStack.this.myTopFrameReady) {
                    frame = JavaExecutionStack.this.myTopFrame;
                    this.myStackFramesIterator.next();
                } else {
                    frame = new JavaStackFrame(this.myStackFramesIterator.next(), JavaExecutionStack.this.myTracker);
                    if (first && !JavaExecutionStack.this.myTopFrameReady) {
                        JavaExecutionStack.this.myTopFrame = frame;
                        JavaExecutionStack.this.myTopFrameReady = true;
                    }
                }
                if ((first || DebuggerSettings.getInstance().SHOW_LIBRARY_STACKFRAMES || !frame.getDescriptor().isSynthetic() && !frame.getDescriptor().isInLibraryContent()) && ++this.myAdded > this.mySkip) {
                    this.myContainer.addStackFrames(Arrays.asList(frame), false);
                }
                JavaExecutionStack.this.myDebugProcess.getManagerThread().schedule(new AppendFrameCommand(this.getSuspendContext(), this.myStackFramesIterator, this.myContainer, this.myAdded, this.mySkip));
            } else {
                this.myContainer.addStackFrames(Collections.emptyList(), true);
            }
        }
    }
}

