/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.CustomRenderedTreeNode;
import com.intellij.dvcs.push.ui.EditableTreeNode;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.TooltipNode;
import com.intellij.dvcs.push.ui.VcsBranchEditorListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class PushLog
extends JPanel
implements TypeSafeDataProvider {
    private static final String START_EDITING = "startEditing";
    private final ChangesBrowser myChangesBrowser;
    private final CheckboxTree myTree;
    private final MyTreeCellRenderer myTreeCellRenderer;
    private boolean myShouldRepaint = false;

    public PushLog(Project project, final CheckedTreeNode root) {
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        treeModel.nodeStructureChanged((TreeNode)root);
        this.myTreeCellRenderer = new MyTreeCellRenderer();
        this.myTree = new CheckboxTree(this.myTreeCellRenderer, root){

            public boolean isPathEditable(TreePath path) {
                return this.isEditable() && path.getLastPathComponent() instanceof DefaultMutableTreeNode;
            }

            protected void onNodeStateChanged(CheckedTreeNode node) {
                if (node instanceof EditableTreeNode) {
                    ((EditableTreeNode)node).fireOnSelectionChange(node.isChecked());
                }
            }

            public String getToolTipText(MouseEvent event) {
                TreePath path = PushLog.this.myTree.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return "";
                }
                Object node = path.getLastPathComponent();
                if (node == null || !(node instanceof DefaultMutableTreeNode)) {
                    return "";
                }
                if (node instanceof TooltipNode) {
                    return ((TooltipNode)node).getTooltip();
                }
                return "";
            }

            public boolean stopEditing() {
                JComponent editedComponent;
                InputVerifier verifier;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode && (verifier = (editedComponent = (JComponent)node.getUserObject()).getInputVerifier()) != null && !verifier.verify(editedComponent)) {
                    return false;
                }
                boolean result = super.stopEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root);
                }
                return result;
            }

            public void cancelEditing() {
                super.cancelEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root);
                }
            }
        };
        this.myTree.setBorder(new EmptyBorder(2, 0, 0, 0));
        this.myTree.setEditable(true);
        this.myTree.setHorizontalAutoScrollingEnabled(false);
        this.myTree.setShowsRootHandles(root.getChildCount() > 1);
        MyTreeCellEditor treeCellEditor = new MyTreeCellEditor();
        this.myTree.setCellEditor(treeCellEditor);
        treeCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node != null && node instanceof EditableTreeNode) {
                    ((EditableTreeNode)((Object)node)).fireOnChange();
                }
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node != null && node instanceof EditableTreeNode) {
                    ((EditableTreeNode)((Object)node)).fireOnCancel();
                }
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }
        });
        this.myTree.setRootVisible(false);
        TreeUtil.collapseAll((JTree)((Object)this.myTree), (int)1);
        VcsBranchEditorListener linkMouseListener = new VcsBranchEditorListener(this.myTreeCellRenderer);
        linkMouseListener.installOn((Component)((Object)this.myTree));
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PushLog.this.updateChangesView();
            }
        });
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(113, 0), START_EDITING);
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "");
        this.myTree.setRowHeight(0);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        this.myChangesBrowser = new ChangesBrowser(project, null, Collections.<Change>emptyList(), null, false, true, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(CommonShortcuts.getDiff(), (JComponent)((Object)this.myTree));
        this.myChangesBrowser.addToolbarAction(this.createEditSourceAction());
        this.setDefaultEmptyText();
        Splitter splitter = new Splitter(false, 0.7f);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree)));
        splitter.setSecondComponent((JComponent)this.myChangesBrowser);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter);
    }

    @NotNull
    private EditSourceAction createEditSourceAction() {
        EditSourceAction editAction = new EditSourceAction();
        editAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this.myChangesBrowser.getViewer());
        editAction.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
        editAction.getTemplatePresentation().setText("Edit Source");
        editAction.getTemplatePresentation().setDescription(ActionsBundle.actionText((String)"EditSource"));
        EditSourceAction editSourceAction = editAction;
        if (editSourceAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "createEditSourceAction"));
        }
        return editSourceAction;
    }

    private void updateChangesView() {
        int[] rows = this.myTree.getSelectionRows();
        if (rows != null && rows.length != 0) {
            this.myChangesBrowser.getViewer().setEmptyText("No differences");
            this.myChangesBrowser.setChangesToDisplay(this.collectAllChanges(rows));
        } else {
            this.setDefaultEmptyText();
            this.myChangesBrowser.setChangesToDisplay(Collections.<Change>emptyList());
        }
    }

    @NotNull
    private List<Change> collectAllChanges(@NotNull int[] selectedRows) {
        if (selectedRows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedRows", "com/intellij/dvcs/push/ui/PushLog", "collectAllChanges"));
        }
        List<DefaultMutableTreeNode> selectedNodes = this.getNodesForRows(PushLog.getSortedRows(selectedRows));
        List<CommitNode> commitNodes = PushLog.collectSelectedCommitNodes(selectedNodes);
        List<Change> list = CommittedChangesTreeBrowser.zipChanges(PushLog.collectChanges(commitNodes));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "collectAllChanges"));
        }
        return list;
    }

    @NotNull
    private static List<CommitNode> collectSelectedCommitNodes(@NotNull List<DefaultMutableTreeNode> selectedNodes) {
        if (selectedNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNodes", "com/intellij/dvcs/push/ui/PushLog", "collectSelectedCommitNodes"));
        }
        ArrayList nodes = ContainerUtil.newArrayList();
        for (DefaultMutableTreeNode node : selectedNodes) {
            if (node instanceof RepositoryNode) {
                nodes.addAll(PushLog.getChildNodes((RepositoryNode)((Object)node)));
                continue;
            }
            if (!(node instanceof CommitNode) || nodes.contains(node)) continue;
            nodes.add((CommitNode)node);
        }
        ArrayList arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "collectSelectedCommitNodes"));
        }
        return arrayList;
    }

    @NotNull
    private static List<Change> collectChanges(@NotNull List<CommitNode> commitNodes) {
        if (commitNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitNodes", "com/intellij/dvcs/push/ui/PushLog", "collectChanges"));
        }
        ArrayList changes = ContainerUtil.newArrayList();
        for (CommitNode node : commitNodes) {
            changes.addAll(node.getUserObject().getChanges());
        }
        ArrayList arrayList = changes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "collectChanges"));
        }
        return arrayList;
    }

    @NotNull
    private static List<CommitNode> getChildNodes(@NotNull RepositoryNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/ui/PushLog", "getChildNodes"));
        }
        ArrayList nodes = ContainerUtil.newArrayList();
        if (node.getChildCount() < 1) {
            ArrayList arrayList = nodes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getChildNodes"));
            }
            return arrayList;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getFirstChild();
        while (childNode != null) {
            if (childNode instanceof CommitNode) {
                nodes.add(0, (CommitNode)childNode);
            }
            childNode = (DefaultMutableTreeNode)node.getChildAfter(childNode);
        }
        ArrayList arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getChildNodes"));
        }
        return arrayList;
    }

    private void setDefaultEmptyText() {
        this.myChangesBrowser.getViewer().setEmptyText("No commits selected");
    }

    public void calcData(DataKey key, DataSink sink) {
        int[] rows;
        if (VcsDataKeys.CHANGES.equals(key) && (rows = this.myTree.getSelectionRows()) != null && rows.length != 0) {
            List<Change> changes = this.collectAllChanges(rows);
            sink.put(key, (Object)ArrayUtil.toObjectArray(changes, Change.class));
        }
    }

    @NotNull
    private static List<Integer> getSortedRows(@NotNull int[] rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/dvcs/push/ui/PushLog", "getSortedRows"));
        }
        ArrayList sorted = ContainerUtil.newArrayList();
        for (int row : rows) {
            sorted.add(row);
        }
        Collections.sort(sorted, Collections.reverseOrder());
        ArrayList arrayList = sorted;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getSortedRows"));
        }
        return arrayList;
    }

    @NotNull
    private List<DefaultMutableTreeNode> getNodesForRows(@NotNull List<Integer> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/dvcs/push/ui/PushLog", "getNodesForRows"));
        }
        ArrayList nodes = ContainerUtil.newArrayList();
        for (Integer row : rows) {
            TreePath path = this.myTree.getPathForRow(row);
            Object pathComponent = path == null ? null : path.getLastPathComponent();
            if (!(pathComponent instanceof DefaultMutableTreeNode)) continue;
            nodes.add((DefaultMutableTreeNode)pathComponent);
        }
        ArrayList arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getNodesForRows"));
        }
        return arrayList;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 10 && e.getModifiers() == 0 && pressed) {
            if (this.myTree.isEditing()) {
                this.myTree.stopEditing();
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myTree.getLastSelectedPathComponent();
                if (node != null) {
                    this.myTree.startEditingAtPath(TreeUtil.getPathFromRoot((TreeNode)node));
                }
            }
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @NotNull
    public JTree getTree() {
        CheckboxTree checkboxTree = this.myTree;
        if (checkboxTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getTree"));
        }
        return checkboxTree;
    }

    public void selectIfNothingSelected(@NotNull TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/ui/PushLog", "selectIfNothingSelected"));
        }
        if (this.myTree.isSelectionEmpty()) {
            this.myTree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    public void setChildren(@NotNull DefaultMutableTreeNode parentNode, @NotNull Collection<? extends DefaultMutableTreeNode> childrenNodes) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/dvcs/push/ui/PushLog", "setChildren"));
        }
        if (childrenNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childrenNodes", "com/intellij/dvcs/push/ui/PushLog", "setChildren"));
        }
        parentNode.removeAllChildren();
        for (DefaultMutableTreeNode defaultMutableTreeNode : childrenNodes) {
            parentNode.add(defaultMutableTreeNode);
        }
        if (!this.myTree.isEditing()) {
            this.refreshNode(parentNode);
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)parentNode);
            if (this.myTree.getSelectionModel().isPathSelected(path)) {
                this.updateChangesView();
            }
        } else {
            this.myShouldRepaint = true;
        }
    }

    private void refreshNode(@NotNull DefaultMutableTreeNode parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/dvcs/push/ui/PushLog", "refreshNode"));
        }
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        model.nodeStructureChanged(parentNode);
        this.expandSelected(parentNode);
        this.myShouldRepaint = false;
    }

    private void expandSelected(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/ui/PushLog", "expandSelected"));
        }
        if (node.getChildCount() <= 0) {
            return;
        }
        if (node instanceof RepositoryNode) {
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
            this.myTree.expandPath(path);
            return;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getFirstChild();
        while (childNode != null) {
            if (!(childNode instanceof RepositoryNode)) {
                return;
            }
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)childNode);
            if (((RepositoryNode)((Object)childNode)).isChecked()) {
                this.myTree.expandPath(path);
            }
            childNode = (DefaultMutableTreeNode)node.getChildAfter(childNode);
        }
    }

    private static class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value instanceof DefaultMutableTreeNode)) {
                return;
            }
            this.myCheckbox.setBorder(null);
            if (value instanceof RepositoryNode) {
                this.myCheckbox.setVisible(((RepositoryNode)value).isCheckboxVisible());
            }
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            if (value instanceof CustomRenderedTreeNode) {
                ((CustomRenderedTreeNode)value).render(renderer);
            } else {
                renderer.append(userObject == null ? "" : userObject.toString());
            }
        }
    }

    private class MyTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private RepositoryWithBranchPanel myValue;

        private MyTreeCellEditor() {
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            RepositoryWithBranchPanel panel;
            this.myValue = panel = (RepositoryWithBranchPanel)((Object)((DefaultMutableTreeNode)value).getUserObject());
            PushLog.this.myTree.firePropertyChange("tree.edit.mode", false, true);
            return panel.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row, true);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)anEvent;
                TreePath path = PushLog.this.myTree.getClosestPathForLocation(me.getX(), me.getY());
                int row = PushLog.this.myTree.getRowForLocation(me.getX(), me.getY());
                PushLog.this.myTree.getCellRenderer().getTreeCellRendererComponent((JTree)((Object)PushLog.this.myTree), path.getLastPathComponent(), false, false, true, row, true);
                Object tag = me.getClickCount() >= 1 ? PushLogTreeUtil.getTagAtForRenderer(PushLog.this.myTreeCellRenderer, me) : null;
                return tag instanceof PushTargetPanel;
            }
            TreePath treePath = PushLog.this.myTree.getAnchorSelectionPath();
            if (treePath == null) {
                return true;
            }
            Object treeNode = treePath.getLastPathComponent();
            return treeNode instanceof EditableTreeNode;
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }
    }
}

