/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.ProjectFacetManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectFacetManager", storages={@Storage(file="$PROJECT_FILE$")})
public class ProjectFacetManagerImpl
extends ProjectFacetManagerEx
implements PersistentStateComponent<ProjectFacetManagerState> {
    @NonNls
    public static final String COMPONENT_NAME = "ProjectFacetManager";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ProjectFacetManagerImpl");
    private ProjectFacetManagerState myState = new ProjectFacetManagerState();
    private final Project myProject;
    private final ConcurrentHashMap<FacetTypeId<?>, ParameterizedCachedValue<Boolean, FacetTypeId<?>>> myCachedHasFacets = new ConcurrentHashMap();
    private final ParameterizedCachedValueProvider<Boolean, FacetTypeId<?>> myCachedValueProvider;

    public ProjectFacetManagerImpl(Project project) {
        this.myProject = project;
        this.myCachedValueProvider = new ParameterizedCachedValueProvider<Boolean, FacetTypeId<?>>(){

            public CachedValueProvider.Result<Boolean> compute(FacetTypeId<?> param) {
                boolean result = false;
                for (Module module : ModuleManager.getInstance((Project)ProjectFacetManagerImpl.this.myProject).getModules()) {
                    if (FacetManager.getInstance((Module)module).getFacetsByType(param).isEmpty()) continue;
                    result = true;
                    break;
                }
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{FacetFinder.getInstance((Project)ProjectFacetManagerImpl.this.myProject).getAllFacetsOfTypeModificationTracker(param)});
            }
        };
    }

    public ProjectFacetManagerState getState() {
        return this.myState;
    }

    public void loadState(ProjectFacetManagerState state) {
        this.myState = state;
    }

    @NotNull
    public <F extends Facet> List<F> getFacets(@NotNull FacetTypeId<F> typeId) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/facet/impl/ProjectFacetManagerImpl", "getFacets"));
        }
        List<F> list = this.getFacets(typeId, ModuleManager.getInstance((Project)this.myProject).getModules());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ProjectFacetManagerImpl", "getFacets"));
        }
        return list;
    }

    @NotNull
    public List<Module> getModulesWithFacet(@NotNull FacetTypeId<?> typeId) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/facet/impl/ProjectFacetManagerImpl", "getModulesWithFacet"));
        }
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (FacetManager.getInstance((Module)module).getFacetsByType(typeId).isEmpty()) continue;
            result.add(module);
        }
        ArrayList<Module> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ProjectFacetManagerImpl", "getModulesWithFacet"));
        }
        return arrayList;
    }

    public boolean hasFacets(@NotNull FacetTypeId<?> typeId) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/facet/impl/ProjectFacetManagerImpl", "hasFacets"));
        }
        ParameterizedCachedValue value = (ParameterizedCachedValue)this.myCachedHasFacets.get(typeId);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)this.myProject).createParameterizedCachedValue(this.myCachedValueProvider, false);
            this.myCachedHasFacets.put(typeId, (Object)value);
        }
        return (Boolean)value.getValue(typeId);
    }

    public <F extends Facet> List<F> getFacets(@NotNull FacetTypeId<F> typeId, Module[] modules) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/facet/impl/ProjectFacetManagerImpl", "getFacets"));
        }
        ArrayList result = new ArrayList();
        for (Module module : modules) {
            result.addAll(FacetManager.getInstance((Module)module).getFacetsByType(typeId));
        }
        return result;
    }

    public <C extends FacetConfiguration> C createDefaultConfiguration(@NotNull FacetType<?, C> facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/facet/impl/ProjectFacetManagerImpl", "createDefaultConfiguration"));
        }
        FacetConfiguration configuration = facetType.createDefaultConfiguration();
        DefaultFacetConfigurationState state = this.myState.getDefaultConfigurations().get(facetType.getStringId());
        if (state != null) {
            Element defaultConfiguration = state.getDefaultConfiguration();
            try {
                FacetUtil.loadFacetConfiguration(configuration, defaultConfiguration);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
            }
        }
        return (C)configuration;
    }

    public <C extends FacetConfiguration> void setDefaultConfiguration(@NotNull FacetType<?, C> facetType, @NotNull C configuration) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/facet/impl/ProjectFacetManagerImpl", "setDefaultConfiguration"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/facet/impl/ProjectFacetManagerImpl", "setDefaultConfiguration"));
        }
        Map<String, DefaultFacetConfigurationState> defaultConfigurations = this.myState.getDefaultConfigurations();
        DefaultFacetConfigurationState state = defaultConfigurations.get(facetType.getStringId());
        if (state == null) {
            state = new DefaultFacetConfigurationState();
            defaultConfigurations.put(facetType.getStringId(), state);
        }
        try {
            Element element = FacetUtil.saveFacetConfiguration(configuration);
            state.setDefaultConfiguration(element);
        }
        catch (WriteExternalException e) {
            LOG.info((Throwable)e);
        }
    }

    public static class ProjectFacetManagerState {
        private Map<String, DefaultFacetConfigurationState> myDefaultConfigurations = new HashMap<String, DefaultFacetConfigurationState>();

        @Tag(value="default-configurations")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, keyAttributeName="facet-type")
        public Map<String, DefaultFacetConfigurationState> getDefaultConfigurations() {
            return this.myDefaultConfigurations;
        }

        public void setDefaultConfigurations(Map<String, DefaultFacetConfigurationState> defaultConfigurations) {
            this.myDefaultConfigurations = defaultConfigurations;
        }
    }

    @Tag(value="default-facet-configuration")
    public static class DefaultFacetConfigurationState {
        private Element myDefaultConfiguration;

        @Tag(value="configuration")
        public Element getDefaultConfiguration() {
            return this.myDefaultConfiguration;
        }

        public void setDefaultConfiguration(Element defaultConfiguration) {
            this.myDefaultConfiguration = defaultConfiguration;
        }
    }
}

