/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import javax.swing.Icon;

public class ReloadFromDiskAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (project == null || editor == null) {
            return;
        }
        final PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return;
        }
        String message = IdeBundle.message((String)"prompt.reload.file.from.disk", (Object[])new Object[]{file.getVirtualFile().getPresentableUrl()});
        int res = Messages.showOkCancelDialog((Project)project, (String)message, (String)IdeBundle.message((String)"title.reload.file", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        if (res != 0) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            file.getVirtualFile().refresh(false, false);
                            PsiManager.getInstance((Project)project).reloadFromDisk(file);
                        }
                    }
                });
            }
        };
        CommandProcessor.getInstance().executeCommand(project, command, IdeBundle.message((String)"command.reload.from.disk", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        PsiFile file;
        boolean enabled = false;
        Project project = event.getProject();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(event.getDataContext());
        if (project != null && editor != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null && file.getVirtualFile() != null) {
            enabled = true;
        }
        event.getPresentation().setEnabled(enabled);
    }
}

