/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.extensions.PluginId;
import java.util.ArrayList;
import java.util.Stack;
import org.jetbrains.annotations.NonNls;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class RepositoryContentHandler
extends DefaultHandler {
    @NonNls
    public static final String CATEGORY = "category";
    @NonNls
    public static final String IDEA_PLUGIN = "idea-plugin";
    @NonNls
    public static final String NAME = "name";
    @NonNls
    public static final String ID = "id";
    @NonNls
    public static final String DESCRIPTION = "description";
    @NonNls
    public static final String VERSION = "version";
    @NonNls
    public static final String VENDOR = "vendor";
    @NonNls
    public static final String EMAIL = "email";
    @NonNls
    public static final String URL = "url";
    @NonNls
    public static final String IDEA_VERSION = "idea-version";
    @NonNls
    public static final String SINCE_BUILD = "since-build";
    @NonNls
    private static final String UNTIL_BUILD = "until-build";
    @NonNls
    public static final String CHNAGE_NOTES = "change-notes";
    @NonNls
    private static final String DEPENDS = "depends";
    @NonNls
    private static final String DOWNLOADS = "downloads";
    @NonNls
    private static final String DOWNLOAD_URL = "downloadUrl";
    @NonNls
    private static final String DOWNLOAD_URL_NEW_STYLE = "download-url";
    @NonNls
    private static final String SIZE = "size";
    @NonNls
    private static final String RATING = "rating";
    @NonNls
    private static final String DATE = "date";
    private PluginNode currentPlugin;
    private final StringBuilder currentValue = new StringBuilder();
    private ArrayList<IdeaPluginDescriptor> plugins;
    private Stack<String> categoriesStack;

    RepositoryContentHandler() {
    }

    @Override
    public void startDocument() throws SAXException {
        this.plugins = new ArrayList();
        this.categoriesStack = new Stack();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals(CATEGORY)) {
            this.categoriesStack.push(atts.getValue(NAME));
        } else if (qName.equals(IDEA_PLUGIN)) {
            String categoryName = this.constructCategoryTree();
            this.currentPlugin = new PluginNode();
            this.currentPlugin.setCategory(categoryName);
            this.currentPlugin.setDownloads(atts.getValue(DOWNLOADS));
            this.currentPlugin.setSize(atts.getValue(SIZE));
            this.currentPlugin.setUrl(atts.getValue(URL));
            String dateString = atts.getValue(DATE);
            if (dateString != null) {
                this.currentPlugin.setDate(dateString);
            }
            this.plugins.add(this.currentPlugin);
        } else if (qName.equals(IDEA_VERSION)) {
            this.currentPlugin.setSinceBuild(atts.getValue(SINCE_BUILD));
            this.currentPlugin.setUntilBuild(atts.getValue(UNTIL_BUILD));
        } else if (qName.equals(VENDOR)) {
            this.currentPlugin.setVendorEmail(atts.getValue(EMAIL));
            this.currentPlugin.setVendorUrl(atts.getValue(URL));
        }
        this.currentValue.setLength(0);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String currentValueString = this.currentValue.toString();
        this.currentValue.setLength(0);
        if (qName.equals(ID)) {
            this.currentPlugin.setId(currentValueString);
        } else if (qName.equals(NAME)) {
            this.currentPlugin.setName(currentValueString);
        } else if (qName.equals(DESCRIPTION)) {
            this.currentPlugin.setDescription(currentValueString);
        } else if (qName.equals(VERSION)) {
            this.currentPlugin.setVersion(currentValueString);
        } else if (qName.equals(VENDOR)) {
            this.currentPlugin.setVendor(currentValueString);
        } else if (qName.equals(DEPENDS)) {
            this.currentPlugin.addDepends(PluginId.getId((String)currentValueString));
        } else if (qName.equals(CHNAGE_NOTES)) {
            this.currentPlugin.setChangeNotes(currentValueString);
        } else if (qName.equals(CATEGORY)) {
            this.categoriesStack.pop();
        } else if (qName.equals(RATING)) {
            this.currentPlugin.setRating(currentValueString);
        } else if (qName.equals(DOWNLOAD_URL) || qName.equals(DOWNLOAD_URL_NEW_STYLE)) {
            this.currentPlugin.setDownloadUrl(currentValueString);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentValue.append(ch, start, length);
    }

    public ArrayList<IdeaPluginDescriptor> getPluginsList() {
        return this.plugins;
    }

    private String constructCategoryTree() {
        StringBuilder category = new StringBuilder();
        for (int i = 0; i < this.categoriesStack.size(); ++i) {
            String str = (String)this.categoriesStack.get(i);
            if (str.length() <= 0) continue;
            if (i > 0) {
                category.append("/");
            }
            category.append(str);
        }
        return category.toString();
    }
}

