/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;

public class DarculaEditorTextFieldBorder
implements Border {
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (DarculaEditorTextFieldBorder.isComboBoxEditor(c)) {
            g.setColor(c.getBackground());
            g.fillRect(x, y, width, height);
            return;
        }
        EditorTextField textField = (EditorTextField)UIUtil.getParentOfType(EditorTextField.class, (Component)c);
        if (textField == null) {
            return;
        }
        int x1 = x + 3;
        int y1 = y + 3;
        int width1 = width - 8;
        int height1 = height - 6;
        if (c.isOpaque()) {
            g.setColor(UIUtil.getPanelBackground());
            g.fillRect(x, y, width, height);
        }
        g.setColor(c.getBackground());
        g.fillRect(x1, y1, width1, height1);
        if (!textField.isEnabled()) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        if (textField.isEnabled() && textField.isVisible() && textField.getFocusTarget().hasFocus()) {
            DarculaUIUtil.paintFocusRing(g, x1, y1, width1, height1);
        } else {
            g.setColor((Color)new JBColor((Color)Gray._150, (Color)Gray._100));
            g.drawRect(x1, y1, width1, height1);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarculaEditorTextFieldBorder.isComboBoxEditor(c)) {
            return new InsetsUIResource(2, 3, 2, 3);
        }
        return new InsetsUIResource(6, 7, 6, 7);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public static boolean isComboBoxEditor(Component c) {
        return UIUtil.getParentOfType(JComboBox.class, (Component)c) != null;
    }

    public static boolean isCellEditor(Component c) {
        return UIUtil.getParentOfType(JTable.class, (Component)c) != null;
    }
}

