/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.DirectoryStorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.store.StateStorageBase;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryBasedStorage
extends StateStorageBase {
    private final File myDir;
    private final StateSplitter mySplitter;
    private DirectoryStorageData myStorageData;

    public DirectoryBasedStorage(@Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @NotNull String dir, @NotNull StateSplitter splitter, @NotNull Disposable parentDisposable, final @Nullable StateStorage.Listener listener) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        if (splitter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        super(pathMacroSubstitutor);
        this.myDir = new File(dir);
        this.mySplitter = splitter;
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)ServiceManager.getService(VirtualFileTracker.class);
        if (virtualFileTracker != null && listener != null) {
            virtualFileTracker.addTracker("file://" + this.myDir.getAbsolutePath().replace(File.separatorChar, '/'), (VirtualFileListener)new VirtualFileAdapter(){

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$1", "contentsChanged"));
                    }
                    this.notifyIfNeed(event);
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$1", "fileDeleted"));
                    }
                    this.notifyIfNeed(event);
                }

                public void fileCreated(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$1", "fileCreated"));
                    }
                    this.notifyIfNeed(event);
                }

                private void notifyIfNeed(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$1", "notifyIfNeed"));
                    }
                    if (event.getFile().isDirectory() || DirectoryStorageData.isStorageFile(event.getFile())) {
                        listener.storageFileChanged(event, (StateStorage)DirectoryBasedStorage.this);
                    }
                }
            }, false, parentDisposable);
        }
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Collection<VirtualFile> changedFiles, @NotNull Set<String> result) {
        DirectoryStorageData newData;
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        DirectoryStorageData oldData = this.myStorageData;
        this.myStorageData = newData = this.loadState();
        if (oldData == null) {
            result.addAll(newData.getComponentNames());
        } else {
            result.addAll(oldData.getComponentNames());
            result.addAll(newData.getComponentNames());
        }
    }

    @Nullable
    public <T> T getState(Object component, @NotNull String componentName, @NotNull Class<T> stateClass, @Nullable T mergeInto) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "getState"));
        }
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "getState"));
        }
        if (this.myStorageData == null) {
            this.myStorageData = this.loadState();
        }
        if (!this.myStorageData.containsComponent(componentName)) {
            return DefaultStateSerializer.deserializeState(new Element("component"), stateClass, mergeInto);
        }
        return this.myStorageData.getMergedState(componentName, stateClass, this.mySplitter, mergeInto);
    }

    private DirectoryStorageData loadState() {
        DirectoryStorageData storageData = new DirectoryStorageData();
        storageData.loadFrom(LocalFileSystem.getInstance().findFileByIoFile(this.myDir), this.myPathMacroSubstitutor);
        return storageData;
    }

    public boolean hasState(@Nullable Object component, @NotNull String componentName, Class<?> aClass, boolean reloadData) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "hasState"));
        }
        if (this.myStorageData == null && !this.myDir.exists()) {
            return false;
        }
        if (reloadData) {
            this.myStorageData = null;
        }
        return true;
    }

    @Nullable
    public StateStorage.ExternalizationSession startExternalization() {
        return this.checkIsSavingDisabled() ? null : new MySaveSession(this);
    }

    @Nullable
    public StateStorage.SaveSession startSave(@NotNull StateStorage.ExternalizationSession externalizationSession) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizationSession", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "startSave"));
        }
        return this.checkIsSavingDisabled() ? null : (MySaveSession)externalizationSession;
    }

    private static class MySaveSession
    implements StateStorage.SaveSession,
    StateStorage.ExternalizationSession {
        private final DirectoryBasedStorage myStorage;
        private final DirectoryStorageData myStorageData;

        private MySaveSession(@NotNull DirectoryBasedStorage storage) {
            if (storage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "<init>"));
            }
            this.myStorage = storage;
            this.myStorageData = storage.myStorageData == null ? storage.loadState() : storage.myStorageData.clone();
        }

        public void setState(@NotNull Object component, @NotNull String componentName, @NotNull Object state, Storage storageSpec) {
            Element element;
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "setState"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "setState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "setState"));
            }
            try {
                element = DefaultStateSerializer.serializeState(state, storageSpec);
            }
            catch (WriteExternalException e) {
                throw new StateStorageException((Throwable)e);
            }
            catch (Throwable e) {
                LOG.info("Unable to serialize component state!", e);
                return;
            }
            if (element != null) {
                for (Pair pair : this.myStorage.mySplitter.splitState(element)) {
                    Element e = (Element)pair.first;
                    String name = (String)pair.second;
                    Element statePart = new Element("component");
                    statePart.setAttribute("name", componentName);
                    statePart.addContent(e.detach());
                    this.myStorageData.put(componentName, new File(this.myStorage.myDir, name), statePart, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() {
            VirtualFile dir = LocalFileSystem.getInstance().findFileByIoFile(this.myStorage.myDir);
            SmartHashSet existingFileNames = new SmartHashSet();
            for (String componentName : this.myStorageData.getComponentNames()) {
                this.myStorageData.processComponent(componentName, new TObjectObjectProcedure<File, Element>((Set)existingFileNames, dir){
                    final /* synthetic */ Set val$existingFileNames;
                    final /* synthetic */ VirtualFile val$dir;
                    {
                        this.val$existingFileNames = set;
                        this.val$dir = virtualFile;
                    }

                    public boolean execute(File file, Element element) {
                        String fileName = file.getName();
                        this.val$existingFileNames.add(fileName);
                        if (MySaveSession.this.myStorage.myPathMacroSubstitutor != null) {
                            MySaveSession.this.myStorage.myPathMacroSubstitutor.collapsePaths(element);
                        }
                        if (file.lastModified() <= MySaveSession.this.myStorageData.getLastTimeStamp()) {
                            StorageUtil.save(file, (Parent)element, MySaveSession.this, false, this.val$dir == null ? null : this.val$dir.findChild(fileName));
                            MySaveSession.this.myStorageData.updateLastTimestamp(file);
                        }
                        return true;
                    }
                });
            }
            if (dir != null && dir.exists()) {
                FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                AccessToken token = WriteAction.start();
                try {
                    for (VirtualFile file : dir.getChildren()) {
                        String fileName = file.getName();
                        if (fileTypeManager.isFileIgnored(fileName) || !DirectoryStorageData.isStorageFile(file) || existingFileNames.contains(fileName)) continue;
                        if (file.getTimeStamp() > this.myStorageData.getLastTimeStamp()) {
                            return;
                        }
                        try {
                            LOG.debug("Removing configuration file: " + file.getPresentableUrl());
                            file.delete((Object)this);
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                finally {
                    token.finish();
                }
            }
            this.myStorage.myStorageData = this.myStorageData;
        }
    }
}

