/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ZipperUpdater;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeOutdatedException;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.FileAndDocumentListenersForShortDiff;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ShortDiffDetails;
import com.intellij.openapi.vcs.changes.VcsChangeDetailsManager;
import com.intellij.openapi.vcs.changes.actions.IgnoredSettingsAction;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesViewManager
implements ChangesViewI,
JDOMExternalizable,
ProjectComponent {
    public static final int UNVERSIONED_MAX_SIZE = 50;
    private boolean SHOW_FLATTEN_MODE = true;
    private boolean SHOW_IGNORED_MODE = false;
    private final ChangesListView myView;
    private JPanel myProgressLabel;
    private final Alarm myRepaintAlarm;
    private boolean myDisposed = false;
    private final ChangeListListener myListener = new MyChangeListListener();
    private final Project myProject;
    private final ChangesViewContentManager myContentManager;
    @NonNls
    private static final String ATT_FLATTENED_VIEW = "flattened_view";
    @NonNls
    private static final String ATT_SHOW_IGNORED = "show_ignored";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangesViewManager");
    private Splitter mySplitter;
    private boolean myDetailsOn;
    private FilePath myDetailsFilePath;
    private ZipperUpdater myDetailsUpdater;
    private Runnable myUpdateDetails;
    private MessageBusConnection myConnection;
    private ToggleDetailsAction myToggleDetailsAction;
    private final ShortDiffDetails myDiffDetails;
    private final TreeSelectionListener myTsl;
    private final FileAndDocumentListenersForShortDiff myListenersForShortDiff;
    private Content myContent;
    private Change[] mySelectedChanges;
    private static final String DETAILS_SPLITTER_PROPORTION = "ChangesViewManager.DETAILS_SPLITTER_PROPORTION";

    public static ChangesViewI getInstance(Project project) {
        return (ChangesViewI)PeriodicalTasksCloser.getInstance().safeGetComponent(project, ChangesViewI.class);
    }

    private boolean shouldUpdateDetailsNow() {
        return this.myContent == null || !this.myDetailsOn || this.myContentManager.isToolwindowVisible() && this.myContentManager.isContentSelected(this.myContent);
    }

    public ChangesViewManager(Project project, ChangesViewContentManager contentManager, VcsChangeDetailsManager vcsChangeDetailsManager) {
        this.myProject = project;
        this.myContentManager = contentManager;
        this.myView = new ChangesListView(project);
        Disposer.register((Disposable)project, (Disposable)this.myView);
        this.myRepaintAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
        this.myDiffDetails = new ShortDiffDetails(this.myProject, new Getter<Change[]>(){

            public Change[] get() {
                return ChangesViewManager.this.myView.getSelectedChanges();
            }
        }, vcsChangeDetailsManager);
        this.myListenersForShortDiff = new FileAndDocumentListenersForShortDiff(this.myDiffDetails){

            @Override
            protected void updateDetails() {
                ChangesViewManager.this.myDetailsUpdater.queue(ChangesViewManager.this.myUpdateDetails);
            }

            @Override
            protected boolean updateSynchronously() {
                if (ChangesViewManager.this.shouldUpdateDetailsNow()) {
                    return ChangesViewManager.this.myDiffDetails.refreshDataSynch();
                }
                return false;
            }
        };
        this.myDiffDetails.setParent((JComponent)((Object)this.myView));
        this.myDetailsUpdater = new ZipperUpdater(300, Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myProject);
        this.myUpdateDetails = new Runnable(){

            @Override
            public void run() {
                if (!ChangesViewManager.this.shouldUpdateDetailsNow()) {
                    ChangesViewManager.this.myDetailsUpdater.queue(this);
                    return;
                }
                ChangesViewManager.this.changeDetails();
            }
        };
        this.myTsl = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object[] selectedChanges = ChangesViewManager.this.myView.getSelectedChanges();
                if (Comparing.equal((Object[])ChangesViewManager.this.mySelectedChanges, (Object[])selectedChanges)) {
                    return;
                }
                ChangesViewManager.access$702(ChangesViewManager.this, (Change[])selectedChanges);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("selection changed. selected:  " + this.toStringPaths(ChangesViewManager.this.myView.getSelectionPaths()) + " from: " + DebugUtil.currentStackTrace());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChangesViewManager.this.changeDetails();
                    }
                });
            }

            private String toStringPaths(TreePath[] paths) {
                if (paths == null) {
                    return "null";
                }
                if (paths.length == 0) {
                    return "empty";
                }
                StringBuilder sb = new StringBuilder();
                for (TreePath path : paths) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(path.toString());
                }
                return sb.toString();
            }
        };
    }

    public void projectOpened() {
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        changeListManager.addChangeListListener(this.myListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                changeListManager.removeChangeListListener(ChangesViewManager.this.myListener);
            }
        });
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        this.myContent = ContentFactory.SERVICE.getInstance().createContent(this.createChangeViewComponent(), "Local", false);
        this.myContent.setCloseable(false);
        this.myContentManager.addContent(this.myContent);
        this.scheduleRefresh();
        this.myConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        this.myConnection.subscribe(RemoteRevisionsCache.REMOTE_VERSION_CHANGED, (Object)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChangesViewManager.this.refreshView();
                    }
                }, ModalityState.NON_MODAL, ChangesViewManager.this.myProject.getDisposed());
            }
        });
    }

    public void projectClosed() {
        PropertiesComponent.getInstance().setValue(DETAILS_SPLITTER_PROPORTION, String.valueOf(this.mySplitter.getProportion()));
        if (this.myToggleDetailsAction.isSelected(null)) {
            this.myListenersForShortDiff.off();
        }
        this.myDiffDetails.dispose();
        this.myView.removeTreeSelectionListener(this.myTsl);
        this.myConnection.disconnect();
        this.myDisposed = true;
        this.myRepaintAlarm.cancelAllRequests();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ChangesViewManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesViewManager", "getComponentName"));
        }
        return "ChangesViewManager";
    }

    private JComponent createChangeViewComponent() {
        SimpleToolWindowPanel panel = new SimpleToolWindowPanel(false, true);
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewToolbar");
        ActionManager.getInstance().getAction("ChangesView.Refresh").registerCustomShortcutSet(CommonShortcuts.getRerun(), (JComponent)panel);
        ActionManager.getInstance().getAction("ChangesView.NewChangeList").registerCustomShortcutSet(CommonShortcuts.getNew(), (JComponent)panel);
        ActionManager.getInstance().getAction("ChangesView.RemoveChangeList").registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)panel);
        AnAction moveToChangeList = ActionManager.getInstance().getAction("ChangesView.Move");
        if (moveToChangeList.getShortcutSet().getShortcuts().length == 0) {
            moveToChangeList.registerCustomShortcutSet(CommonShortcuts.getMove(), (JComponent)panel);
        }
        ActionManager.getInstance().getAction("ChangesView.Rename").registerCustomShortcutSet(CommonShortcuts.getRename(), (JComponent)panel);
        ActionManager.getInstance().getAction("ChangesView.SetDefault").registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(85, 0x200 | ChangesViewManager.ctrlMask())), (JComponent)panel);
        CustomShortcutSet diffShortcut = new CustomShortcutSet(KeyStroke.getKeyStroke(68, ChangesViewManager.ctrlMask()));
        ActionManager.getInstance().getAction("ChangesView.Diff").registerCustomShortcutSet((ShortcutSet)diffShortcut, (JComponent)panel);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)group, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myView));
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarPanel.add((Component)toolbarComponent, "West");
        DefaultActionGroup visualActionsGroup = new DefaultActionGroup();
        Expander expander = new Expander();
        visualActionsGroup.add(CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)expander, (JComponent)panel));
        visualActionsGroup.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)expander, (JComponent)panel));
        ToggleShowFlattenAction showFlattenAction = new ToggleShowFlattenAction();
        showFlattenAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(80, ChangesViewManager.ctrlMask())), (JComponent)panel);
        visualActionsGroup.add((AnAction)showFlattenAction);
        visualActionsGroup.add(ActionManager.getInstance().getAction("$Copy"));
        visualActionsGroup.add((AnAction)new ToggleShowIgnoredAction());
        visualActionsGroup.add((AnAction)new IgnoredSettingsAction());
        this.myToggleDetailsAction = new ToggleDetailsAction();
        visualActionsGroup.add((AnAction)this.myToggleDetailsAction);
        visualActionsGroup.add((AnAction)new ContextHelpAction("ideaInterface.changes"));
        toolbarPanel.add((Component)ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)visualActionsGroup, false).getComponent(), "Center");
        DefaultActionGroup menuGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewPopupMenu");
        this.myView.setMenuActions((ActionGroup)menuGroup);
        this.myView.setShowFlatten(this.SHOW_FLATTEN_MODE);
        this.myProgressLabel = new JPanel(new BorderLayout());
        panel.setToolbar((JComponent)toolbarPanel);
        JPanel content = new JPanel(new BorderLayout());
        String value = PropertiesComponent.getInstance().getValue(DETAILS_SPLITTER_PROPORTION);
        float f = 0.5f;
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            try {
                f = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.mySplitter = new Splitter(false, f);
        this.mySplitter.setHonorComponentsMinimumSize(false);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myView));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)scrollPane, "Center");
        this.mySplitter.setFirstComponent((JComponent)wrapper);
        content.add((Component)this.mySplitter, "Center");
        content.add((Component)this.myProgressLabel, "South");
        panel.setContent((JComponent)content);
        this.myDiffDetails.getPanel();
        this.myView.installDndSupport(ChangeListManagerImpl.getInstanceImpl(this.myProject));
        this.myView.addTreeSelectionListener(this.myTsl);
        return panel;
    }

    private void changeDetails() {
        if (!this.myDetailsOn) {
            if (this.mySplitter.getSecondComponent() != null) {
                this.setChangeDetailsPanel(null);
            }
        } else {
            try {
                this.myDiffDetails.refresh();
            }
            catch (ChangeOutdatedException e) {
                return;
            }
            this.myDetailsFilePath = this.myDiffDetails.getCurrentFilePath();
            if (this.mySplitter.getSecondComponent() == null) {
                this.setChangeDetailsPanel(this.myDiffDetails.getPanel());
            }
        }
    }

    private void setChangeDetailsPanel(@Nullable JComponent component) {
        this.mySplitter.setSecondComponent(component);
        this.mySplitter.getFirstComponent().setBorder(component == null ? null : IdeBorderFactory.createBorder((int)4));
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
    }

    @JdkConstants.InputEventMask
    private static int ctrlMask() {
        return SystemInfo.isMac ? 256 : 128;
    }

    public void updateProgressComponent(final Factory<JComponent> progress) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ChangesViewManager.this.myProgressLabel != null) {
                    ChangesViewManager.this.myProgressLabel.removeAll();
                    ChangesViewManager.this.myProgressLabel.add((Component)progress.create());
                    ChangesViewManager.this.myProgressLabel.setMinimumSize(new Dimension(0, 0));
                }
            }
        });
    }

    @Override
    public void updateProgressText(String text, boolean isError) {
        this.updateProgressComponent(ChangesViewManager.createTextStatusFactory(text, isError));
    }

    @Override
    public void setBusy(final boolean b) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ChangesViewManager.this.myView.setPaintBusy(b);
            }
        });
    }

    public static Factory<JComponent> createTextStatusFactory(final String text, final boolean isError) {
        return new Factory<JComponent>(){

            public JComponent create() {
                JLabel label = new JLabel(text);
                label.setForeground(isError ? Color.red : UIUtil.getLabelForeground());
                return label;
            }
        };
    }

    @Override
    public void scheduleRefresh() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        int was = this.myRepaintAlarm.cancelAllRequests();
        if (LOG.isDebugEnabled()) {
            LOG.debug("schedule refresh, was " + was);
        }
        if (!this.myRepaintAlarm.isDisposed()) {
            this.myRepaintAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ChangesViewManager.this.refreshView();
                }
            }, 100, ModalityState.NON_MODAL);
        }
    }

    void refreshView() {
        if (this.myDisposed || !this.myProject.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!ProjectLevelVcsManager.getInstance((Project)this.myProject).hasActiveVcss()) {
            return;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
        Couple<Integer> unv = changeListManager.getUnversionedFilesSize();
        boolean manyUnversioned = (Integer)unv.getFirst() > 50;
        Trinity unversionedPair = new Trinity(manyUnversioned ? Collections.emptyList() : changeListManager.getUnversionedFiles(), unv.getFirst(), unv.getSecond());
        if (LOG.isDebugEnabled()) {
            LOG.debug("refresh view, unversioned collections size: " + ((List)unversionedPair.getFirst()).size() + " unv size passed: " + unversionedPair.getSecond() + " dirs: " + unversionedPair.getThird());
        }
        this.myView.updateModel(changeListManager.getChangeListsCopy(), (Trinity<List<VirtualFile>, Integer, Integer>)unversionedPair, changeListManager.getDeletedFiles(), changeListManager.getModifiedWithoutEditing(), changeListManager.getSwitchedFilesMap(), changeListManager.getSwitchedRoots(), this.SHOW_IGNORED_MODE ? changeListManager.getIgnoredFiles() : null, changeListManager.getLockedFolders(), changeListManager.getLogicallyLockedFolders());
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.SHOW_FLATTEN_MODE = Boolean.valueOf(element.getAttributeValue(ATT_FLATTENED_VIEW));
        this.SHOW_IGNORED_MODE = Boolean.valueOf(element.getAttributeValue(ATT_SHOW_IGNORED));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(ATT_FLATTENED_VIEW, String.valueOf(this.SHOW_FLATTEN_MODE));
        element.setAttribute(ATT_SHOW_IGNORED, String.valueOf(this.SHOW_IGNORED_MODE));
    }

    @Override
    public void setShowFlattenMode(boolean state) {
        this.SHOW_FLATTEN_MODE = state;
        this.myView.setShowFlatten(this.SHOW_FLATTEN_MODE);
        this.refreshView();
    }

    @Override
    public void selectFile(VirtualFile vFile) {
        if (vFile == null) {
            return;
        }
        Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(vFile);
        Change objectToFind = change != null ? change : vFile;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
        DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)objectToFind);
        if (node != null) {
            TreeUtil.selectNode((JTree)((Object)this.myView), (TreeNode)node);
        }
    }

    @Override
    public void refreshChangesViewNodeAsync(final VirtualFile file) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ChangesViewManager.this.myProject.isDisposed()) {
                    return;
                }
                ChangesViewManager.this.refreshChangesViewNode(file);
            }
        });
    }

    private void refreshChangesViewNode(VirtualFile file) {
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        Object userObject = changeListManager.isUnversioned(file) ? file : changeListManager.getChange(file);
        if (userObject != null && (node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)userObject)) != null) {
            this.myView.getModel().nodeChanged(node);
        }
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    static /* synthetic */ Change[] access$702(ChangesViewManager x0, Change[] x1) {
        x0.mySelectedChanges = x1;
        return x1;
    }

    private class ToggleDetailsAction
    extends ToggleAction
    implements DumbAware {
        private ToggleDetailsAction() {
            super("Preview Diff", null, AllIcons.Actions.PreviewDetails);
        }

        public boolean isSelected(AnActionEvent e) {
            return ChangesViewManager.this.myDetailsOn;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (ChangesViewManager.this.myDetailsOn) {
                ChangesViewManager.this.myListenersForShortDiff.off();
            } else {
                ChangesViewManager.this.myListenersForShortDiff.on();
            }
            ChangesViewManager.this.myDetailsOn = !ChangesViewManager.this.myDetailsOn;
            ChangesViewManager.this.changeDetails();
        }
    }

    public class ToggleShowIgnoredAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowIgnoredAction() {
            super(VcsBundle.message((String)"changes.action.show.ignored.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.ignored.description", (Object[])new Object[0]), AllIcons.Actions.ShowHiddens);
        }

        public boolean isSelected(AnActionEvent e) {
            return ChangesViewManager.this.SHOW_IGNORED_MODE;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ChangesViewManager.this.SHOW_IGNORED_MODE = state;
            ChangesViewManager.this.refreshView();
        }
    }

    public class ToggleShowFlattenAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowFlattenAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), AllIcons.Actions.GroupByPackage);
        }

        public boolean isSelected(AnActionEvent e) {
            return !ChangesViewManager.this.SHOW_FLATTEN_MODE;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ChangesViewManager.this.setShowFlattenMode(!state);
        }
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)ChangesViewManager.this.myView));
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)ChangesViewManager.this.myView), (int)2);
            TreeUtil.expand((JTree)((Object)ChangesViewManager.this.myView), (int)1);
        }

        public boolean canCollapse() {
            return true;
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListAdded(ChangeList list) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListRemoved(ChangeList list) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListRenamed(ChangeList list, String oldName) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListUpdateDone() {
            ChangesViewManager.this.scheduleRefresh();
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(ChangesViewManager.this.myProject);
            VcsException updateException = changeListManager.getUpdateException();
            ChangesViewManager.this.setBusy(false);
            if (updateException == null) {
                ChangesViewManager.this.updateProgressText("", false);
                Factory<JComponent> additionalUpdateInfo = changeListManager.getAdditionalUpdateInfo();
                if (additionalUpdateInfo != null) {
                    ChangesViewManager.this.updateProgressComponent(additionalUpdateInfo);
                }
            } else {
                ChangesViewManager.this.updateProgressText(VcsBundle.message((String)"error.updating.changes", (Object[])new Object[]{updateException.getMessage()}), true);
            }
        }
    }
}

