/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.FragmentContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.BaseLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowLineStatusRangeDiffAction
extends BaseLineStatusRangeAction {
    public ShowLineStatusRangeDiffAction(@NotNull LineStatusTracker lineStatusTracker, @NotNull Range range, @Nullable Editor editor) {
        if (lineStatusTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineStatusTracker", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "<init>"));
        }
        super(VcsBundle.message((String)"action.name.show.difference", (Object[])new Object[0]), AllIcons.Actions.Diff, lineStatusTracker, range);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        DiffManager.getInstance().getDiffTool().show(this.createDiffData());
    }

    private DiffRequest createDiffData() {
        return new DiffRequest(this.myLineStatusTracker.getProject()){

            @NotNull
            public DiffContent[] getContents() {
                Range range = ShowLineStatusRangeDiffAction.expand(ShowLineStatusRangeDiffAction.this.myRange, ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getDocument(), ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getVcsDocument());
                DiffContent[] diffContentArray = new DiffContent[]{ShowLineStatusRangeDiffAction.this.createDiffContent(ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getVcsDocument(), ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getVcsRange(range), null), ShowLineStatusRangeDiffAction.this.createDiffContent(ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getDocument(), ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getCurrentTextRange(range), ShowLineStatusRangeDiffAction.this.myLineStatusTracker.getVirtualFile())};
                if (diffContentArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction$1", "getContents"));
                }
                return diffContentArray;
            }

            public String[] getContentTitles() {
                return new String[]{VcsBundle.message((String)"diff.content.title.up.to.date", (Object[])new Object[0]), VcsBundle.message((String)"diff.content.title.current.range", (Object[])new Object[0])};
            }

            public String getWindowTitle() {
                return VcsBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]);
            }
        };
    }

    @NotNull
    private DiffContent createDiffContent(@NotNull Document uDocument, @NotNull TextRange textRange, @Nullable VirtualFile file) {
        if (uDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uDocument", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "createDiffContent"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "createDiffContent"));
        }
        Project project = this.myLineStatusTracker.getProject();
        DocumentContent diffContent = new DocumentContent(project, uDocument);
        FragmentContent fragmentContent = new FragmentContent((DiffContent)diffContent, textRange, project, file);
        if (fragmentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "createDiffContent"));
        }
        return fragmentContent;
    }

    @NotNull
    private static Range expand(@NotNull Range range, @NotNull Document document, @NotNull Document uDocument) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "expand"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "expand"));
        }
        if (uDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uDocument", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "expand"));
        }
        if (range.getType() == 1) {
            Range range2 = range;
            if (range2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "expand"));
            }
            return range2;
        }
        if (range.getType() == 2 || range.getType() == 3) {
            boolean canExpandBefore = range.getLine1() != 0 && range.getVcsLine1() != 0;
            boolean canExpandAfter = range.getLine2() < document.getLineCount() && range.getVcsLine2() < uDocument.getLineCount();
            int offset1 = range.getLine1() - (canExpandBefore ? 1 : 0);
            int uOffset1 = range.getVcsLine1() - (canExpandBefore ? 1 : 0);
            int offset2 = range.getLine2() + (canExpandAfter ? 1 : 0);
            int uOffset2 = range.getVcsLine2() + (canExpandAfter ? 1 : 0);
            Range range3 = new Range(offset1, offset2, uOffset1, uOffset2, range.getType());
            if (range3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "expand"));
            }
            return range3;
        }
        throw new IllegalArgumentException("Unknown range type: " + range.getType());
    }
}

