/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.commands;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class RequestFocusInToolWindowCmd
extends FinalizableCommand {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.commands.RequestFocusInToolWindowCmd");
    private final ToolWindowImpl myToolWindow;
    private final FocusWatcher myFocusWatcher;
    private final boolean myForced;
    private final Expirable myTimestamp;

    public RequestFocusInToolWindowCmd(IdeFocusManager focusManager, ToolWindowImpl toolWindow, FocusWatcher focusWatcher, Runnable finishCallBack, boolean forced) {
        super(finishCallBack);
        this.myToolWindow = toolWindow;
        this.myFocusWatcher = focusWatcher;
        this.myForced = forced;
        this.myTimestamp = focusManager.getTimestamp(true);
    }

    @Override
    public final void run() {
        this.myToolWindow.getActivation().doWhenDone(new Runnable(){

            @Override
            public void run() {
                RequestFocusInToolWindowCmd.this.processRequestFocus();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequestFocus() {
        try {
            Component preferredFocusedComponent;
            if (this.myTimestamp.isExpired()) {
                return;
            }
            Component component = preferredFocusedComponent = this.myToolWindow.isUseLastFocusedOnActivation() ? this.myFocusWatcher.getFocusedComponent() : null;
            if (preferredFocusedComponent == null && this.myToolWindow.getContentManager().getSelectedContent() != null && (preferredFocusedComponent = this.myToolWindow.getContentManager().getSelectedContent().getPreferredFocusableComponent()) != null) {
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)preferredFocusedComponent);
            }
            if (preferredFocusedComponent == null && (preferredFocusedComponent = this.myFocusWatcher.getNearestFocusableComponent()) instanceof JComponent) {
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)preferredFocusedComponent);
            }
            if (preferredFocusedComponent != null && !preferredFocusedComponent.isShowing()) {
                preferredFocusedComponent = null;
            }
            if (preferredFocusedComponent == null) {
                JComponent component2 = this.myToolWindow.getComponent();
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(component2);
            }
            if (preferredFocusedComponent != null) {
                this.requestFocus(preferredFocusedComponent).doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        RequestFocusInToolWindowCmd.this.bringOwnerToFront();
                    }
                });
            } else {
                JComponent componentToFocus = this.myToolWindow.getComponent();
                this.requestFocus(componentToFocus).doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        RequestFocusInToolWindowCmd.this.bringOwnerToFront();
                    }
                });
            }
        }
        finally {
            this.finish();
        }
    }

    private void bringOwnerToFront() {
        Window activeWindow;
        Window owner = SwingUtilities.getWindowAncestor(this.myToolWindow.getComponent());
        Window activeFrame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeFrame != null && activeFrame != owner) {
            return;
        }
        if (owner != null && owner.getFocusOwner() == null && ((activeWindow = RequestFocusInToolWindowCmd.getActiveWindow(owner.getOwnedWindows())) == null || activeWindow instanceof FloatingDecorator)) {
            LOG.debug("owner.toFront()");
            owner.toFront();
        }
    }

    @NotNull
    private ActionCallback requestFocus(final @NotNull Component c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd", "requestFocus"));
        }
        final ActionCallback result = new ActionCallback();
        final Alarm checkerAlarm = new Alarm((Disposable)result);
        Runnable checker = new Runnable(){
            final long startTime = System.currentTimeMillis();

            @Override
            public void run() {
                if (System.currentTimeMillis() - this.startTime > 10000L) {
                    result.setRejected();
                    return;
                }
                if (c.isShowing()) {
                    Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                    if (owner != null && owner == c) {
                        RequestFocusInToolWindowCmd.this.myManager.getFocusManager().requestFocus(new FocusCommand(){

                            @NotNull
                            public ActionCallback run() {
                                ActionCallback.Done done = new ActionCallback.Done();
                                if (done == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd$4$2", "run"));
                                }
                                return done;
                            }
                        }, RequestFocusInToolWindowCmd.this.myForced).doWhenProcessed(new Runnable(){

                            @Override
                            public void run() {
                                RequestFocusInToolWindowCmd.this.updateToolWindow(c);
                            }
                        }).notify(result);
                    } else {
                        RequestFocusInToolWindowCmd.this.myManager.getFocusManager().requestFocus((FocusCommand)new FocusCommand.ByComponent(c, (Component)RequestFocusInToolWindowCmd.this.myToolWindow.getComponent(), (Throwable)new Exception()), RequestFocusInToolWindowCmd.this.myForced).doWhenProcessed(new Runnable(){

                            @Override
                            public void run() {
                                RequestFocusInToolWindowCmd.this.updateToolWindow(c);
                            }
                        }).notify(result);
                    }
                } else {
                    checkerAlarm.addRequest((Runnable)this, 100);
                }
            }
        };
        checkerAlarm.addRequest(checker, 0);
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd", "requestFocus"));
        }
        return actionCallback;
    }

    private void updateToolWindow(Component c) {
        if (c.isFocusOwner()) {
            this.myFocusWatcher.setFocusedComponentImpl(c);
            if (this.myToolWindow.isAvailable() && !this.myToolWindow.isActive()) {
                this.myToolWindow.activate(null, true, false);
            }
        }
        RequestFocusInToolWindowCmd.updateFocusedComponentForWatcher(c);
    }

    private static void updateFocusedComponentForWatcher(Component c) {
        WindowWatcher watcher = ((WindowManagerImpl)WindowManager.getInstance()).getWindowWatcher();
        FocusWatcher focusWatcher = watcher.getFocusWatcherFor(c);
        if (focusWatcher != null && c.isFocusOwner()) {
            focusWatcher.setFocusedComponentImpl(c);
        }
    }

    private static Window getActiveWindow(Window[] windows) {
        for (Window window : windows) {
            if (window.isShowing() && window.isActive()) {
                return window;
            }
            if ((window = RequestFocusInToolWindowCmd.getActiveWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }
}

