/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PatchedWeakReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFileImpl
extends ElementBase
implements PsiFileEx,
PsiFileWithStubSupport,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiFileImpl");
    private IElementType myElementType;
    protected IElementType myContentElementType;
    private long myModificationStamp;
    protected PsiFile myOriginalFile;
    private final FileViewProvider myViewProvider;
    private volatile Reference<StubTree> myStub;
    protected final PsiManagerEx myManager;
    private volatile Getter<FileElement> myTreeElementPointer;
    public static final Key<Boolean> BUILDING_STUB = new Key("Don't use stubs mark!");
    private static final Comparator<PsiFile> FILE_BY_LANGUAGE_ID = new Comparator<PsiFile>(){

        @Override
        public int compare(PsiFile o1, PsiFile o2) {
            return o1.getLanguage().getID().compareTo(o2.getLanguage().getID());
        }
    };
    private static final Key<SoftReference<StubTree>> STUB_TREE_IN_PARSED_TREE = Key.create((String)"STUB_TREE_IN_PARSED_TREE");
    private final Object myStubFromTreeLock;

    protected PsiFileImpl(@NotNull IElementType elementType, IElementType contentElementType, @NotNull FileViewProvider provider) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/impl/source/PsiFileImpl", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PsiFileImpl", "<init>"));
        }
        this(provider);
        this.init(elementType, contentElementType);
    }

    protected PsiFileImpl(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PsiFileImpl", "<init>"));
        }
        this.myOriginalFile = null;
        this.myStubFromTreeLock = new Object();
        this.myManager = (PsiManagerEx)provider.getManager();
        this.myViewProvider = provider;
    }

    public void setContentElementType(IElementType contentElementType) {
        LOG.assertTrue(contentElementType instanceof ILazyParseableElementType, (Object)contentElementType);
        this.myContentElementType = contentElementType;
    }

    public IElementType getContentElementType() {
        return this.myContentElementType;
    }

    protected void init(@NotNull IElementType elementType, IElementType contentElementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/impl/source/PsiFileImpl", "init"));
        }
        this.myElementType = elementType;
        this.setContentElementType(contentElementType);
    }

    public TreeElement createContentLeafElement(CharSequence leafText) {
        if (this.myContentElementType instanceof ILazyParseableElementType) {
            return ASTFactory.lazy((ILazyParseableElementType)this.myContentElementType, leafText);
        }
        return ASTFactory.leaf(this.myContentElementType, leafText);
    }

    public boolean isDirectory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileElement getTreeElement() {
        FileElement node = this.derefTreeElement();
        if (node != null) {
            return node;
        }
        if (!this.getViewProvider().isPhysical()) {
            return this.loadTreeElement();
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            return this.derefTreeElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileElement derefTreeElement() {
        Getter<FileElement> pointer = this.myTreeElementPointer;
        FileElement treeElement = (FileElement)SoftReference.deref(pointer);
        if (treeElement != null) {
            return treeElement;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myTreeElementPointer == pointer) {
                this.myTreeElementPointer = null;
            }
        }
        return null;
    }

    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    public boolean isValid() {
        FileViewProvider provider = this.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        if (!vFile.isValid()) {
            return false;
        }
        if (!provider.isEventSystemEnabled()) {
            return true;
        }
        if (this.myManager.getProject().isDisposed()) {
            return false;
        }
        return this.isPsiUpToDate(vFile);
    }

    protected boolean isPsiUpToDate(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/source/PsiFileImpl", "isPsiUpToDate"));
        }
        FileViewProvider provider = this.myManager.findViewProvider(vFile);
        Language language = this.getLanguage();
        if (provider == null || provider.getPsi(language) == this) {
            return true;
        }
        Language baseLanguage = provider.getBaseLanguage();
        return baseLanguage != language && provider.getPsi(baseLanguage) == this;
    }

    @Override
    public boolean isContentsLoaded() {
        return this.derefTreeElement() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private FileElement loadTreeElement() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileViewProvider viewProvider = this.getViewProvider();
        if (viewProvider.isPhysical() && this.myManager.isAssertOnFileLoading(viewProvider.getVirtualFile())) {
            LOG.error("Access to tree elements not allowed in tests. path='" + viewProvider.getVirtualFile().getPresentableUrl() + "'");
        }
        Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(this.getViewProvider().getVirtualFile());
        FileElement treeElement = this.createFileElement(viewProvider.getContents());
        treeElement.setPsi((PsiElement)this);
        List<Pair<StubBasedPsiElementBase, CompositeElement>> bindings = this.calcStubAstBindings(treeElement, cachedDocument);
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        FileElement existing = this.derefTreeElement();
        if (existing != null) {
            FileElement fileElement = existing;
            // MONITOREXIT : object
            if (fileElement != null) return fileElement;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "loadTreeElement"));
        }
        PsiFileImpl.switchFromStubToAst(bindings);
        this.myStub = null;
        this.myTreeElementPointer = this.createTreeElementPointer(treeElement);
        if (LOG.isDebugEnabled() && viewProvider.isPhysical()) {
            LOG.debug("Loaded text for file " + viewProvider.getVirtualFile().getPresentableUrl());
        }
        FileElement fileElement = treeElement;
        // MONITOREXIT : object
        if (fileElement != null) return fileElement;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "loadTreeElement"));
    }

    @Override
    public ASTNode findTreeForStub(StubTree tree, StubElement<?> stub) {
        Iterator<StubElement<?>> stubs = tree.getPlainList().iterator();
        StubElement root = (StubElement)stubs.next();
        FileElement ast = this.calcTreeElement();
        if (root == stub) {
            return ast;
        }
        return PsiFileImpl.findTreeForStub(ast, stubs, stub);
    }

    @Nullable
    private static ASTNode findTreeForStub(ASTNode tree, Iterator<StubElement<?>> stubs, StubElement stub) {
        StubElement<?> curStub;
        IElementType type = tree.getElementType();
        if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(tree) && (curStub = stubs.next()) == stub) {
            return tree;
        }
        for (ASTNode node : tree.getChildren(null)) {
            ASTNode treeForStub = PsiFileImpl.findTreeForStub(node, stubs, stub);
            if (treeForStub == null) continue;
            return treeForStub;
        }
        return null;
    }

    private static void switchFromStubToAst(List<Pair<StubBasedPsiElementBase, CompositeElement>> pairs) {
        for (Pair<StubBasedPsiElementBase, CompositeElement> pair : pairs) {
            ((CompositeElement)pair.second).setPsi((PsiElement)pair.first);
            ((StubBasedPsiElementBase)((Object)pair.first)).setNode((ASTNode)pair.second);
            ((StubBasedPsiElementBase)((Object)pair.first)).setStub(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<StubBasedPsiElementBase, CompositeElement>> calcStubAstBindings(ASTNode root, final Document cachedDocument) {
        final StubTree stubTree = this.derefStub();
        if (stubTree == null) {
            return Collections.emptyList();
        }
        final Iterator stubs = stubTree.getPlainList().iterator();
        stubs.next();
        final ArrayList result = ContainerUtil.newArrayList();
        final StubBuilder builder = ((IStubFileElementType)this.getContentElementType()).getBuilder();
        LazyParseableElement.setSuppressEagerPsiCreation(true);
        try {
            ((TreeElement)root).acceptTree(new RecursiveTreeElementWalkingVisitor(){

                @Override
                protected void visitNode(TreeElement node) {
                    CompositeElement parent = node.getTreeParent();
                    if (parent != null && builder.skipChildProcessingWhenBuildingStubs((ASTNode)parent, (ASTNode)node)) {
                        return;
                    }
                    IElementType type = node.getElementType();
                    if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub((ASTNode)node)) {
                        StubElement stub;
                        if (!stubs.hasNext()) {
                            PsiFileImpl.this.reportStubAstMismatch("Stub list is less than AST, last AST element: " + node.getElementType() + " " + node, stubTree, cachedDocument);
                        }
                        if ((stub = (StubElement)stubs.next()).getStubType() != node.getElementType()) {
                            PsiFileImpl.this.reportStubAstMismatch("Stub and PSI element type mismatch in " + PsiFileImpl.this.getName() + ": stub " + stub + ", AST " + node.getElementType() + "; " + node, stubTree, cachedDocument);
                        }
                        PsiElement psi = stub.getPsi();
                        assert (psi != null) : "Stub " + stub + " (" + stub.getClass() + ") has returned null PSI";
                        result.add(Pair.create((Object)((Object)((StubBasedPsiElementBase)psi)), (Object)((CompositeElement)node)));
                    }
                    super.visitNode(node);
                }
            });
        }
        finally {
            LazyParseableElement.setSuppressEagerPsiCreation(false);
        }
        if (stubs.hasNext()) {
            this.reportStubAstMismatch("Stub list in " + this.getName() + " has more elements than PSI", stubTree, cachedDocument);
        }
        return result;
    }

    protected void reportStubAstMismatch(String message, StubTree stubTree, Document cachedDocument) {
        this.rebuildStub();
        this.clearStub("stub-psi mismatch");
        this.scheduleDropCachesWithInvalidStubPsi();
        String msg = message;
        msg = msg + "\n file=" + this;
        msg = msg + ", modStamp=" + this.getModificationStamp();
        msg = msg + "\n stub debugInfo=" + stubTree.getDebugInfo();
        msg = msg + "\n document before=" + cachedDocument;
        ObjectStubTree latestIndexedStub = StubTreeLoader.getInstance().readFromVFile(this.getProject(), this.getVirtualFile());
        msg = msg + "\nlatestIndexedStub=" + latestIndexedStub;
        if (latestIndexedStub != null) {
            msg = msg + "\n   same size=" + (stubTree.getPlainList().size() == latestIndexedStub.getPlainList().size());
            msg = msg + "\n   debugInfo=" + latestIndexedStub.getDebugInfo();
        }
        FileViewProvider viewProvider = this.getViewProvider();
        msg = msg + "\n viewProvider=" + viewProvider;
        msg = msg + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
        VirtualFile file = viewProvider.getVirtualFile();
        msg = msg + "; file stamp: " + file.getModificationStamp();
        msg = msg + "; file modCount: " + file.getModificationCount();
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null) {
            msg = msg + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            msg = msg + "; doc stamp: " + document.getModificationStamp();
            msg = msg + "; doc size: " + document.getTextLength();
            msg = msg + "; committed: " + PsiDocumentManager.getInstance((Project)this.getProject()).isCommitted(document);
        }
        throw new AssertionError((Object)(msg + "\n------------\n"));
    }

    private void scheduleDropCachesWithInvalidStubPsi() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ((PsiModificationTrackerImpl)PsiFileImpl.this.getManager().getModificationTracker()).incCounter();
                    }
                });
            }
        });
    }

    @NotNull
    protected FileElement createFileElement(CharSequence docText) {
        FileElement treeElement;
        TreeElement contentLeaf = this.createContentLeafElement(docText);
        if (contentLeaf instanceof FileElement) {
            treeElement = (FileElement)contentLeaf;
        } else {
            CompositeElement xxx = ASTFactory.composite(this.myElementType);
            assert (xxx instanceof FileElement) : "BUMM";
            treeElement = (FileElement)xxx;
            treeElement.rawAddChildrenWithoutNotifications(contentLeaf);
        }
        FileElement fileElement = treeElement;
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "createFileElement"));
        }
        return fileElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadContent() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.clearCaches();
        this.myViewProvider.beforeContentsSynchronized();
        Object object = PsiLock.LOCK;
        synchronized (object) {
            FileElement treeElement = this.derefTreeElement();
            DebugUtil.startPsiModification("unloadContent");
            try {
                if (treeElement != null) {
                    this.myTreeElementPointer = null;
                    treeElement.detachFromFile();
                    DebugUtil.onInvalidated(treeElement);
                }
                this.clearStub("unloadContent");
            }
            finally {
                DebugUtil.finishPsiModification();
            }
        }
    }

    private void clearStub(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/source/PsiFileImpl", "clearStub"));
        }
        StubTree stubHolder = (StubTree)SoftReference.dereference(this.myStub);
        if (stubHolder != null) {
            ((PsiFileStubImpl)stubHolder.getRoot()).clearPsi(reason);
        }
        this.myStub = null;
    }

    public void clearCaches() {
        ++this.myModificationStamp;
    }

    public String getText() {
        return ((Object)this.getViewProvider().getContents()).toString();
    }

    public int getTextLength() {
        FileElement tree = this.derefTreeElement();
        if (tree != null) {
            return tree.getTextLength();
        }
        return this.getViewProvider().getContents().length();
    }

    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling((PsiElement)this);
    }

    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling((PsiElement)this);
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public void subtreeChanged() {
        this.doClearCaches("subtreeChanged");
        this.getViewProvider().rootChanged((PsiFile)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClearCaches(String reason) {
        FileElement tree = this.getTreeElement();
        if (tree != null) {
            tree.clearCaches();
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.clearStub(reason);
        }
        if (tree != null) {
            tree.putUserData(STUB_TREE_IN_PARSED_TREE, null);
        }
        this.clearCaches();
    }

    protected PsiFileImpl clone() {
        FileViewProvider viewProvider = this.getViewProvider();
        FileViewProvider providerCopy = viewProvider.clone();
        Language language = this.getLanguage();
        if (providerCopy == null) {
            throw new AssertionError((Object)("Unable to clone the view provider: " + viewProvider + "; " + language));
        }
        PsiFileImpl clone = BlockSupportImpl.getFileCopy(this, providerCopy);
        this.copyCopyableDataTo((UserDataHolderBase)clone);
        if (this.getTreeElement() != null) {
            FileElement treeClone = (FileElement)this.calcTreeElement().clone();
            clone.setTreeElementPointer(treeClone);
            treeClone.setPsi((PsiElement)clone);
        }
        if (viewProvider.isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        return clone;
    }

    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiFileImpl", "setName"));
        }
        this.checkSetName(name);
        this.doClearCaches("setName");
        return PsiFileImplUtil.setName(this, name);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Nullable
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getViewProvider().getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @NotNull
    public PsiFile getContainingFile() {
        PsiFileImpl psiFileImpl = this;
        if (psiFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getContainingFile"));
        }
        return psiFileImpl;
    }

    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFileImpl psiFileImpl = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (psiFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getOriginalFile"));
        }
        return psiFileImpl;
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/psi/impl/source/PsiFileImpl", "setOriginalFile"));
        }
        this.myOriginalFile = originalFile.getOriginalFile();
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        FileViewProvider viewProvider = this.getViewProvider();
        Set languages = viewProvider.getLanguages();
        PsiFile[] roots = new PsiFile[languages.size()];
        int i = 0;
        for (Language language : languages) {
            PsiFile psi = viewProvider.getPsi(language);
            if (psi == null) {
                LOG.error("PSI is null for " + language + "; in file: " + this);
            }
            roots[i++] = psi;
        }
        if (roots.length > 1) {
            Arrays.sort(roots, FILE_BY_LANGUAGE_ID);
        }
        if (roots == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getPsiRoots"));
        }
        return roots;
    }

    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getLanguage"));
        }
        return language;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    public void setTreeElementPointer(FileElement element) {
        this.myTreeElementPointer = element;
    }

    public PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset);
    }

    public PsiReference findReferenceAt(int offset) {
        return this.getViewProvider().findReferenceAt(offset);
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequence((CharSequence)this.getViewProvider().getContents());
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "textToCharArray"));
        }
        return cArray;
    }

    @NotNull
    public <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            result.add(child);
        }
        Object[] objectArray = result.toArray((Object[])Array.newInstance(aClass, result.size()));
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "findChildrenByClass"));
        }
        return objectArray;
    }

    @Nullable
    public <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public boolean isTemplateDataFile() {
        return false;
    }

    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void onContentReload() {
        this.subtreeChanged();
        if (this.isContentsLoaded()) {
            this.unloadContent();
        }
    }

    @Nullable
    public StubElement getStub() {
        StubTree stubHolder = this.getStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (Boolean.TRUE.equals(this.getUserData(BUILDING_STUB))) {
            return null;
        }
        StubTree derefd = this.derefStub();
        if (derefd != null) {
            return derefd;
        }
        if (this.getTreeElement() != null) {
            return null;
        }
        if (!(this.getContentElementType() instanceof IStubFileElementType)) {
            return null;
        }
        VirtualFile vFile = this.getVirtualFile();
        if (!(vFile instanceof VirtualFileWithId)) {
            return null;
        }
        PsiFile stubBindingRoot = this.getViewProvider().getStubBindingRoot();
        if (stubBindingRoot != this) {
            LOG.error("Attempted to create stubs for non-root file: " + this + ", stub binding root: " + stubBindingRoot);
            return null;
        }
        ObjectStubTree tree = StubTreeLoader.getInstance().readOrBuild(this.getProject(), vFile, this);
        if (!(tree instanceof StubTree)) {
            return null;
        }
        StubTree stubHolder = (StubTree)tree;
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.getTreeElement() != null) {
                return null;
            }
            StubTree derefdOnLock = this.derefStub();
            if (derefdOnLock != null) {
                return derefdOnLock;
            }
            ((StubBase)stubHolder.getRoot()).setPsi((PsiElement)this);
            this.myStub = new SoftReference((Object)stubHolder);
            return stubHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private StubTree derefStub() {
        if (this.myStub == null) {
            return null;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            return (StubTree)SoftReference.dereference(this.myStub);
        }
    }

    protected PsiFileImpl cloneImpl(FileElement treeElementClone) {
        PsiFileImpl clone = (PsiFileImpl)super.clone();
        clone.setTreeElementPointer(treeElementClone);
        treeElementClone.setPsi((PsiElement)clone);
        return clone;
    }

    private boolean isKeepTreeElementByHardReference() {
        return !this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    private Getter<FileElement> createTreeElementPointer(@NotNull FileElement treeElement) {
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/psi/impl/source/PsiFileImpl", "createTreeElementPointer"));
        }
        if (this.isKeepTreeElementByHardReference()) {
            FileElement fileElement = treeElement;
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "createTreeElementPointer"));
            }
            return fileElement;
        }
        Getter getter = this.myManager.isBatchFilesProcessingMode() ? new PatchedWeakReference<FileElement>(treeElement) : new SoftReference((Object)treeElement);
        if (getter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "createTreeElementPointer"));
        }
        return getter;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public PsiElement getNavigationElement() {
        return this;
    }

    public PsiElement getOriginalElement() {
        return this;
    }

    @NotNull
    public final FileElement calcTreeElement() {
        FileElement treeElement = this.getTreeElement();
        if (treeElement != null) {
            FileElement fileElement = treeElement;
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcTreeElement"));
            }
            return fileElement;
        }
        FileElement fileElement = this.loadTreeElement();
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcTreeElement"));
        }
        return fileElement;
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.calcTreeElement().getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getChildren"));
        }
        return psiElementArray;
    }

    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.calcTreeElement());
    }

    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.calcTreeElement());
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiFileImpl", "acceptChildren"));
        }
        SharedImplUtil.acceptChildren(visitor, this.calcTreeElement());
    }

    public int getStartOffsetInParent() {
        return this.calcTreeElement().getStartOffsetInParent();
    }

    public int getTextOffset() {
        return this.calcTreeElement().getTextOffset();
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/PsiFileImpl", "textMatches"));
        }
        return this.calcTreeElement().textMatches(text);
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "textMatches"));
        }
        return this.calcTreeElement().textMatches(element);
    }

    public boolean textContains(char c) {
        return this.calcTreeElement().textContains(c);
    }

    public final PsiElement copy() {
        return this.clone();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "add"));
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "addBefore"));
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "addAfter"));
        }
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "checkAdd"));
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, null, null);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/PsiFileImpl", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/psi/impl/source/PsiFileImpl", "addRangeBefore"));
        }
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange((PsiElement)this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        if (first == null) {
            LOG.assertTrue(last == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        FileElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren(treeElement, firstElement, lastElement);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/PsiFileImpl", "replace"));
        }
        FileElement treeElement = this.calcTreeElement();
        return SharedImplUtil.doReplace((PsiElement)this, treeElement, newElement);
    }

    public PsiReference getReference() {
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences((PsiElement)this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/PsiFileImpl", "processDeclarations"));
        }
        return true;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getUseScope"));
        }
        return globalSearchScope;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return PsiFileImpl.this.getName();
            }

            public String getLocationString() {
                PsiDirectory psiDirectory = PsiFileImpl.this.getParent();
                if (psiDirectory != null) {
                    return psiDirectory.getVirtualFile().getPresentableUrl();
                }
                return null;
            }

            public Icon getIcon(boolean open) {
                return PsiFileImpl.this.getIcon(0);
            }
        };
    }

    public void navigate(boolean requestFocus) {
        assert (this.canNavigate()) : this;
        PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate((PsiElement)this);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public FileASTNode getNode() {
        FileElement fileElement = this.calcTreeElement();
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getNode"));
        }
        return fileElement;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubTree calcStubTree() {
        FileElement fileElement = this.calcTreeElement();
        Object object = this.myStubFromTreeLock;
        synchronized (object) {
            SoftReference ref = (SoftReference)fileElement.getUserData(STUB_TREE_IN_PARSED_TREE);
            StubTree tree = (StubTree)SoftReference.dereference((Reference)ref);
            if (tree == null) {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                IElementType contentElementType = this.getContentElementType();
                if (!(contentElementType instanceof IStubFileElementType)) {
                    VirtualFile vFile = this.getVirtualFile();
                    String message = "ContentElementType: " + contentElementType + "; file: " + this + "\n\t" + "Boolean.TRUE.equals(getUserData(BUILDING_STUB)) = " + Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)) + "\n\t" + "getTreeElement() = " + this.getTreeElement() + "\n\t" + "vFile instanceof VirtualFileWithId = " + (vFile instanceof VirtualFileWithId) + "\n\t" + "StubUpdatingIndex.canHaveStub(vFile) = " + StubTreeLoader.getInstance().canHaveStub(vFile);
                    this.rebuildStub();
                    throw new AssertionError((Object)message);
                }
                StubElement currentStubTree = ((IStubFileElementType)contentElementType).getBuilder().buildStubTree((PsiFile)this);
                if (currentStubTree == null) {
                    throw new AssertionError((Object)("Stub tree wasn't built for " + contentElementType + "; file: " + this));
                }
                tree = new StubTree((PsiFileStub)currentStubTree);
                tree.setDebugInfo("created in calcStubTree");
                try {
                    TreeUtil.bindStubsToTree(this, tree);
                }
                catch (TreeUtil.StubBindingException e) {
                    this.rebuildStub();
                    throw new RuntimeException("Stub and PSI element type mismatch in " + this.getName(), e);
                }
                fileElement.putUserData(STUB_TREE_IN_PARSED_TREE, new SoftReference((Object)tree));
            }
            return tree;
        }
    }

    private void rebuildStub() {
        final VirtualFile vFile = this.getVirtualFile();
        if (vFile != null && vFile.isValid()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                    if (doc != null) {
                        FileDocumentManager.getInstance().saveDocument(doc);
                    }
                }
            }, ModalityState.NON_MODAL);
            StubTreeLoader.getInstance().rebuildStubTree(vFile);
        }
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/source/PsiFileImpl", "putInfo"));
        }
        PsiFileImpl.putInfo(this, info);
    }

    public static void putInfo(PsiFile psiFile, Map<String, String> info) {
        info.put("fileName", psiFile.getName());
        info.put("fileType", psiFile.getFileType().toString());
    }

    public String toString() {
        return this.myElementType.toString();
    }
}

