/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui.tree.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServerNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.actions.ServersTreeActionBase;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployAction
extends ServersTreeActionBase {
    public DeployAction() {
        super("Deploy", "Deploy the selected item", AllIcons.Nodes.Deploy);
    }

    @Override
    protected void updatePresentation(@NotNull Presentation presentation, @Nullable ServersToolWindowContent content) {
        DeploymentNode node;
        Set<DeploymentNode> nodes;
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/DeployAction", "updatePresentation"));
        }
        if (content != null && (nodes = content.getSelectedDeploymentNodes()).size() == 1 && (node = nodes.iterator().next()).isDeployed()) {
            presentation.setText("Redeploy");
            presentation.setDescription("Redeploy '" + node.getDeploymentName() + "'");
            return;
        }
        presentation.setText(this.getTemplatePresentation().getText());
        presentation.setDescription(this.getTemplatePresentation().getDescription());
    }

    @Override
    protected boolean isEnabled(@NotNull ServersToolWindowContent content, AnActionEvent e) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/DeployAction", "isEnabled"));
        }
        Set<DeploymentNode> deploymentNodes = content.getSelectedDeploymentNodes();
        Set<ServerNode> serverNodes = content.getSelectedServerNodes();
        if (deploymentNodes.size() + serverNodes.size() != 1) {
            return false;
        }
        for (DeploymentNode node : deploymentNodes) {
            if (node.isRedeployActionEnabled()) continue;
            return false;
        }
        for (ServerNode serverNode : serverNodes) {
            if (serverNode.isDeployActionEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doActionPerformed(@NotNull ServersToolWindowContent content, AnActionEvent e) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/DeployAction", "doActionPerformed"));
        }
        for (DeploymentNode deploymentNode : content.getSelectedDeploymentNodes()) {
            deploymentNode.redeploy();
        }
        for (ServerNode serverNode : content.getSelectedServerNodes()) {
            serverNode.deploy(e);
        }
    }
}

