/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.ui.SpellCheckingEditorCustomization;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.util.Function;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

class MultilinePopupBuilder {
    private static final char[] SEPARATORS = new char[]{',', '|', '\n'};
    @NotNull
    private final EditorTextField myTextField;

    MultilinePopupBuilder(@NotNull Project project, @NotNull Collection<String> values, @NotNull String initialValue) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "<init>"));
        }
        if (initialValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialValue", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "<init>"));
        }
        this.myTextField = MultilinePopupBuilder.createTextField(project);
        new MyCompletionProvider(values).apply(this.myTextField);
        this.myTextField.setText(initialValue);
    }

    @NotNull
    private static EditorTextField createTextField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createTextField"));
        }
        EditorTextFieldProvider service = (EditorTextFieldProvider)ServiceManager.getService((Project)project, EditorTextFieldProvider.class);
        List<EditorCustomization> features = Arrays.asList(SoftWrapsEditorCustomization.ENABLED, SpellCheckingEditorCustomization.DISABLED);
        EditorTextField textField = service.getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, features);
        textField.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), textField.getBorder()));
        textField.setOneLineMode(false);
        EditorTextField editorTextField = textField;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createTextField"));
        }
        return editorTextField;
    }

    @NotNull
    JBPopup createPopup() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.myTextField), "Center");
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)((Object)this.myTextField)).setCancelOnClickOutside(true).setAdText(KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.CTRL_ENTER.getShortcuts()) + " to finish").setMovable(true).setRequestFocus(true).setResizable(true).setMayBeParent(true);
        final JBPopup popup = builder.createPopup();
        popup.setMinimumSize(new Dimension(200, 90));
        DumbAwareAction okAction = new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                this.unregisterCustomShortcutSet(popup.getContent());
                popup.closeOk(e.getInputEvent());
            }
        };
        okAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, popup.getContent());
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createPopup"));
        }
        return jBPopup;
    }

    @NotNull
    Collection<String> getSelectedValues() {
        List list = ContainerUtil.mapNotNull((Iterable)StringUtil.tokenize((String)this.myTextField.getText(), (String)new String(SEPARATORS)), (Function)new Function<String, String>(){

            public String fun(String value) {
                String trimmed = value.trim();
                return trimmed.isEmpty() ? null : trimmed;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "getSelectedValues"));
        }
        return list;
    }

    private static class MyCompletionProvider
    extends TextFieldCompletionProviderDumbAware {
        @NotNull
        private final Collection<String> myValues;

        MyCompletionProvider(@NotNull Collection<String> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "<init>"));
            }
            super(true);
            this.myValues = values;
        }

        @Override
        @NotNull
        protected String getPrefix(@NotNull String currentTextPrefix) {
            if (currentTextPrefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTextPrefix", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "getPrefix"));
            }
            int separatorPosition = MyCompletionProvider.lastSeparatorPosition(currentTextPrefix);
            String string = separatorPosition == -1 ? currentTextPrefix : currentTextPrefix.substring(separatorPosition + 1).trim();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "getPrefix"));
            }
            return string;
        }

        private static int lastSeparatorPosition(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "lastSeparatorPosition"));
            }
            int lastPosition = -1;
            for (char separator : SEPARATORS) {
                int lio = text.lastIndexOf(separator);
                if (lio <= lastPosition) continue;
                lastPosition = lio;
            }
            return lastPosition;
        }

        @Override
        protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "addCompletionVariants"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "addCompletionVariants"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "addCompletionVariants"));
            }
            result.addLookupAdvertisement("Select one or more users separated with comma, | or new lines");
            for (String completionVariant : this.myValues) {
                LookupElementBuilder element = LookupElementBuilder.create((String)completionVariant);
                result.addElement((LookupElement)element.withLookupString(completionVariant.toLowerCase()));
            }
        }
    }
}

