/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.impl.settings.XDebuggerDataViewSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DataViewsConfigurableUi {
    private JCheckBox enableAutoExpressionsCheckBox;
    private JFormattedTextField valueTooltipDelayTextField;
    private JPanel panel;
    private JCheckBox sortAlphabeticallyCheckBox;

    public DataViewsConfigurableUi() {
        this.$$$setupUI$$$();
        UIUtil.configureNumericFormattedTextField((JFormattedTextField)this.valueTooltipDelayTextField);
    }

    private int getValueTooltipDelay() {
        Object value = this.valueTooltipDelayTextField.getValue();
        return value instanceof Number ? ((Number)value).intValue() : StringUtilRt.parseInt((String)((String)value), (int)700);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/settings/DataViewsConfigurableUi", "getComponent"));
        }
        return jPanel;
    }

    public boolean isModified(@NotNull XDebuggerDataViewSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xdebugger/impl/settings/DataViewsConfigurableUi", "isModified"));
        }
        return this.getValueTooltipDelay() != settings.getValueLookupDelay() || this.sortAlphabeticallyCheckBox.isSelected() != settings.isSortValues() || this.enableAutoExpressionsCheckBox.isSelected() != settings.isAutoExpressions();
    }

    public void reset(@NotNull XDebuggerDataViewSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xdebugger/impl/settings/DataViewsConfigurableUi", "reset"));
        }
        this.valueTooltipDelayTextField.setValue(settings.getValueLookupDelay());
        this.sortAlphabeticallyCheckBox.setSelected(settings.isSortValues());
        this.enableAutoExpressionsCheckBox.setSelected(settings.isAutoExpressions());
    }

    public void apply(@NotNull XDebuggerDataViewSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xdebugger/impl/settings/DataViewsConfigurableUi", "apply"));
        }
        settings.setValueLookupDelay(this.getValueTooltipDelay());
        settings.setSortValues(this.sortAlphabeticallyCheckBox.isSelected());
        settings.setAutoExpressions(this.enableAutoExpressionsCheckBox.isSelected());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JFormattedTextField jFormattedTextField;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("setting.value.tooltip.delay.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.valueTooltipDelayTextField = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setColumns(4);
        jPanel.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.enableAutoExpressionsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("setting.enable.auto.expressions.label"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.sortAlphabeticallyCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("setting.sort.alphabetically.label"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

