/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import org.jetbrains.annotations.NotNull;

public final class TextViewer
extends EditorTextField {
    private final boolean myEmbeddedIntoDialogWrapper;
    private final boolean myUseSoftWraps;

    public TextViewer(@NotNull Project project, boolean embeddedIntoDialogWrapper, boolean useSoftWraps) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/TextViewer", "<init>"));
        }
        this(TextViewer.createDocument(""), project, embeddedIntoDialogWrapper, useSoftWraps);
    }

    public TextViewer(@NotNull String initialText, @NotNull Project project) {
        if (initialText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialText", "com/intellij/xdebugger/impl/ui/TextViewer", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/TextViewer", "<init>"));
        }
        this(TextViewer.createDocument(initialText), project, false, true);
    }

    public TextViewer(@NotNull Document document, @NotNull Project project, boolean embeddedIntoDialogWrapper, boolean useSoftWraps) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/ui/TextViewer", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/TextViewer", "<init>"));
        }
        super(document, project, (FileType)FileTypes.PLAIN_TEXT, true, false);
        this.myEmbeddedIntoDialogWrapper = embeddedIntoDialogWrapper;
        this.myUseSoftWraps = useSoftWraps;
        this.setFontInheritedFromLAF(false);
    }

    private static Document createDocument(@NotNull String initialText) {
        if (initialText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialText", "com/intellij/xdebugger/impl/ui/TextViewer", "createDocument"));
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)initialText);
        if (document instanceof DocumentImpl) {
            ((DocumentImpl)document).setAcceptSlashR(true);
        }
        return document;
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        editor.setHorizontalScrollbarVisible(true);
        editor.setCaretEnabled(true);
        editor.setVerticalScrollbarVisible(true);
        editor.setEmbeddedIntoDialogWrapper(this.myEmbeddedIntoDialogWrapper);
        editor.getComponent().setPreferredSize(null);
        editor.getSettings().setUseSoftWraps(this.myUseSoftWraps);
        editor.setColorsScheme(DebuggerUIUtil.getColorScheme());
        return editor;
    }
}

