/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeInplaceEditor
implements AWTEventListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.DebuggerTreeInplaceEditor");
    private JComponent myInplaceEditorComponent;
    private final List<Runnable> myRemoveActions = new ArrayList<Runnable>();

    protected abstract JComponent createInplaceEditorComponent();

    protected abstract JComponent getPreferredFocusedComponent();

    public abstract Editor getEditor();

    public abstract JComponent getEditorComponent();

    protected abstract TreePath getNodePath();

    protected abstract JTree getTree();

    public void doOKAction() {
        this.hide();
    }

    public void cancelEditing() {
        this.hide();
    }

    private void hide() {
        if (!this.isShown()) {
            return;
        }
        this.myInplaceEditorComponent = null;
        this.onHidden();
        for (Runnable action : this.myRemoveActions) {
            action.run();
        }
        this.myRemoveActions.clear();
        JTree tree = this.getTree();
        tree.repaint();
        tree.requestFocus();
    }

    protected void onHidden() {
    }

    protected abstract Project getProject();

    public final void show() {
        JComponent inplaceEditorComponent;
        LOG.assertTrue(this.myInplaceEditorComponent == null, (Object)"editor is not released");
        final JTree tree = this.getTree();
        tree.scrollPathToVisible(this.getNodePath());
        final JRootPane rootPane = tree.getRootPane();
        if (rootPane == null) {
            return;
        }
        final JLayeredPane layeredPane = rootPane.getLayeredPane();
        Rectangle bounds = this.getEditorBounds();
        if (bounds == null) {
            return;
        }
        Point layeredPanePoint = SwingUtilities.convertPoint(tree, bounds.x, bounds.y, layeredPane);
        this.myInplaceEditorComponent = inplaceEditorComponent = this.createInplaceEditorComponent();
        LOG.assertTrue(inplaceEditorComponent != null);
        inplaceEditorComponent.setBounds(layeredPanePoint.x, layeredPanePoint.y, bounds.width, Math.max(bounds.height, inplaceEditorComponent.getPreferredSize().height));
        layeredPane.add((Component)inplaceEditorComponent, new Integer(250));
        this.myRemoveActions.add(new Runnable(){

            @Override
            public void run() {
                layeredPane.remove(inplaceEditorComponent);
            }
        });
        inplaceEditorComponent.validate();
        inplaceEditorComponent.paintImmediately(0, 0, inplaceEditorComponent.getWidth(), inplaceEditorComponent.getHeight());
        this.getPreferredFocusedComponent().requestFocus();
        final ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                final Project project = TreeInplaceEditor.this.getProject();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!TreeInplaceEditor.this.isShown() || project == null || project.isDisposed()) {
                            return;
                        }
                        JTree tree = TreeInplaceEditor.this.getTree();
                        JLayeredPane layeredPane = tree.getRootPane().getLayeredPane();
                        Rectangle bounds = TreeInplaceEditor.this.getEditorBounds();
                        if (bounds == null) {
                            return;
                        }
                        Point layeredPanePoint = SwingUtilities.convertPoint(tree, bounds.x, bounds.y, layeredPane);
                        inplaceEditorComponent.setBounds(layeredPanePoint.x, layeredPanePoint.y, bounds.width, bounds.height);
                        inplaceEditorComponent.revalidate();
                    }
                });
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                TreeInplaceEditor.this.cancelEditing();
            }
        };
        final HierarchyListener hierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (!tree.isShowing()) {
                    TreeInplaceEditor.this.cancelEditing();
                }
            }
        };
        tree.addHierarchyListener(hierarchyListener);
        tree.addComponentListener(componentListener);
        rootPane.addComponentListener(componentListener);
        this.myRemoveActions.add(new Runnable(){

            @Override
            public void run() {
                tree.removeHierarchyListener(hierarchyListener);
                tree.removeComponentListener(componentListener);
                rootPane.removeComponentListener(componentListener);
            }
        });
        final Disposable disposable = Disposer.newDisposable();
        this.getProject().getMessageBus().connect(disposable).subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/xdebugger/impl/ui/tree/TreeInplaceEditor$5", "contentSelected"));
                }
                TreeInplaceEditor.this.cancelEditing();
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/xdebugger/impl/ui/tree/TreeInplaceEditor$5", "contentRemoved"));
                }
                TreeInplaceEditor.this.cancelEditing();
            }
        });
        this.myRemoveActions.add(new Runnable(){

            @Override
            public void run() {
                Disposer.dispose((Disposable)disposable);
            }
        });
        JComponent editorComponent = this.getEditorComponent();
        editorComponent.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enterStroke");
        editorComponent.getActionMap().put("enterStroke", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeInplaceEditor.this.doOKAction();
            }
        });
        editorComponent.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escapeStroke");
        editorComponent.getActionMap().put("escapeStroke", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeInplaceEditor.this.cancelEditing();
            }
        });
        final Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!TreeInplaceEditor.this.isShown()) {
                    return;
                }
                defaultToolkit.addAWTEventListener(TreeInplaceEditor.this, 131088L);
            }
        });
        this.myRemoveActions.add(new Runnable(){

            @Override
            public void run() {
                defaultToolkit.removeAWTEventListener(TreeInplaceEditor.this);
            }
        });
        this.onShown();
    }

    protected void onShown() {
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        Component componentAtPoint;
        if (!this.isShown()) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        if (mouseEvent.getClickCount() == 0 && !(event instanceof MouseWheelEvent)) {
            return;
        }
        int id = mouseEvent.getID();
        if (id != 501 && id != 502 && id != 500 && id != 507) {
            return;
        }
        Component sourceComponent = mouseEvent.getComponent();
        Point originalPoint = mouseEvent.getPoint();
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        LookupImpl activeLookup = (LookupImpl)LookupManager.getInstance(editor.getProject()).getActiveLookup();
        if (activeLookup != null) {
            Point lookupPoint = SwingUtilities.convertPoint(sourceComponent, originalPoint, activeLookup.getComponent());
            if (activeLookup.getComponent().getBounds().contains(lookupPoint)) {
                return;
            }
            activeLookup.hide();
        }
        List popups = JBPopupFactory.getInstance().getChildPopups((Component)this.myInplaceEditorComponent);
        for (JBPopup popup : popups) {
            if (!SwingUtilities.isDescendingFrom(sourceComponent, popup.getContent())) continue;
            return;
        }
        Point point = SwingUtilities.convertPoint(sourceComponent, originalPoint, this.myInplaceEditorComponent);
        if (this.myInplaceEditorComponent.contains(point)) {
            return;
        }
        for (Component comp = componentAtPoint = SwingUtilities.getDeepestComponentAt(sourceComponent, originalPoint.x, originalPoint.y); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof ComboPopup)) continue;
            if (id != 507) {
                this.doOKAction();
            }
            return;
        }
        this.cancelEditing();
    }

    @Nullable
    private Rectangle getEditorBounds() {
        JTree tree = this.getTree();
        Rectangle bounds = tree.getVisibleRect();
        Rectangle nodeBounds = tree.getPathBounds(this.getNodePath());
        if (bounds == null || nodeBounds == null) {
            return null;
        }
        bounds.y = nodeBounds.y;
        bounds.height = nodeBounds.height;
        if (nodeBounds.x > bounds.x) {
            bounds.width = bounds.width - nodeBounds.x + bounds.x;
            bounds.x = nodeBounds.x;
        }
        return bounds;
    }

    public boolean isShown() {
        return this.myInplaceEditorComponent != null;
    }
}

