/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawUseOfParameterizedTypeInspection
extends BaseInspection {
    public boolean ignoreObjectConstruction = true;
    public boolean ignoreTypeCasts = false;
    public boolean ignoreUncompilable = false;
    public boolean ignoreParametersOfOverridingMethods = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("raw.use.of.parameterized.type.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/RawUseOfParameterizedTypeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("raw.use.of.parameterized.type.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/RawUseOfParameterizedTypeInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("raw.use.of.parameterized.type.ignore.new.objects.option", new Object[0]), "ignoreObjectConstruction");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("raw.use.of.parameterized.type.ignore.type.casts.option", new Object[0]), "ignoreTypeCasts");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("raw.use.of.parameterized.type.ignore.uncompilable.option", new Object[0]), "ignoreUncompilable");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("raw.use.of.parameterized.type.ignore.overridden.parameter.option", new Object[0]), "ignoreParametersOfOverridingMethods");
        return optionsPanel;
    }

    public String getAlternativeID() {
        return "rawtypes";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RawUseOfParameterizedTypeVisitor();
    }

    private class RawUseOfParameterizedTypeVisitor
    extends BaseInspectionVisitor {
        private RawUseOfParameterizedTypeVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/RawUseOfParameterizedTypeInspection$RawUseOfParameterizedTypeVisitor", "visitNewExpression"));
            }
            if (!this.hasNeededLanguageLevel((PsiElement)expression)) {
                return;
            }
            super.visitNewExpression(expression);
            if (RawUseOfParameterizedTypeInspection.this.ignoreObjectConstruction) {
                return;
            }
            if (RawUseOfParameterizedTypeInspection.this.ignoreUncompilable && (expression.getArrayInitializer() != null || expression.getArrayDimensions().length > 0)) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
            this.checkReferenceElement(classReference);
        }

        public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
            PsiMethod method;
            PsiParameter parameter;
            PsiElement declarationScope;
            PsiAnnotationMemberValue defaultValue;
            if (typeElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/siyeh/ig/migration/RawUseOfParameterizedTypeInspection$RawUseOfParameterizedTypeVisitor", "visitTypeElement"));
            }
            if (!this.hasNeededLanguageLevel((PsiElement)typeElement)) {
                return;
            }
            PsiType type = typeElement.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            super.visitTypeElement(typeElement);
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)typeElement, (Class[])new Class[]{PsiTypeElement.class});
            if (parent instanceof PsiInstanceOfExpression || parent instanceof PsiClassObjectAccessExpression) {
                return;
            }
            if (RawUseOfParameterizedTypeInspection.this.ignoreTypeCasts && parent instanceof PsiTypeCastExpression) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiComment.class) != null) {
                return;
            }
            PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiAnnotationMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (RawUseOfParameterizedTypeInspection.this.ignoreUncompilable && annotationMethod != null && (defaultValue = annotationMethod.getDefaultValue()) != null && parent != annotationMethod) {
                return;
            }
            if (parent instanceof PsiParameter && RawUseOfParameterizedTypeInspection.this.ignoreParametersOfOverridingMethods && (declarationScope = (parameter = (PsiParameter)parent).getDeclarationScope()) instanceof PsiMethod && MethodUtils.hasSuper(method = (PsiMethod)declarationScope)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            this.checkReferenceElement(referenceElement);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (!this.hasNeededLanguageLevel((PsiElement)reference)) {
                return;
            }
            super.visitReferenceElement(reference);
            PsiElement referenceParent = reference.getParent();
            if (!(referenceParent instanceof PsiReferenceList)) {
                return;
            }
            PsiReferenceList referenceList = (PsiReferenceList)referenceParent;
            PsiElement listParent = referenceList.getParent();
            if (!(listParent instanceof PsiClass)) {
                return;
            }
            this.checkReferenceElement(reference);
        }

        private void checkReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                return;
            }
            PsiType[] typeParameters = reference.getTypeParameters();
            if (typeParameters.length > 0) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            PsiElement qualifier = reference.getQualifier();
            if (qualifier instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement qualifierReference = (PsiJavaCodeReferenceElement)qualifier;
                if (!(aClass.hasModifierProperty("static") || aClass.isInterface() || aClass.isEnum())) {
                    this.checkReferenceElement(qualifierReference);
                }
            }
            if (!aClass.hasTypeParameters()) {
                return;
            }
            this.registerError((PsiElement)reference, new Object[0]);
        }

        private boolean hasNeededLanguageLevel(PsiElement element) {
            return element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && PsiUtil.isLanguageLevel5OrHigher((PsiElement)element);
        }
    }
}

