/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.view;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import javax.swing.JComponent;
import org.jetbrains.generate.tostring.template.TemplateResource;

public class ToStringTemplateConfigurable
implements UnnamedConfigurable {
    private final TemplateResource template;
    private final Editor myEditor;

    public ToStringTemplateConfigurable(TemplateResource template) {
        this.template = template;
        EditorFactory factory = EditorFactory.getInstance();
        Document doc = factory.createDocument((CharSequence)template.getTemplate());
        this.myEditor = template.isDefault() ? factory.createViewer(doc) : factory.createEditor(doc);
    }

    public JComponent createComponent() {
        return this.myEditor.getComponent();
    }

    public boolean isModified() {
        return !Comparing.equal((String)this.myEditor.getDocument().getText(), (String)this.template.getTemplate());
    }

    public void apply() throws ConfigurationException {
        this.template.setTemplate(this.myEditor.getDocument().getText());
    }

    public void reset() {
        new WriteCommandAction(null, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                ToStringTemplateConfigurable.this.myEditor.getDocument().setText((CharSequence)ToStringTemplateConfigurable.this.template.getTemplate());
            }
        }.execute();
    }

    public void disposeUIResources() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }
}

