/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgPromptCommandExecutor;

public class HgMergeCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile repo;
    private String revision;

    public HgMergeCommand(@NotNull Project project, @NotNull VirtualFile repo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgMergeCommand", "<init>"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgMergeCommand", "<init>"));
        }
        this.project = project;
        this.repo = repo;
    }

    public void setRevision(@NotNull String revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/command/HgMergeCommand", "setRevision"));
        }
        this.revision = revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public HgCommandResult execute() {
        HgPromptCommandExecutor commandExecutor = new HgPromptCommandExecutor(this.project);
        commandExecutor.setShowOutput(true);
        LinkedList<String> arguments = new LinkedList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        }
        DvcsUtil.workingTreeChangeStarted((Project)this.project);
        try {
            HgCommandResult result = commandExecutor.executeInCurrentThread(this.repo, "merge", arguments);
            ((HgUpdater)this.project.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.project, null);
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.project);
        }
    }
}

