/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.output.EclipseXMLOutputter;
import org.jdom.output.Format;
import org.jetbrains.annotations.NonNls;

public class EclipseJDOMUtil {
    @NonNls
    private static final String ENCODING = "UTF-8";

    private EclipseJDOMUtil() {
    }

    private static EclipseXMLOutputter createOutputter(String lineSeparator) {
        EclipseXMLOutputter xmlOutputter = new EclipseXMLOutputter(lineSeparator);
        Format format = Format.getCompactFormat().setIndent("\t").setTextMode(Format.TextMode.NORMALIZE).setEncoding(ENCODING).setOmitEncoding(false).setOmitDeclaration(false);
        xmlOutputter.setFormat(format);
        return xmlOutputter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void output(Document doc, File file, Project project) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            EclipseJDOMUtil.createOutputter(CodeStyleSettingsManager.getSettings((Project)project).getLineSeparator()).output(doc, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public static void output(Document document, Writer writer, Project project) throws IOException {
        EclipseJDOMUtil.createOutputter(CodeStyleSettingsManager.getSettings((Project)project).getLineSeparator()).output(document, writer);
    }
}

