/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedLineMarkerProviderBase;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;

public class ExtensionPointDeclarationRelatedItemLineMarkerProvider
extends DevkitRelatedLineMarkerProviderBase {
    private static final NotNullFunction<ExtensionPointCandidate, Collection<? extends PsiElement>> CONVERTER = new NotNullFunction<ExtensionPointCandidate, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(ExtensionPointCandidate candidate) {
            Set<PsiElement> set = Collections.singleton(candidate.pointer.getElement());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/navigation/ExtensionPointDeclarationRelatedItemLineMarkerProvider$1", "fun"));
            }
            return set;
        }
    };
    private static final NotNullFunction<ExtensionPointCandidate, Collection<? extends GotoRelatedItem>> RELATED_ITEM_PROVIDER = new NotNullFunction<ExtensionPointCandidate, Collection<? extends GotoRelatedItem>>(){

        @NotNull
        public Collection<? extends GotoRelatedItem> fun(ExtensionPointCandidate candidate) {
            List list = GotoRelatedItem.createItems(Collections.singleton(candidate.pointer.getElement()), (String)"DevKit");
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/navigation/ExtensionPointDeclarationRelatedItemLineMarkerProvider$2", "fun"));
            }
            return list;
        }
    };

    protected void collectNavigationMarkers(@NotNull PsiElement element, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/navigation/ExtensionPointDeclarationRelatedItemLineMarkerProvider", "collectNavigationMarkers"));
        }
        if (element instanceof PsiField) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.process((PsiField)element, result);
        }
    }

    private static void process(PsiField psiField, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (!ExtensionPointDeclarationRelatedItemLineMarkerProvider.isExtensionPointNameDeclarationField(psiField)) {
            return;
        }
        PsiClass epClass = ExtensionPointDeclarationRelatedItemLineMarkerProvider.resolveExtensionPointClass(psiField);
        if (epClass == null) {
            return;
        }
        final String epName = ExtensionPointDeclarationRelatedItemLineMarkerProvider.resolveEpName(psiField);
        if (epName == null) {
            return;
        }
        ExtensionPointLocator locator = new ExtensionPointLocator(epClass);
        List targets = ContainerUtil.filter(locator.findDirectCandidates(), (Condition)new Condition<ExtensionPointCandidate>(){

            public boolean value(ExtensionPointCandidate candidate) {
                return epName.equals(candidate.epName);
            }
        });
        RelatedItemLineMarkerInfo info = NavigationGutterIconBuilder.create((Icon)AllIcons.Nodes.Plugin, CONVERTER, RELATED_ITEM_PROVIDER).setTargets((Collection)targets).setPopupTitle("Choose Extension Point").setTooltipText("Extension Point Declaration").setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo((PsiElement)psiField.getNameIdentifier());
        result.add((RelatedItemLineMarkerInfo)info);
    }

    @Nullable
    private static PsiClass resolveExtensionPointClass(PsiField psiField) {
        PsiType typeParameter = PsiUtil.substituteTypeParameter((PsiType)psiField.getType(), (String)ExtensionPointName.class.getName(), (int)0, (boolean)false);
        return PsiUtil.resolveClassInClassTypeOnly((PsiType)typeParameter);
    }

    private static String resolveEpName(PsiField psiField) {
        PsiExpression initializer = psiField.getInitializer();
        PsiExpressionList expressionList = null;
        if (initializer instanceof PsiMethodCallExpression) {
            expressionList = ((PsiMethodCallExpression)initializer).getArgumentList();
        } else if (initializer instanceof PsiNewExpression) {
            expressionList = ((PsiNewExpression)initializer).getArgumentList();
        }
        if (expressionList == null) {
            return null;
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        if (expressions.length != 1) {
            return null;
        }
        PsiExpression epNameExpression = expressions[0];
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)psiField.getProject()).getConstantEvaluationHelper();
        Object o = helper.computeConstantExpression((PsiElement)epNameExpression);
        return o instanceof String ? (String)o : null;
    }

    private static boolean isExtensionPointNameDeclarationField(PsiField psiField) {
        if (!psiField.hasModifierProperty("final") || !psiField.hasModifierProperty("static") || psiField.hasModifierProperty("abstract")) {
            return false;
        }
        if (!psiField.hasInitializer()) {
            return false;
        }
        PsiExpression initializer = psiField.getInitializer();
        if (!(initializer instanceof PsiMethodCallExpression) && !(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiClass fieldClass = PsiTypesUtil.getPsiClass((PsiType)psiField.getType());
        if (fieldClass == null) {
            return false;
        }
        return ExtensionPointName.class.getName().equals(fieldClass.getQualifiedName());
    }
}

