/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.NullableFunction;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public interface Function<Param, Result> {
    public static final Function ID = new Function(){

        public Object fun(Object o) {
            return o;
        }
    };
    public static final Function NULL = NullableFunction.NULL;
    public static final Function TO_STRING = new Function(){

        public Object fun(Object o) {
            return String.valueOf(o);
        }
    };

    public Result fun(Param var1);

    public static class Predefined {
        public static <I, O> Function<I, O> NULL() {
            return NULL;
        }

        public static <I, O> Function<I, O> TO_STRING() {
            return TO_STRING;
        }
    }

    public static final class FirstInCollection<P, R extends P>
    implements Function<Collection<P>, R> {
        @Override
        public R fun(Collection<P> ps) {
            return (R)ps.iterator().next();
        }
    }

    public static final class First<P, R extends P>
    implements Function<P[], R> {
        @Override
        public R fun(P[] ps) {
            return (R)ps[0];
        }
    }

    public static final class InstanceOf<P, R extends P>
    implements NullableFunction<P, R> {
        private final Class<R> myResultClass;

        public InstanceOf(Class<R> resultClass) {
            this.myResultClass = resultClass;
        }

        @Override
        @Nullable
        public R fun(P p) {
            return (R)(p.getClass().isAssignableFrom(this.myResultClass) ? p : null);
        }
    }

    public static interface Mono<T>
    extends Function<T, T> {
    }

    public static final class Self<P, R>
    implements Function<P, R> {
        @Override
        public R fun(P p) {
            return (R)p;
        }
    }
}

