/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.SerializationFilter;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.Nullable;

class TagBindingWrapper
implements Binding {
    private final Binding binding;
    private final String myTagName;
    private final String myAttributeName;

    public TagBindingWrapper(Binding binding, String tagName, String attributeName) {
        this.binding = binding;
        assert (binding.getBoundNodeType().isAssignableFrom(Text.class));
        this.myTagName = tagName;
        this.myAttributeName = attributeName;
    }

    @Override
    @Nullable
    public Object serialize(Object o, @Nullable Object context, SerializationFilter filter) {
        Element e = new Element(this.myTagName);
        Content content = (Content)this.binding.serialize(o, e, filter);
        if (content != null) {
            if (!this.myAttributeName.isEmpty()) {
                e.setAttribute(this.myAttributeName, content.getValue());
            } else if (content instanceof Text) {
                e.addContent(content);
            } else {
                e.addContent(content.getValue());
            }
        }
        return e;
    }

    @Override
    public Object deserialize(Object context, Object ... nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/util/xmlb/TagBindingWrapper", "deserialize"));
        }
        assert (nodes.length == 1);
        Element e = (Element)nodes[0];
        Object[] childNodes = !this.myAttributeName.isEmpty() ? new Object[]{e.getAttribute(this.myAttributeName)} : JDOMUtil.getContent(e);
        return this.binding.deserialize(context, childNodes);
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    @Override
    public void init() {
    }
}

