/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering;

import com.android.ide.common.rendering.StaticRenderSession;
import com.android.ide.common.rendering.api.Bridge;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.sdk.LoadStatus;
import com.android.layoutlib.api.ILayoutBridge;
import com.android.layoutlib.api.ILayoutLog;
import com.android.layoutlib.api.ILayoutResult;
import com.android.layoutlib.api.IProjectCallback;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.api.IXmlPullParser;
import com.android.resources.ResourceType;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayoutLibrary {
    public static final String CLASS_BRIDGE = "com.android.layoutlib.bridge.Bridge";
    public static final String FN_ICU_JAR = "icu4j.jar";
    private final Bridge mBridge;
    private final ILayoutBridge mLegacyBridge;
    private final LoadStatus mStatus;
    private final String mLoadMessage;
    private final ClassLoader mClassLoader;
    private Method mViewGetParentMethod;
    private Method mViewGetBaselineMethod;
    private Method mViewParentIndexOfChildMethod;
    private Class<?> mMarginLayoutParamClass;
    private Field mLeftMarginField;
    private Field mTopMarginField;
    private Field mRightMarginField;
    private Field mBottomMarginField;

    public LoadStatus getStatus() {
        return this.mStatus;
    }

    public String getLoadMessage() {
        return this.mLoadMessage;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public static LayoutLibrary load(String layoutLibJarOsPath, ILogger log, String toolName) {
        URLClassLoader classLoader;
        ILayoutBridge legacyBridge;
        Bridge bridge;
        String message;
        LoadStatus status;
        block16: {
            status = LoadStatus.LOADING;
            message = null;
            bridge = null;
            legacyBridge = null;
            classLoader = null;
            try {
                File f = new File(layoutLibJarOsPath);
                if (!f.isFile()) {
                    if (log != null) {
                        log.error(null, "layoutlib.jar is missing!", new Object[0]);
                    }
                } else {
                    Constructor<?> constructor;
                    URL[] urls;
                    File icu4j = new File(f.getParent(), FN_ICU_JAR);
                    if (icu4j.isFile()) {
                        urls = new URL[2];
                        urls[1] = SdkUtils.fileToUrl((File)icu4j);
                    } else {
                        urls = new URL[]{SdkUtils.fileToUrl((File)f)};
                    }
                    classLoader = new URLClassLoader(urls, LayoutLibrary.class.getClassLoader());
                    Class<?> clazz = classLoader.loadClass(CLASS_BRIDGE);
                    if (clazz != null && (constructor = clazz.getConstructor(new Class[0])) != null) {
                        Object bridgeObject = constructor.newInstance(new Object[0]);
                        if (bridgeObject instanceof Bridge) {
                            bridge = (Bridge)bridgeObject;
                        } else if (bridgeObject instanceof ILayoutBridge) {
                            legacyBridge = (ILayoutBridge)bridgeObject;
                        }
                    }
                    if (bridge == null && legacyBridge == null) {
                        status = LoadStatus.FAILED;
                        message = "Failed to load com.android.layoutlib.bridge.Bridge";
                        if (log != null) {
                            log.error(null, "Failed to load com.android.layoutlib.bridge.Bridge from " + layoutLibJarOsPath, new Object[0]);
                        }
                    } else {
                        int api;
                        status = LoadStatus.LOADED;
                        if (bridge != null && (api = bridge.getApiLevel()) > 12) {
                            status = LoadStatus.FAILED;
                            message = String.format("This version of the rendering library is more recent than your version of %1$s. Please update %1$s", toolName);
                        }
                    }
                }
            }
            catch (Throwable t) {
                status = LoadStatus.FAILED;
                Throwable cause = t;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                message = "Failed to load the LayoutLib: " + cause.getMessage();
                if (log == null) break block16;
                log.error(t, message, new Object[0]);
            }
        }
        return new LayoutLibrary(bridge, legacyBridge, classLoader, status, message);
    }

    public int getApiLevel() {
        if (this.mBridge != null) {
            return this.mBridge.getApiLevel();
        }
        if (this.mLegacyBridge != null) {
            return this.getLegacyApiLevel();
        }
        return 0;
    }

    public int getRevision() {
        if (this.mBridge != null) {
            return this.mBridge.getRevision();
        }
        return 0;
    }

    public boolean supports(Capability capability) {
        if (this.mBridge != null) {
            return this.mBridge.getCapabilities().contains(capability);
        }
        if (this.mLegacyBridge != null) {
            switch (capability) {
                case UNBOUND_RENDERING: {
                    return this.getLegacyApiLevel() == 4;
                }
            }
        }
        return false;
    }

    public boolean init(Map<String, String> platformProperties, File fontLocation, Map<String, Map<String, Integer>> enumValueMap, LayoutLog log) {
        if (this.mBridge != null) {
            return this.mBridge.init(platformProperties, fontLocation, enumValueMap, log);
        }
        if (this.mLegacyBridge != null) {
            return this.mLegacyBridge.init(fontLocation.getAbsolutePath(), enumValueMap);
        }
        return false;
    }

    public boolean dispose() {
        if (this.mBridge != null) {
            return this.mBridge.dispose();
        }
        return true;
    }

    public RenderSession createSession(SessionParams params) {
        if (this.mBridge != null) {
            List infoList;
            RenderSession session = this.mBridge.createSession(params);
            if (params.getExtendedViewInfoMode() && !this.mBridge.getCapabilities().contains(Capability.EXTENDED_VIEWINFO) && (infoList = session.getRootViews()) != null) {
                for (ViewInfo info : infoList) {
                    this.addExtendedViewInfo(info);
                }
            }
            return session;
        }
        if (this.mLegacyBridge != null) {
            return this.createLegacySession(params);
        }
        return null;
    }

    public Result renderDrawable(DrawableParams params) {
        if (this.mBridge != null) {
            return this.mBridge.renderDrawable(params);
        }
        return Result.Status.NOT_IMPLEMENTED.createResult();
    }

    public void clearCaches(Object projectKey) {
        if (this.mBridge != null) {
            this.mBridge.clearCaches(projectKey);
        } else if (this.mLegacyBridge != null) {
            this.mLegacyBridge.clearCaches(projectKey);
        }
    }

    public Result getViewParent(Object viewObject) {
        Result r;
        if (this.mBridge != null && (r = this.mBridge.getViewParent(viewObject)).isSuccess()) {
            return r;
        }
        return this.getViewParentWithReflection(viewObject);
    }

    public Result getViewIndex(Object viewObject) {
        Result r;
        if (this.mBridge != null && (r = this.mBridge.getViewIndex(viewObject)).isSuccess()) {
            return r;
        }
        return this.getViewIndexReflection(viewObject);
    }

    public boolean isRtl(String locale) {
        return this.supports(Capability.RTL) ? this.mBridge.isRtl(locale) : false;
    }

    private LayoutLibrary(Bridge bridge, ILayoutBridge legacyBridge, ClassLoader classLoader, LoadStatus status, String message) {
        this.mBridge = bridge;
        this.mLegacyBridge = legacyBridge;
        this.mClassLoader = classLoader;
        this.mStatus = status;
        this.mLoadMessage = message;
    }

    private int getLegacyApiLevel() {
        int apiLevel = 1;
        try {
            apiLevel = this.mLegacyBridge.getApiLevel();
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        return apiLevel;
    }

    private RenderSession createLegacySession(SessionParams params) {
        if (!(params.getLayoutDescription() instanceof IXmlPullParser)) {
            throw new IllegalArgumentException("Parser must be of type ILegacyPullParser");
        }
        if (!(params.getProjectCallback() instanceof IProjectCallback)) {
            throw new IllegalArgumentException("Project callback must be of type ILegacyCallback");
        }
        if (!(params.getResources() instanceof ResourceResolver)) {
            throw new IllegalArgumentException("RenderResources object must be of type ResourceResolver");
        }
        ResourceResolver resources = (ResourceResolver)params.getResources();
        int apiLevel = this.getLegacyApiLevel();
        final LayoutLog log = params.getLog();
        ILayoutLog logWrapper = new ILayoutLog(){

            public void warning(String message) {
                log.warning(null, message, null);
            }

            public void error(Throwable t) {
                log.error(null, "error!", t, null);
            }

            public void error(String message) {
                log.error(null, message, null);
            }
        };
        Map<String, Map<String, IResourceValue>> projectMap = this.convertMap(resources.getProjectResources());
        Map<String, Map<String, IResourceValue>> frameworkMap = this.convertMap(resources.getFrameworkResources());
        ILayoutResult result = null;
        if (apiLevel == 4) {
            result = this.mLegacyBridge.computeLayout((IXmlPullParser)params.getLayoutDescription(), params.getProjectKey(), params.getScreenWidth(), params.getScreenHeight(), params.getRenderingMode() == SessionParams.RenderingMode.FULL_EXPAND, params.getDensity().getDpiValue(), params.getXdpi(), params.getYdpi(), resources.getThemeName(), resources.isProjectTheme(), projectMap, frameworkMap, (IProjectCallback)params.getProjectCallback(), logWrapper);
        } else if (apiLevel == 3) {
            result = this.mLegacyBridge.computeLayout((IXmlPullParser)params.getLayoutDescription(), params.getProjectKey(), params.getScreenWidth(), params.getScreenHeight(), params.getDensity().getDpiValue(), params.getXdpi(), params.getYdpi(), resources.getThemeName(), resources.isProjectTheme(), projectMap, frameworkMap, (IProjectCallback)params.getProjectCallback(), logWrapper);
        } else if (apiLevel == 2) {
            result = this.mLegacyBridge.computeLayout((IXmlPullParser)params.getLayoutDescription(), params.getProjectKey(), params.getScreenWidth(), params.getScreenHeight(), resources.getThemeName(), resources.isProjectTheme(), projectMap, frameworkMap, (IProjectCallback)params.getProjectCallback(), logWrapper);
        } else {
            String themeName = resources.getThemeName();
            if (resources.isProjectTheme()) {
                themeName = "*" + themeName;
            }
            result = this.mLegacyBridge.computeLayout((IXmlPullParser)params.getLayoutDescription(), params.getProjectKey(), params.getScreenWidth(), params.getScreenHeight(), themeName, projectMap, frameworkMap, (IProjectCallback)params.getProjectCallback(), logWrapper);
        }
        this.legacyCleanUp();
        return this.convertToScene(result);
    }

    private Map<String, Map<String, IResourceValue>> convertMap(Map<ResourceType, Map<String, ResourceValue>> map) {
        HashMap<String, Map<String, IResourceValue>> result = new HashMap<String, Map<String, IResourceValue>>();
        for (Map.Entry<ResourceType, Map<String, ResourceValue>> entry : map.entrySet()) {
            result.put(entry.getKey().getName(), entry.getValue());
        }
        return result;
    }

    private RenderSession convertToScene(ILayoutResult result) {
        Result sceneResult;
        ViewInfo rootViewInfo = null;
        if (result.getSuccess() == 0) {
            sceneResult = Result.Status.SUCCESS.createResult();
            ILayoutResult.ILayoutViewInfo oldRootView = result.getRootView();
            if (oldRootView != null) {
                rootViewInfo = this.convertToViewInfo(oldRootView);
            }
        } else {
            sceneResult = Result.Status.ERROR_UNKNOWN.createResult(result.getErrorMessage());
        }
        return new StaticRenderSession(sceneResult, rootViewInfo, result.getImage());
    }

    private ViewInfo convertToViewInfo(ILayoutResult.ILayoutViewInfo view) {
        ViewInfo viewInfo = new ViewInfo(view.getName(), view.getViewKey(), view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        ILayoutResult.ILayoutViewInfo[] children = view.getChildren();
        if (children != null) {
            ArrayList<ViewInfo> convertedChildren = new ArrayList<ViewInfo>(children.length);
            for (ILayoutResult.ILayoutViewInfo child : children) {
                convertedChildren.add(this.convertToViewInfo(child));
            }
            viewInfo.setChildren(convertedChildren);
        }
        return viewInfo;
    }

    private void legacyCleanUp() {
        try {
            Class<?> looperClass = this.mClassLoader.loadClass("android.os.Looper");
            Field threadLocalField = looperClass.getField("sThreadLocal");
            if (threadLocalField != null) {
                threadLocalField.setAccessible(true);
                ThreadLocal threadLocal = (ThreadLocal)threadLocalField.get(null);
                if (threadLocal != null) {
                    threadLocal.remove();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Result getViewParentWithReflection(Object viewObject) {
        try {
            if (this.mViewGetParentMethod == null) {
                Class<?> viewClass = Class.forName("android.view.View");
                this.mViewGetParentMethod = viewClass.getMethod("getParent", new Class[0]);
            }
            return Result.Status.SUCCESS.createResult(this.mViewGetParentMethod.invoke(viewObject, new Object[0]));
        }
        catch (Exception e) {
            return Result.Status.ERROR_REFLECTION.createResult(null, (Throwable)e);
        }
    }

    private Result getViewIndexReflection(Object viewObject) {
        try {
            Class<?> viewClass = Class.forName("android.view.View");
            if (this.mViewGetParentMethod == null) {
                this.mViewGetParentMethod = viewClass.getMethod("getParent", new Class[0]);
            }
            Object parentObject = this.mViewGetParentMethod.invoke(viewObject, new Object[0]);
            if (this.mViewParentIndexOfChildMethod == null) {
                Class<?> viewParentClass = Class.forName("android.view.ViewParent");
                this.mViewParentIndexOfChildMethod = viewParentClass.getMethod("indexOfChild", viewClass);
            }
            return Result.Status.SUCCESS.createResult(this.mViewParentIndexOfChildMethod.invoke(parentObject, viewObject));
        }
        catch (Exception e) {
            return Result.Status.ERROR_REFLECTION.createResult(null, (Throwable)e);
        }
    }

    private void addExtendedViewInfo(ViewInfo info) {
        this.computeExtendedViewInfo(info);
        List children = info.getChildren();
        for (ViewInfo child : children) {
            this.addExtendedViewInfo(child);
        }
    }

    private void computeExtendedViewInfo(ViewInfo info) {
        Object viewObject = info.getViewObject();
        Object params = info.getLayoutParamsObject();
        int baseLine = this.getViewBaselineReflection(viewObject);
        int leftMargin = 0;
        int topMargin = 0;
        int rightMargin = 0;
        int bottomMargin = 0;
        try {
            if (this.mMarginLayoutParamClass == null) {
                this.mMarginLayoutParamClass = Class.forName("android.view.ViewGroup$MarginLayoutParams");
                this.mLeftMarginField = this.mMarginLayoutParamClass.getField("leftMargin");
                this.mTopMarginField = this.mMarginLayoutParamClass.getField("topMargin");
                this.mRightMarginField = this.mMarginLayoutParamClass.getField("rightMargin");
                this.mBottomMarginField = this.mMarginLayoutParamClass.getField("bottomMargin");
            }
            if (this.mMarginLayoutParamClass.isAssignableFrom(params.getClass())) {
                leftMargin = (Integer)this.mLeftMarginField.get(params);
                topMargin = (Integer)this.mTopMarginField.get(params);
                rightMargin = (Integer)this.mRightMarginField.get(params);
                bottomMargin = (Integer)this.mBottomMarginField.get(params);
            }
        }
        catch (Exception e) {
            leftMargin = Integer.MIN_VALUE;
            topMargin = Integer.MIN_VALUE;
            rightMargin = Integer.MIN_VALUE;
            bottomMargin = Integer.MIN_VALUE;
        }
        info.setExtendedInfo(baseLine, leftMargin, topMargin, rightMargin, bottomMargin);
    }

    private int getViewBaselineReflection(Object viewObject) {
        try {
            Object result;
            if (this.mViewGetBaselineMethod == null) {
                Class<?> viewClass = Class.forName("android.view.View");
                this.mViewGetBaselineMethod = viewClass.getMethod("getBaseline", new Class[0]);
            }
            if ((result = this.mViewGetBaselineMethod.invoke(viewObject, new Object[0])) instanceof Integer) {
                return (Integer)result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.MIN_VALUE;
    }

    protected LayoutLibrary() {
        this.mBridge = null;
        this.mLegacyBridge = null;
        this.mClassLoader = null;
        this.mStatus = null;
        this.mLoadMessage = null;
    }
}

