/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;

public enum WorkingCopyFormat {
    ONE_DOT_THREE(4, false, false, false, SvnBundle.message("dialog.show.svn.map.table.version13.text", new Object[0]), new Version(1, 3, 0)),
    ONE_DOT_FOUR(8, false, false, false, SvnBundle.message("dialog.show.svn.map.table.version14.text", new Object[0]), new Version(1, 4, 0)),
    ONE_DOT_FIVE(9, true, true, false, SvnBundle.message("dialog.show.svn.map.table.version15.text", new Object[0]), new Version(1, 5, 0)),
    ONE_DOT_SIX(10, true, true, true, SvnBundle.message("dialog.show.svn.map.table.version16.text", new Object[0]), new Version(1, 6, 0)),
    ONE_DOT_SEVEN(12, true, true, true, SvnBundle.message("dialog.show.svn.map.table.version17.text", new Object[0]), new Version(1, 7, 0)),
    ONE_DOT_EIGHT(12, true, true, true, SvnBundle.message("dialog.show.svn.map.table.version18.text", new Object[0]), new Version(1, 8, 0)),
    UNKNOWN(0, false, false, false, "unknown", new Version(0, 0, 0));

    public static final int INTERNAL_FORMAT_17 = 29;
    public static final int INTERNAL_FORMAT_18 = 31;
    private final int myFormat;
    private final boolean myChangelistSupport;
    private final boolean myMergeInfoSupport;
    private final boolean myTreeConflictSupport;
    private final String myName;
    @NotNull
    private final Version myVersion;

    private WorkingCopyFormat(int format, boolean changelistSupport, boolean mergeInfoSupport, @NotNull boolean treeConflictSupport, String name, Version version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/idea/svn/WorkingCopyFormat", "<init>"));
        }
        this.myFormat = format;
        this.myChangelistSupport = changelistSupport;
        this.myMergeInfoSupport = mergeInfoSupport;
        this.myTreeConflictSupport = treeConflictSupport;
        this.myName = name;
        this.myVersion = version;
    }

    public boolean supportsChangelists() {
        return this.myChangelistSupport;
    }

    public boolean supportsMergeInfo() {
        return this.myMergeInfoSupport;
    }

    public boolean supportsTreeConflicts() {
        return this.myTreeConflictSupport;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public Version getVersion() {
        Version version = this.myVersion;
        if (version == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/WorkingCopyFormat", "getVersion"));
        }
        return version;
    }

    @NotNull
    public static WorkingCopyFormat getInstance(int value) {
        if (29 == value) {
            WorkingCopyFormat workingCopyFormat = ONE_DOT_SEVEN;
            if (workingCopyFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/WorkingCopyFormat", "getInstance"));
            }
            return workingCopyFormat;
        }
        if (31 == value) {
            WorkingCopyFormat workingCopyFormat = ONE_DOT_EIGHT;
            if (workingCopyFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/WorkingCopyFormat", "getInstance"));
            }
            return workingCopyFormat;
        }
        if (ONE_DOT_FIVE.getFormat() == value) {
            WorkingCopyFormat workingCopyFormat = ONE_DOT_FIVE;
            if (workingCopyFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/WorkingCopyFormat", "getInstance"));
            }
            return workingCopyFormat;
        }
        if (ONE_DOT_FOUR.getFormat() == value) {
            WorkingCopyFormat workingCopyFormat = ONE_DOT_FOUR;
            if (workingCopyFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/WorkingCopyFormat", "getInstance"));
            }
            return workingCopyFormat;
        }
        if (ONE_DOT_THREE.getFormat() == value) {
            WorkingCopyFormat workingCopyFormat = ONE_DOT_THREE;
            if (workingCopyFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/WorkingCopyFormat", "getInstance"));
            }
            return workingCopyFormat;
        }
        if (ONE_DOT_SIX.getFormat() == value) {
            WorkingCopyFormat workingCopyFormat = ONE_DOT_SIX;
            if (workingCopyFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/WorkingCopyFormat", "getInstance"));
            }
            return workingCopyFormat;
        }
        if (ONE_DOT_SEVEN.getFormat() == value) {
            WorkingCopyFormat workingCopyFormat = ONE_DOT_SEVEN;
            if (workingCopyFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/WorkingCopyFormat", "getInstance"));
            }
            return workingCopyFormat;
        }
        WorkingCopyFormat workingCopyFormat = UNKNOWN;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/WorkingCopyFormat", "getInstance"));
        }
        return workingCopyFormat;
    }

    public int getFormat() {
        return this.myFormat;
    }

    public boolean isOrGreater(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/WorkingCopyFormat", "isOrGreater"));
        }
        return this.myVersion.isOrGreaterThan(Integer.valueOf(format.getVersion().major), Integer.valueOf(format.getVersion().minor));
    }

    public boolean less(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/WorkingCopyFormat", "less"));
        }
        return this.myVersion.lessThan(Integer.valueOf(format.getVersion().major), Integer.valueOf(format.getVersion().minor));
    }

    @NotNull
    public static WorkingCopyFormat from(@NotNull Version version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/idea/svn/WorkingCopyFormat", "from"));
        }
        WorkingCopyFormat result = UNKNOWN;
        for (WorkingCopyFormat format : WorkingCopyFormat.values()) {
            if (!format.getVersion().is(Integer.valueOf(version.major), Integer.valueOf(version.minor))) continue;
            result = format;
            break;
        }
        WorkingCopyFormat workingCopyFormat = result;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/WorkingCopyFormat", "from"));
        }
        return workingCopyFormat;
    }

    public String toString() {
        return this.getName();
    }
}

