/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.templates.TemplateUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PathUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowLicensesUsedAction
extends AnAction {
    public ShowLicensesUsedAction() {
        super("Show Licenses...");
    }

    public void actionPerformed(AnActionEvent e) {
        LicenseDialog licenseDialog = new LicenseDialog(ShowLicensesUsedAction.getEventProject((AnActionEvent)e));
        licenseDialog.init();
        try {
            licenseDialog.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class LicenseDialog
    extends DialogWrapper {
        protected LicenseDialog(@Nullable Project project) {
            super(project);
            this.getWindow().setMinimumSize(new Dimension(600, 400));
        }

        protected void init() {
            super.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            StringBuilder sb = new StringBuilder(5000);
            File licenseDir = new File(PathManager.getHomePath(), "license");
            assert (licenseDir.exists()) : licenseDir;
            for (File file : TemplateUtils.listFiles(licenseDir)) {
                sb.append("<br><br>");
                sb.append(LicenseDialog.getLicenseText(file));
            }
            File androidLicenses = new File(PathManager.getPreInstalledPluginsPath(), PathUtil.toSystemDependentName((String)"android/lib/NOTICE"));
            if (androidLicenses.exists()) {
                sb.append(LicenseDialog.getLicenseText(androidLicenses));
            }
            String text = "<html>" + sb.toString() + "</html>";
            JBScrollPane pane = new JBScrollPane((Component)new JBLabel(text));
            pane.setPreferredSize(new Dimension(600, 400));
            panel.add((Component)pane, "Center");
            return panel;
        }

        @NotNull
        private static String getLicenseText(@NotNull File f) {
            String string;
            if (f == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/android/tools/idea/actions/ShowLicensesUsedAction$LicenseDialog", "getLicenseText"));
            }
            try {
                string = Files.toString((File)f, (Charset)Charsets.UTF_8).replaceAll("\\<.*?\\>", "").replace("\n", "<br>");
            }
            catch (IOException e) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/ShowLicensesUsedAction$LicenseDialog", "getLicenseText"));
                }
                return "";
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/ShowLicensesUsedAction$LicenseDialog", "getLicenseText"));
            }
            return string;
        }
    }
}

