/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.CloneDeviceAction;
import com.android.tools.idea.avdmanager.CreateDeviceAction;
import com.android.tools.idea.avdmanager.DeleteDeviceAction;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import com.android.tools.idea.avdmanager.EditDeviceAction;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceDefinitionList
extends JPanel
implements ListSelectionListener,
DocumentListener,
DeviceUiAction.DeviceProvider {
    private static final double PHONE_SIZE_CUTOFF = 6.0;
    private static final String SEARCH_RESULTS = "Search Results";
    private Map<String, List<Device>> myDeviceCategoryMap;
    private static final DecimalFormat ourDecimalFormat = new DecimalFormat(".##");
    private final ListTableModel<Device> myModel;
    private TableView<Device> myTable;
    private final ListTableModel<String> myCategoryModel;
    private TableView<String> myCategoryList;
    private JButton myCreateProfileButton;
    private JButton myImportProfileButton;
    private JButton myRefreshButton;
    private JPanel myPanel;
    private SearchTextField mySearchTextField;
    private List<DeviceDefinitionSelectionListener> myListeners;
    private List<Device> myDevices;
    private final ColumnInfo[] myCategoryInfo;
    private final ColumnInfo[] myColumnInfos;
    private final Border myBorder;
    private final TableCellRenderer myRenderer;

    public DeviceDefinitionList() {
        this.$$$setupUI$$$();
        this.myDeviceCategoryMap = Maps.newHashMap();
        this.myModel = new ListTableModel(new ColumnInfo[0]);
        this.myCategoryModel = new ListTableModel(new ColumnInfo[0]);
        this.myListeners = Lists.newArrayList();
        this.myCategoryInfo = new ColumnInfo[]{new ColumnInfo<String, String>("Category"){

            @Nullable
            public String valueOf(String category) {
                return category;
            }

            @Nullable
            public TableCellRenderer getRenderer(String s) {
                return DeviceDefinitionList.this.myRenderer;
            }
        }};
        this.myColumnInfos = new ColumnInfo[]{new DeviceColumnInfo("Name"){

            @Nullable
            public String valueOf(Device device) {
                return device.getDisplayName();
            }

            @Override
            @Nullable
            public Comparator<Device> getComparator() {
                return new Comparator<Device>(){

                    @Override
                    public int compare(Device o1, Device o2) {
                        String name2;
                        String name1 = this.valueOf(o1);
                        if (name1 == (name2 = this.valueOf(o2))) {
                            return 0;
                        }
                        if (name1 == null || name2 == null || name1.isEmpty() || name2.isEmpty()) {
                            return name1 == null ? -1 : 1;
                        }
                        char firstChar1 = name1.charAt(0);
                        char firstChar2 = name2.charAt(0);
                        if (Character.isLetter(firstChar1) && !Character.isLetter(firstChar2)) {
                            return 1;
                        }
                        if (Character.isLetter(firstChar2) && !Character.isLetter(firstChar1)) {
                            return -1;
                        }
                        return name1.compareTo(name2);
                    }
                };
            }
        }, new DeviceColumnInfo("Size"){

            @Nullable
            public String valueOf(Device device) {
                return DeviceDefinitionList.getDiagonalSize(device);
            }

            @Override
            @Nullable
            public Comparator<Device> getComparator() {
                return new Comparator<Device>(){

                    @Override
                    public int compare(Device o1, Device o2) {
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        return Double.valueOf(o1.getDefaultHardware().getScreen().getDiagonalLength()).compareTo(o2.getDefaultHardware().getScreen().getDiagonalLength());
                    }
                };
            }
        }, new DeviceColumnInfo("Resolution"){

            @Nullable
            public String valueOf(Device device) {
                return DeviceDefinitionList.getDimensionString(device);
            }

            @Override
            @Nullable
            public Comparator<Device> getComparator() {
                return new Comparator<Device>(){

                    @Override
                    public int compare(Device o1, Device o2) {
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        Dimension d1 = o1.getScreenSize(o1.getDefaultState().getOrientation());
                        Dimension d2 = o2.getScreenSize(o2.getDefaultState().getOrientation());
                        if (d1 == null) {
                            return -1;
                        }
                        if (d2 == null) {
                            return 1;
                        }
                        return Integer.valueOf(d1.width * d1.height).compareTo(d2.width * d2.height);
                    }
                };
            }
        }, new DeviceColumnInfo("Density"){

            @Nullable
            public String valueOf(Device device) {
                return DeviceDefinitionList.getDensityString(device);
            }
        }};
        this.myBorder = IdeBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10);
        this.myRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JBLabel label = new JBLabel((String)value);
                label.setBorder(DeviceDefinitionList.this.myBorder);
                if (table.getSelectedRow() == row) {
                    label.setBackground(table.getSelectionBackground());
                    label.setForeground(table.getSelectionForeground());
                    label.setOpaque(true);
                }
                return label;
            }
        };
        this.myModel.setColumnInfos(this.myColumnInfos);
        this.myModel.setSortable(true);
        this.refreshDeviceProfiles();
        this.myTable.setModelAndUpdateColumns(this.myModel);
        this.myTable.getRowSorter().toggleSortOrder(0);
        this.myTable.getRowSorter().toggleSortOrder(0);
        this.myTable.setSelectionMode(0);
        this.myTable.setRowSelectionAllowed(true);
        this.setLayout(new BorderLayout());
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceDefinitionList.this.refreshDeviceProfiles();
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(this);
        this.myCategoryModel.setColumnInfos(this.myCategoryInfo);
        this.myCategoryList.setModelAndUpdateColumns(this.myCategoryModel);
        this.myCategoryList.getSelectionModel().addListSelectionListener(this);
        this.mySearchTextField.addDocumentListener((DocumentListener)this);
        this.add((Component)this.myPanel, "Center");
        this.myCategoryList.setSelection((Collection)ImmutableSet.of((Object)this.myCategoryModel.getItem(0)));
        this.myCreateProfileButton.setAction(new CreateDeviceAction(this));
        this.myCreateProfileButton.setText("New Hardware Profile");
        this.myTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DeviceDefinitionList.this.possiblyShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DeviceDefinitionList.this.possiblyShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DeviceDefinitionList.this.possiblyShowPopup(e);
            }
        });
    }

    @NotNull
    private static JBMenuItem createMenuItem(@NotNull DeviceUiAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "createMenuItem"));
        }
        JBMenuItem item = new JBMenuItem((Action)action);
        item.setText(action.getText());
        JBMenuItem jBMenuItem = item;
        if (jBMenuItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "createMenuItem"));
        }
        return jBMenuItem;
    }

    private void possiblyShowPopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        if (row != -1 && col != -1) {
            JBPopupMenu menu = new JBPopupMenu();
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new CloneDeviceAction(this)));
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new EditDeviceAction(this)));
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new DeleteDeviceAction(this)));
            menu.show(this.myTable, p.x, p.y);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.myCategoryList.getSelectionModel())) {
            this.setCategory((String)this.myCategoryList.getSelectedObject());
        } else if (e.getSource().equals(this.myTable.getSelectionModel())) {
            this.onSelectionSet((Device)this.myTable.getSelectedObject());
        }
    }

    public void addSelectionListener(@NotNull DeviceDefinitionSelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "addSelectionListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeSelectionListener(@NotNull DeviceDefinitionSelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "removeSelectionListener"));
        }
        this.myListeners.remove(listener);
    }

    public void setSelectedDevice(@Nullable Device device) {
        this.onSelectionSet(device);
        if (device != null) {
            String category = DeviceDefinitionList.getCategory(device);
            this.myCategoryList.setSelection((Collection)ImmutableSet.of((Object)category));
            this.setCategory(category);
            for (Device listItem : this.myModel.getItems()) {
                if (!listItem.getId().equals(device.getId())) continue;
                this.myTable.setSelection((Collection)ImmutableSet.of((Object)listItem));
            }
        }
    }

    private void onSelectionSet(@Nullable Device selectedObject) {
        for (DeviceDefinitionSelectionListener listener : this.myListeners) {
            listener.onDeviceSelectionChanged(selectedObject);
        }
    }

    private void setCategory(@Nullable String selectedCategory) {
        if (this.myDeviceCategoryMap.containsKey(selectedCategory)) {
            this.myModel.setItems(this.myDeviceCategoryMap.get(selectedCategory));
        }
    }

    private void refreshDeviceProfiles() {
        this.myDevices = DeviceManagerConnection.getDevices();
        this.myDeviceCategoryMap.clear();
        for (Device d : this.myDevices) {
            String category = DeviceDefinitionList.getCategory(d);
            if (!this.myDeviceCategoryMap.containsKey(category)) {
                this.myDeviceCategoryMap.put(category, new ArrayList(1));
            }
            this.myDeviceCategoryMap.get(category).add(d);
        }
        Set<String> categories = this.myDeviceCategoryMap.keySet();
        Object[] categoryArray = categories.toArray(new String[categories.size()]);
        this.myCategoryModel.setItems((List)Lists.newArrayList((Object[])categoryArray));
        this.myModel.setItems(this.myDeviceCategoryMap.get(categoryArray[0]));
    }

    private static String getCategory(@NotNull Device d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "getCategory"));
        }
        if (HardwareConfigHelper.isTv((Device)d)) {
            return FormFactorUtils.FormFactor.TV.toString();
        }
        if (HardwareConfigHelper.isWear((Device)d)) {
            return FormFactorUtils.FormFactor.WEAR.toString();
        }
        if (DeviceDefinitionList.isTablet(d)) {
            return "Tablet";
        }
        if (DeviceDefinitionList.isPhone(d)) {
            return "Phone";
        }
        return "Other";
    }

    private static boolean isPhone(@NotNull Device d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "isPhone"));
        }
        return d.getDefaultHardware().getScreen().getDiagonalLength() < 6.0;
    }

    private static boolean isTablet(@NotNull Device d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "isTablet"));
        }
        return d.getDefaultHardware().getScreen().getDiagonalLength() >= 6.0;
    }

    public static String getDiagonalSize(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "getDiagonalSize"));
        }
        return ourDecimalFormat.format(device.getDefaultHardware().getScreen().getDiagonalLength()) + '\"';
    }

    public static String getDimensionString(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "getDimensionString"));
        }
        Dimension size = device.getScreenSize(device.getDefaultState().getOrientation());
        return size == null ? "Unknown Resolution" : String.format(Locale.getDefault(), "%dx%d", size.width, size.height);
    }

    public static String getDensityString(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "getDensityString"));
        }
        return device.getDefaultHardware().getScreen().getPixelDensity().getResourceValue();
    }

    private void createUIComponents() {
        this.myCategoryList = new TableView();
        this.myTable = new TableView();
        this.myRefreshButton = new JButton(AllIcons.Actions.Refresh);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateSearchResults(this.getText(e.getDocument()));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateSearchResults(this.getText(e.getDocument()));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateSearchResults(this.getText(e.getDocument()));
    }

    private String getText(Document d) {
        try {
            return d.getText(0, d.getLength());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private void updateSearchResults(final @NotNull String searchString) {
        if (searchString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchString", "com/android/tools/idea/avdmanager/DeviceDefinitionList", "updateSearchResults"));
        }
        if (searchString.isEmpty()) {
            if (((String)this.myCategoryModel.getItem(this.myCategoryModel.getRowCount() - 1)).equals(SEARCH_RESULTS)) {
                this.myCategoryModel.removeRow(this.myCategoryModel.getRowCount() - 1);
                this.setCategory((String)this.myCategoryList.getRow(0));
            }
            return;
        }
        if (!((String)this.myCategoryModel.getItem(this.myCategoryModel.getRowCount() - 1)).equals(SEARCH_RESULTS)) {
            this.myCategoryModel.addRow((Object)SEARCH_RESULTS);
            this.myCategoryList.setSelection((Collection)ImmutableSet.of((Object)SEARCH_RESULTS));
        }
        this.myModel.setItems((List)Lists.newArrayList((Iterable)Iterables.filter(this.myDevices, (Predicate)new Predicate<Device>(){

            public boolean apply(Device input) {
                return input.getDisplayName().toLowerCase().contains(searchString.toLowerCase());
            }
        })));
    }

    @Override
    @Nullable
    public Device getDevice() {
        return (Device)this.myTable.getSelectedObject();
    }

    @Override
    public void refreshDevices() {
        this.refreshDeviceProfiles();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SearchTextField searchTextField;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 3, null, new Dimension(100, -1), new Dimension(100, -1)));
        TableView<String> tableView = this.myCategoryList;
        jBScrollPane.setViewportView((Component)tableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        TableView<Device> tableView2 = this.myTable;
        jBScrollPane2.setViewportView((Component)tableView2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCreateProfileButton = jButton2 = new JButton();
        jButton2.setText("New Hardware Profile");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myImportProfileButton = jButton = new JButton();
        ((Component)jButton).setVisible(false);
        jButton.setText("Import Hardware Profiles");
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JButton jButton3 = this.myRefreshButton;
        jButton3.setText("");
        jPanel2.add((Component)jButton3, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySearchTextField = searchTextField = new SearchTextField();
        jPanel.add((Component)searchTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static interface DeviceDefinitionSelectionListener {
        public void onDeviceSelectionChanged(@Nullable Device var1);
    }

    private abstract class DeviceColumnInfo
    extends ColumnInfo<Device, String> {
        private final int myWidth;

        @Nullable
        public Comparator<Device> getComparator() {
            return new Comparator<Device>(){

                @Override
                public int compare(Device o1, Device o2) {
                    if (o1 == null || DeviceColumnInfo.this.valueOf(o1) == null) {
                        return -1;
                    }
                    if (o2 == null || DeviceColumnInfo.this.valueOf(o2) == null) {
                        return 1;
                    }
                    return ((String)DeviceColumnInfo.this.valueOf(o1)).compareTo((String)DeviceColumnInfo.this.valueOf(o2));
                }
            };
        }

        public DeviceColumnInfo(String name, int width) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/DeviceDefinitionList$DeviceColumnInfo", "<init>"));
            }
            super(name);
            this.myWidth = width;
        }

        public DeviceColumnInfo(String name) {
            this(name, -1);
        }

        @Nullable
        public TableCellRenderer getRenderer(Device device) {
            return DeviceDefinitionList.this.myRenderer;
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }
    }
}

