/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import icons.AndroidIcons;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceDefinitionPreview
extends JPanel {
    private static final double PIXELS_PER_INCH = 45.0;
    private static final String NO_DEVICE_SELECTED = "No Device Selected";
    private static final int FIGURE_PADDING = 3;
    private static final DecimalFormat FORMAT = new DecimalFormat(".##\"");
    public static final int DIMENSION_LINE_WIDTH = 1;
    public static final int OUTLINE_LINE_WIDTH = 5;
    private Device myDevice;
    private static final int PADDING = 20;
    private static final JBColor OUR_GRAY = new JBColor((Color)Gray._192, (Color)Gray._96);

    public void setDevice(@Nullable Device device) {
        this.myDevice = device;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(JBColor.background());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(JBColor.foreground());
        g2d.setFont(AvdWizardConstants.STANDARD_FONT);
        if (this.myDevice == null) {
            FontMetrics metrics = g2d.getFontMetrics();
            g2d.drawString(NO_DEVICE_SELECTED, (this.getWidth() - metrics.stringWidth(NO_DEVICE_SELECTED)) / 2, (this.getHeight() - metrics.getHeight()) / 2);
            return;
        }
        boolean isCircular = DeviceDefinitionPreview.isCircular(this.myDevice);
        Icon icon = DeviceDefinitionPreview.getIcon(this.myDevice);
        icon.paintIcon(this, g, 10, 10);
        g2d.setFont(AvdWizardConstants.TITLE_FONT);
        FontMetrics metrics = g.getFontMetrics(AvdWizardConstants.TITLE_FONT);
        g2d.drawString(this.myDevice.getDisplayName(), 50, 20 + metrics.getHeight() / 2);
        g2d.drawLine(0, 50, this.getWidth(), 50);
        Dimension screenSize = this.getScaledDimension(this.myDevice);
        Dimension pixelScreenSize = this.myDevice.getScreenSize(this.myDevice.getDefaultState().getOrientation());
        if (screenSize != null) {
            Density pixelDensity;
            ScreenRatio ratio;
            int infoSegmentY;
            int infoSegmentX;
            if (screenSize.getHeight() <= 0.0) {
                screenSize.height = 1;
            }
            if (screenSize.getWidth() <= 0.0) {
                screenSize.width = 1;
            }
            RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(20.0, 100.0, screenSize.width, screenSize.height, 10.0, 10.0);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setColor((Color)OUR_GRAY);
            g2d.setFont(AvdWizardConstants.FIGURE_FONT);
            metrics = g2d.getFontMetrics(AvdWizardConstants.FIGURE_FONT);
            int stringHeight = metrics.getHeight() - metrics.getDescent();
            String widthString = Integer.toString(pixelScreenSize.width) + "px";
            int widthLineY = 95 - (metrics.getHeight() - metrics.getDescent()) / 2;
            g2d.drawLine(20, widthLineY, DeviceDefinitionPreview.round(20.0 + ((RectangularShape)roundRect).getWidth()), widthLineY);
            g2d.setColor(JBColor.background());
            int widthStringWidth = metrics.stringWidth(widthString);
            int widthTextX = DeviceDefinitionPreview.round(20.0 + (((RectangularShape)roundRect).getWidth() - (double)widthStringWidth) / 2.0);
            g2d.drawLine(widthTextX - 3, widthLineY, widthTextX + widthStringWidth + 3, widthLineY);
            g2d.setColor(JBColor.foreground());
            g2d.drawString(widthString, widthTextX, 95);
            g2d.setColor((Color)OUR_GRAY);
            String heightString = Integer.toString(pixelScreenSize.height) + "px";
            int heightLineX = DeviceDefinitionPreview.round(20.0 + ((RectangularShape)roundRect).getWidth() + 15.0);
            g2d.drawLine(heightLineX, 100, heightLineX, DeviceDefinitionPreview.round(100.0 + ((RectangularShape)roundRect).getHeight()));
            g2d.setColor(JBColor.background());
            int heightTextY = DeviceDefinitionPreview.round(100.0 + (((RectangularShape)roundRect).getHeight() + (double)stringHeight) / 2.0);
            g2d.drawLine(heightLineX, heightTextY + 3, heightLineX, heightTextY - stringHeight - 3);
            g2d.setColor(JBColor.foreground());
            g2d.drawString(heightString, heightLineX - 10, heightTextY);
            g2d.setColor((Color)OUR_GRAY);
            String diagString = FORMAT.format(this.myDevice.getDefaultHardware().getScreen().getDiagonalLength());
            int diagTextX = DeviceDefinitionPreview.round(20.0 + (((RectangularShape)roundRect).getWidth() - (double)metrics.stringWidth(diagString)) / 2.0);
            int diagTextY = DeviceDefinitionPreview.round(100.0 + (((RectangularShape)roundRect).getHeight() + (double)stringHeight) / 2.0);
            Line2D.Double diagLine = new Line2D.Double(20.0, DeviceDefinitionPreview.round(100.0 + ((RectangularShape)roundRect).getHeight()), DeviceDefinitionPreview.round(20.0 + ((RectangularShape)roundRect).getWidth()), 100.0);
            if (isCircular) {
                double dist = 0.5 * (((RectangularShape)roundRect).getWidth() - ((RectangularShape)roundRect).getWidth() / Math.sqrt(2.0));
                ((Line2D)diagLine).setLine(((Line2D)diagLine).getX1() + dist, ((Line2D)diagLine).getY1() - dist, ((Line2D)diagLine).getX2() - dist, ((Line2D)diagLine).getY2() + dist);
            }
            g2d.draw(diagLine);
            g2d.setColor(JBColor.background());
            Rectangle erasureRect = new Rectangle(diagTextX - 3, diagTextY - stringHeight - 3, metrics.stringWidth(diagString) + 6, stringHeight + 6);
            g2d.fill(erasureRect);
            g2d.setColor(JBColor.foreground());
            g2d.drawString(diagString, diagTextX, diagTextY);
            g2d.setStroke(new BasicStroke(5.0f));
            g2d.setColor(JBColor.foreground());
            if (isCircular) {
                Ellipse2D.Double circle = new Ellipse2D.Double(((RectangularShape)roundRect).getX(), ((RectangularShape)roundRect).getY(), ((RectangularShape)roundRect).getWidth(), ((RectangularShape)roundRect).getHeight());
                g2d.draw(circle);
            } else {
                g2d.draw(roundRect);
            }
            g2d.setFont(AvdWizardConstants.STANDARD_FONT);
            metrics = g2d.getFontMetrics(AvdWizardConstants.STANDARD_FONT);
            stringHeight = metrics.getHeight();
            if (this.myDevice.getDefaultState().getOrientation().equals((Object)ScreenOrientation.PORTRAIT)) {
                infoSegmentX = DeviceDefinitionPreview.round(20.0 + ((RectangularShape)roundRect).getWidth() + (double)metrics.stringWidth(heightString) + 20.0);
                infoSegmentY = 100;
            } else {
                infoSegmentX = 20;
                infoSegmentY = DeviceDefinitionPreview.round(100.0 + ((RectangularShape)roundRect).getHeight() + 20.0);
            }
            infoSegmentY += stringHeight;
            ScreenSize size = this.myDevice.getDefaultHardware().getScreen().getSize();
            if (size != null) {
                g2d.drawString("Size:      " + size.getResourceValue(), infoSegmentX, infoSegmentY);
                infoSegmentY += stringHeight;
            }
            if ((ratio = this.myDevice.getDefaultHardware().getScreen().getRatio()) != null) {
                g2d.drawString("Ratio:    " + ratio.getResourceValue(), infoSegmentX, infoSegmentY);
                infoSegmentY += stringHeight;
            }
            if ((pixelDensity = this.myDevice.getDefaultHardware().getScreen().getPixelDensity()) != null) {
                g2d.drawString("Density: " + pixelDensity.getResourceValue(), infoSegmentX, infoSegmentY);
            }
        }
    }

    public static boolean isCircular(@NotNull Device device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "isCircular"));
        }
        String circularProp = (String)device.getBootProps().get("ro.emulator.circular");
        return "true".equals(circularProp);
    }

    private static int round(double d) {
        return (int)Math.round(d);
    }

    @Nullable
    private Dimension getScaledDimension(@NotNull Device device) {
        int pixelHeight;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "getScaledDimension"));
        }
        Dimension pixelSize = device.getScreenSize(device.getDefaultState().getOrientation());
        if (pixelSize == null) {
            return null;
        }
        int density = device.getDefaultHardware().getScreen().getPixelDensity().getDpiValue();
        double inchWidth = (double)pixelSize.width * 1.0 / (double)density;
        double inchHeight = (double)pixelSize.height * 1.0 / (double)density;
        int pixelWidth = DeviceDefinitionPreview.round(inchWidth * 45.0);
        for (pixelHeight = DeviceDefinitionPreview.round(inchHeight * 45.0); pixelHeight > this.getHeight() / 2 || pixelWidth > this.getWidth() / 2; pixelHeight /= 2, pixelWidth /= 2) {
        }
        return new Dimension(pixelWidth, pixelHeight);
    }

    @NotNull
    public static Icon getIcon(@Nullable Device device) {
        if (device == null) {
            Icon icon = AndroidIcons.FormFactors.Mobile_32;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "getIcon"));
            }
            return icon;
        }
        if (HardwareConfigHelper.isTv((Device)device)) {
            Icon icon = AndroidIcons.FormFactors.Tv_32;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "getIcon"));
            }
            return icon;
        }
        if (HardwareConfigHelper.isWear((Device)device)) {
            Icon icon = AndroidIcons.FormFactors.Wear_32;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "getIcon"));
            }
            return icon;
        }
        Icon icon = AndroidIcons.FormFactors.Mobile_32;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/DeviceDefinitionPreview", "getIcon"));
        }
        return icon;
    }
}

