/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.CachedDependencyNotFoundErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.ClassLoadingErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.CorruptGradleDependencyErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.FailedToParseSdkErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.GenericErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.Gradle2RequiredErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.GradleSettingsErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.InternetConnectionErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.JavaHeapSpaceErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.MissingAndroidSdkErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.MissingAndroidSupportRepoErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.MissingBuildToolsErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.MissingDependencyErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.MissingPlatformErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.ObjectStreamErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.SdkBuildToolsTooLowErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.UnexpectedErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.UnknownHostErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.UnsupportedGradleVersionErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.UnsupportedModelVersionErrorHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleNotificationExtension
implements ExternalSystemNotificationExtension {
    private final List<AbstractSyncErrorHandler> myHandlers;

    public GradleNotificationExtension() {
        this(Arrays.asList(new Gradle2RequiredErrorHandler(), new UnsupportedModelVersionErrorHandler(), new FailedToParseSdkErrorHandler(), new GradleSettingsErrorHandler(), new MissingAndroidSdkErrorHandler(), new MissingAndroidSupportRepoErrorHandler(), new UnsupportedGradleVersionErrorHandler(), new SdkBuildToolsTooLowErrorHandler(), new MissingPlatformErrorHandler(), new MissingBuildToolsErrorHandler(), new InternetConnectionErrorHandler(), new MissingDependencyErrorHandler(), new CachedDependencyNotFoundErrorHandler(), new UnexpectedErrorHandler(), new UnknownHostErrorHandler(), new CorruptGradleDependencyErrorHandler(), new JavaHeapSpaceErrorHandler(), new ClassLoadingErrorHandler(), new ObjectStreamErrorHandler(), new GenericErrorHandler()));
    }

    @VisibleForTesting
    GradleNotificationExtension(@NotNull List<AbstractSyncErrorHandler> errorHandlers) {
        if (errorHandlers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandlers", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "<init>"));
        }
        this.myHandlers = errorHandlers;
    }

    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "getTargetExternalSystemId"));
        }
        return projectSystemId;
    }

    public void customize(@NotNull NotificationData notification, @NotNull Project project, @Nullable Throwable error) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "customize"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "customize"));
        }
        Throwable cause = error;
        if (error instanceof UndeclaredThrowableException && (cause = ((UndeclaredThrowableException)error).getUndeclaredThrowable()) instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof ExternalSystemException) {
            this.handleError((ExternalSystemException)cause, notification, project);
        }
    }

    private void handleError(ExternalSystemException error, NotificationData notification, Project project) {
        String msg = error.getMessage();
        if (StringUtil.isEmpty((String)msg)) {
            return;
        }
        List<String> lines = GradleNotificationExtension.splitLines(msg);
        for (AbstractSyncErrorHandler handler : this.myHandlers) {
            if (!handler.handleError(lines, error, notification, project)) continue;
            return;
        }
    }

    @NotNull
    private static List<String> splitLines(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "splitLines"));
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)Splitter.on((char)'\n').split((CharSequence)s));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/notification/GradleNotificationExtension", "splitLines"));
        }
        return arrayList;
    }
}

