/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.android.tools.idea.ui.WrapsAwareTextHelper;
import com.google.common.collect.Lists;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapAwareColoredComponent
extends JComponent
implements Accessible,
ColoredTextContainer {
    private static final boolean isOracleRetina = UIUtil.isRetina() && SystemInfo.isOracleJvm;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.SimpleColoredComponent");
    public static final Color SHADOW_COLOR;
    public static final Color STYLE_SEARCH_MATCH_BACKGROUND;
    public static final int FRAGMENT_ICON = -2;
    @NotNull
    private final List<String> myFragments = Lists.newArrayListWithCapacity((int)3);
    @NotNull
    private final List<SimpleTextAttributes> myAttributes = Lists.newArrayListWithCapacity((int)3);
    @NotNull
    private final TIntObjectHashMap<TIntArrayList> myBreakOffsets = new TIntObjectHashMap();
    @NotNull
    private final TIntIntHashMap myLineHeights = new TIntIntHashMap();
    @NotNull
    private final Dimension myTextDimensions = new Dimension();
    @NotNull
    private final WrapsAwareTextHelper myTextHelper = new WrapsAwareTextHelper(this);
    @NotNull
    private final String myLineBreakMarker;
    @NotNull
    private Insets myIpad = new Insets(1, 2, 1, 2);
    @Nullable
    private Border myBorder = new MyBorder();
    @Nullable
    private List<Object> myFragmentTags;
    @Nullable
    private Icon myIcon;
    @Nullable
    private Integer myLastUsedWidthLimit;
    protected int myIconTextGap = 2;
    private boolean myPaintFocusBorder;
    private boolean myFocusBorderAroundIcon;
    private int myMainTextLastIndex = -1;
    private final TIntIntHashMap myFixedWidths = new TIntIntHashMap(10);
    @JdkConstants.HorizontalAlignment
    private int myTextAlign = 2;
    private boolean myIconOpaque = false;
    private boolean myAutoInvalidate = !(this instanceof TreeCellRenderer);
    private final AccessibleContext myContext = new MyAccessibleContext();
    private boolean myIconOnTheRight = false;
    private boolean myTransparentIconBackground;
    private boolean myWrapText;

    public WrapAwareColoredComponent() {
        this.setOpaque(true);
        WrapsAwareTextHelper.appendLineBreak(this.myFragments);
        this.myLineBreakMarker = this.myFragments.get(0);
        this.myFragments.clear();
    }

    @NotNull
    public ColoredIterator iterator() {
        MyIterator myIterator = new MyIterator();
        if (myIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "iterator"));
        }
        return myIterator;
    }

    public boolean isIconOnTheRight() {
        return this.myIconOnTheRight;
    }

    public void setIconOnTheRight(boolean iconOnTheRight) {
        this.myIconOnTheRight = iconOnTheRight;
    }

    @NotNull
    public WrapAwareColoredComponent appendLineBreak() {
        WrapsAwareTextHelper.appendLineBreak(this.myFragments);
        this.myAttributes.add(SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myMainTextLastIndex = this.myFragments.size() - 1;
        this.resetTextLayoutCache();
        WrapAwareColoredComponent wrapAwareColoredComponent = this;
        if (wrapAwareColoredComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "appendLineBreak"));
        }
        return wrapAwareColoredComponent;
    }

    @NotNull
    public final WrapAwareColoredComponent append(@NotNull String fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/ui/WrapAwareColoredComponent", "append"));
        }
        this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        WrapAwareColoredComponent wrapAwareColoredComponent = this;
        if (wrapAwareColoredComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "append"));
        }
        return wrapAwareColoredComponent;
    }

    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/ui/WrapAwareColoredComponent", "append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/ui/WrapAwareColoredComponent", "append"));
        }
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/ui/WrapAwareColoredComponent", "append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/ui/WrapAwareColoredComponent", "append"));
        }
        this._append(fragment, attributes, isMainText);
        this.revalidateAndRepaint();
    }

    private synchronized void _append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/ui/WrapAwareColoredComponent", "_append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/ui/WrapAwareColoredComponent", "_append"));
        }
        this.myFragments.add(fragment);
        this.myAttributes.add(attributes);
        if (isMainText) {
            this.myMainTextLastIndex = this.myFragments.size() - 1;
        }
        this.resetTextLayoutCache();
    }

    private void revalidateAndRepaint() {
        if (this.myAutoInvalidate) {
            this.revalidate();
        }
        this.repaint();
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/ui/WrapAwareColoredComponent", "append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/ui/WrapAwareColoredComponent", "append"));
        }
        this._append(fragment, attributes, tag);
        this.revalidateAndRepaint();
    }

    private synchronized void _append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, @Nullable Object tag) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/ui/WrapAwareColoredComponent", "_append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/ui/WrapAwareColoredComponent", "_append"));
        }
        this.append(fragment, attributes);
        if (this.myFragmentTags == null) {
            this.myFragmentTags = new ArrayList<Object>();
        }
        while (this.myFragmentTags.size() < this.myFragments.size() - 1) {
            this.myFragmentTags.add(null);
        }
        this.myFragmentTags.add(tag);
    }

    public synchronized void appendFixedTextFragmentWidth(int width) {
        int alignIndex = this.myFragments.size() - 1;
        this.myFixedWidths.put(alignIndex, width);
    }

    public void setTextAlign(@JdkConstants.HorizontalAlignment int align) {
        this.myTextAlign = align;
    }

    public void clear() {
        this._clear();
        this.revalidateAndRepaint();
    }

    private synchronized void _clear() {
        this.myIcon = null;
        this.myPaintFocusBorder = false;
        this.myFragments.clear();
        this.myAttributes.clear();
        this.myFragmentTags = null;
        this.myMainTextLastIndex = -1;
        this.myFixedWidths.clear();
        this.resetTextLayoutCache();
    }

    public void resetTextLayoutCache() {
        this.myLastUsedWidthLimit = null;
        this.myBreakOffsets.clear();
    }

    @Nullable
    public final Icon getIcon() {
        return this.myIcon;
    }

    public final void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
        this.revalidateAndRepaint();
    }

    @NotNull
    public Insets getIpad() {
        Insets insets = this.myIpad;
        if (insets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "getIpad"));
        }
        return insets;
    }

    public void setIpad(@NotNull Insets ipad) {
        if (ipad == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ipad", "com/android/tools/idea/ui/WrapAwareColoredComponent", "setIpad"));
        }
        this.myIpad = ipad;
        this.revalidateAndRepaint();
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (iconTextGap < 0) {
            throw new IllegalArgumentException("wrong iconTextGap: " + iconTextGap);
        }
        this.myIconTextGap = iconTextGap;
        this.revalidateAndRepaint();
    }

    @Nullable
    public Border getMyBorder() {
        return this.myBorder;
    }

    public void setMyBorder(@Nullable Border border) {
        this.myBorder = border;
    }

    protected final void setPaintFocusBorder(boolean paintFocusBorder) {
        this.myPaintFocusBorder = paintFocusBorder;
        this.repaint();
    }

    protected final void setFocusBorderAroundIcon(boolean focusBorderAroundIcon) {
        this.myFocusBorderAroundIcon = focusBorderAroundIcon;
        this.repaint();
    }

    public boolean isIconOpaque() {
        return this.myIconOpaque;
    }

    public void setIconOpaque(boolean iconOpaque) {
        this.myIconOpaque = iconOpaque;
        this.repaint();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = this.computePreferredSize(false);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "getPreferredSize"));
        }
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension = this.computePreferredSize(false);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "getMinimumSize"));
        }
        return dimension;
    }

    @Nullable
    public synchronized Object getFragmentTag(int index) {
        if (this.myFragmentTags != null && index < this.myFragmentTags.size()) {
            return this.myFragmentTags.get(index);
        }
        return null;
    }

    @NotNull
    public final synchronized Dimension computePreferredSize(boolean mainTextOnly) {
        int width = this.myIpad.left;
        if (this.myIcon != null) {
            width += this.myIcon.getIconWidth() + this.myIconTextGap;
        }
        Insets borderInsets = this.myBorder != null ? this.myBorder.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        width += borderInsets.left;
        Font font = this.getFont();
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        LOG.assertTrue(font != null);
        int height = this.myIpad.top + this.myIpad.bottom;
        width += this.myIpad.right + borderInsets.right;
        Insets insets = this.getInsets();
        if (insets != null) {
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
        }
        if (isOracleRetina) {
            ++width;
        }
        assert (font != null);
        Dimension textDimension = this.computeTextDimension(font, mainTextOnly, this.myWrapText ? this.getWidth() - width : 0);
        int textHeight = textDimension.height;
        height = this.myIcon != null ? (height += Math.max(this.myIcon.getIconHeight(), textHeight)) : (height += (textHeight += borderInsets.top + borderInsets.bottom));
        Dimension dimension = new Dimension(width += textDimension.width, height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "computePreferredSize"));
        }
        return dimension;
    }

    @NotNull
    private Dimension computeTextDimension(@NotNull Font font, boolean mainTextOnly, int widthLimit) {
        List<SimpleTextAttributes> attributesToUse;
        List<String> fragmentsToUse;
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/android/tools/idea/ui/WrapAwareColoredComponent", "computeTextDimension"));
        }
        if (this.myLastUsedWidthLimit != null && widthLimit == this.myLastUsedWidthLimit) {
            Dimension dimension = this.myTextDimensions;
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "computeTextDimension"));
            }
            return dimension;
        }
        if (mainTextOnly && this.myMainTextLastIndex >= 0 && this.myMainTextLastIndex < this.myFragments.size() - 1) {
            fragmentsToUse = this.myFragments.subList(0, this.myMainTextLastIndex);
            attributesToUse = this.myAttributes.subList(0, this.myMainTextLastIndex);
        } else {
            fragmentsToUse = this.myFragments;
            attributesToUse = this.myAttributes;
        }
        this.myBreakOffsets.clear();
        this.myLineHeights.clear();
        this.myTextHelper.wrap(fragmentsToUse, attributesToUse, font, this.myFixedWidths, widthLimit, this.myTextDimensions, this.myBreakOffsets, this.myLineHeights);
        this.myLastUsedWidthLimit = widthLimit;
        Dimension dimension = this.myTextDimensions;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "computeTextDimension"));
        }
        return dimension;
    }

    public int findFragmentAt(int x, int y) {
        this.computePreferredSize(false);
        int curX = this.myIpad.left;
        if (this.myIcon != null) {
            int iconStartX;
            if (this.myIconOnTheRight) {
                iconStartX = curX + this.myTextDimensions.width + this.myIconTextGap;
            } else {
                iconStartX = curX;
                curX += this.myIcon.getIconWidth() + this.myIconTextGap;
            }
            if (x >= iconStartX && x < iconStartX + this.myIcon.getIconWidth()) {
                return -2;
            }
        }
        if (x - curX >= 0 && x - curX < this.myTextDimensions.width && y >= 0 && y <= this.myTextDimensions.height) {
            return this.myTextHelper.mapFragment(this.myFragments, this.myAttributes, this.myFixedWidths, this.myBreakOffsets, this.myLineHeights, this.getFont(), x - curX, y);
        }
        return -1;
    }

    @Nullable
    public Object getFragmentTagAt(int x, int y) {
        int index = this.findFragmentAt(x, y);
        return index < 0 ? null : this.getFragmentTag(index);
    }

    @NotNull
    protected JLabel formatToLabel(@NotNull JLabel label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/ui/WrapAwareColoredComponent", "formatToLabel"));
        }
        label.setIcon(this.myIcon);
        if (!this.myFragments.isEmpty()) {
            StringBuilder text = new StringBuilder();
            text.append("<html><body style=\"white-space:nowrap\">");
            for (int i = 0; i < this.myFragments.size(); ++i) {
                String fragment = this.myFragments.get(i);
                SimpleTextAttributes attributes = this.myAttributes.get(i);
                Object tag = this.getFragmentTag(i);
                if (tag instanceof BrowserLauncherTag) {
                    WrapAwareColoredComponent.formatLink(text, fragment, attributes, ((BrowserLauncherTag)tag).myUrl);
                    continue;
                }
                WrapAwareColoredComponent.formatText(text, fragment, attributes);
            }
            text.append("</body></html>");
            label.setText(text.toString());
        }
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "formatToLabel"));
        }
        return jLabel;
    }

    static void formatText(@NotNull StringBuilder builder, @NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/ui/WrapAwareColoredComponent", "formatText"));
        }
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/ui/WrapAwareColoredComponent", "formatText"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/ui/WrapAwareColoredComponent", "formatText"));
        }
        if (!fragment.isEmpty()) {
            builder.append("<span");
            WrapAwareColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(WrapAwareColoredComponent.convertFragment(fragment)).append("</span>");
        }
    }

    static void formatLink(@NotNull StringBuilder builder, @NotNull String fragment, @NotNull SimpleTextAttributes attributes, @NotNull String url) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/ui/WrapAwareColoredComponent", "formatLink"));
        }
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/ui/WrapAwareColoredComponent", "formatLink"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/ui/WrapAwareColoredComponent", "formatLink"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/ui/WrapAwareColoredComponent", "formatLink"));
        }
        if (!fragment.isEmpty()) {
            builder.append("<a href=\"").append(StringUtil.replace((String)url, (String)"\"", (String)"%22")).append("\"");
            WrapAwareColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(WrapAwareColoredComponent.convertFragment(fragment)).append("</a>");
        }
    }

    @NotNull
    private static String convertFragment(@NotNull String fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/ui/WrapAwareColoredComponent", "convertFragment"));
        }
        String string = StringUtil.escapeXml((String)fragment).replaceAll("\\\\n", "<br>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "convertFragment"));
        }
        return string;
    }

    private static void formatStyle(StringBuilder builder, SimpleTextAttributes attributes) {
        Color fgColor = attributes.getFgColor();
        Color bgColor = attributes.getBgColor();
        int style = attributes.getStyle();
        int pos = builder.length();
        if (fgColor != null) {
            builder.append("color:#").append(Integer.toString(fgColor.getRGB() & 0xFFFFFF, 16)).append(';');
        }
        if (bgColor != null) {
            builder.append("background-color:#").append(Integer.toString(bgColor.getRGB() & 0xFFFFFF, 16)).append(';');
        }
        if ((style & 1) != 0) {
            builder.append("font-weight:bold;");
        }
        if ((style & 2) != 0) {
            builder.append("font-style:italic;");
        }
        if ((style & 0x10) != 0) {
            builder.append("text-decoration:underline;");
        } else if ((style & 4) != 0) {
            builder.append("text-decoration:line-through;");
        }
        if (builder.length() > pos) {
            builder.insert(pos, " style=\"");
            builder.append('\"');
        }
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "paintComponent"));
        }
        try {
            this._doPaint(g);
        }
        catch (RuntimeException e) {
            LOG.error(this.logSwingPath(), (Throwable)e);
            throw e;
        }
    }

    private synchronized void _doPaint(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "_doPaint"));
        }
        WrapAwareColoredComponent.checkCanPaint(g);
        this.doPaint((Graphics2D)g);
    }

    protected void doPaint(@NotNull Graphics2D g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "doPaint"));
        }
        int offset = 0;
        Icon icon = this.myIcon;
        if (icon != null && !this.myIconOnTheRight) {
            this.doPaintIcon(g, icon, 0);
            offset += this.myIpad.left + icon.getIconWidth() + this.myIconTextGap;
        }
        this.doPaintTextBackground(g, offset);
        offset = this.doPaintText(g, offset, this.myFocusBorderAroundIcon || icon == null);
        if (icon != null && this.myIconOnTheRight) {
            this.doPaintIcon(g, icon, offset);
        }
    }

    private void doPaintTextBackground(@NotNull Graphics2D g, int offset) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "doPaintTextBackground"));
        }
        if (this.isOpaque() || this.shouldDrawBackground()) {
            this.paintBackground(g, offset, this.getWidth() - offset, this.getHeight());
        }
    }

    protected void paintBackground(@NotNull Graphics2D g, int x, int width, int height) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "paintBackground"));
        }
        g.setColor(this.getBackground());
        g.fillRect(x, 0, width, height);
    }

    protected void doPaintIcon(@NotNull Graphics2D g, @NotNull Icon icon, int offset) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "doPaintIcon"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/ui/WrapAwareColoredComponent", "doPaintIcon"));
        }
        Container parent = this.getParent();
        Color iconBackgroundColor = null;
        if ((this.isOpaque() || this.isIconOpaque()) && !this.isTransparentIconBackground()) {
            iconBackgroundColor = parent != null && !this.myFocusBorderAroundIcon && !UIUtil.isFullRowSelectionLAF() ? parent.getBackground() : this.getBackground();
        }
        if (iconBackgroundColor != null) {
            g.setColor(iconBackgroundColor);
            g.fillRect(offset, 0, icon.getIconWidth() + this.myIpad.left + this.myIconTextGap, this.getHeight());
        }
        this.paintIcon(g, icon, offset + this.myIpad.left);
    }

    protected int doPaintText(@NotNull Graphics2D g, int offset, boolean focusAroundIcon) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "doPaintText"));
        }
        this.computePreferredSize(false);
        if (offset == 0) {
            offset = this.myIpad.left;
        }
        int textStart = offset;
        if (this.myBorder != null) {
            offset += this.myBorder.getBorderInsets((Component)this).left;
        }
        ArrayList<Object[]> searchMatches = new ArrayList<Object[]>();
        UIUtil.applyRenderingHints((Graphics)g);
        this.applyAdditionalHints(g);
        Font ownFont = this.getFont();
        if (ownFont != null) {
            offset += this.computeTextAlignShift(ownFont);
        }
        int baseSize = ownFont != null ? ownFont.getSize() : g.getFont().getSize();
        boolean wasSmaller = false;
        int x = offset;
        int y = 0;
        int line = 0;
        boolean beforePaintTextCalled = false;
        for (int i = 0; i < this.myFragments.size(); ++i) {
            String wholeFragmentTextToDraw;
            SimpleTextAttributes attributes = this.myAttributes.get(i);
            Font font = g.getFont();
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            g.setFont(font);
            FontMetrics metrics = g.getFontMetrics(font);
            int lineHeight = this.myLineHeights.get(line++);
            if (lineHeight <= 0) {
                lineHeight = metrics.getHeight();
            }
            if (this.myLineBreakMarker.equals(wholeFragmentTextToDraw = this.myFragments.get(i))) {
                y += lineHeight;
                x = offset;
                continue;
            }
            Color color = attributes.getFgColor();
            if (color == null) {
                color = this.getForeground();
            }
            if (!this.isEnabled()) {
                color = UIUtil.getInactiveTextColor();
            }
            g.setColor(color);
            TextRange range = this.nextFragmentLineRange(i, null);
            while (range != null) {
                int fixedWidth;
                Color bgColor;
                if (range.getStartOffset() > 0) {
                    if ((lineHeight = this.myLineHeights.get(++line)) <= 0) {
                        lineHeight = metrics.getHeight();
                    }
                    x = offset;
                    y += lineHeight;
                }
                String textToDraw = wholeFragmentTextToDraw.substring(range.getStartOffset(), range.getEndOffset());
                int textWidth = isOracleRetina ? GraphicsUtil.stringWidth((String)textToDraw, (Font)font) : metrics.stringWidth(textToDraw);
                int textBaseline = y + WrapAwareColoredComponent.getTextBaseLine(metrics, lineHeight);
                if (!beforePaintTextCalled) {
                    this.beforePaintText(g, x, textBaseline);
                }
                Color color2 = bgColor = attributes.isSearchMatch() ? null : attributes.getBgColor();
                if ((attributes.isOpaque() || this.isOpaque()) && bgColor != null) {
                    g.setColor(bgColor);
                    g.fillRect(x, y, textWidth, lineHeight);
                }
                if (!attributes.isSearchMatch()) {
                    if (this.shouldDrawMacShadow()) {
                        g.setColor(SHADOW_COLOR);
                        g.drawString(textToDraw, x, textBaseline + 1);
                    }
                    if (this.shouldDrawDimmed()) {
                        color = ColorUtil.dimmer((Color)color);
                    }
                    g.setColor(color);
                    g.drawString(textToDraw, x, textBaseline);
                }
                if (attributes.isStrikeout()) {
                    int strikeOutAt = textBaseline + (metrics.getDescent() - metrics.getAscent()) / 2;
                    UIUtil.drawLine((Graphics)g, (int)x, (int)strikeOutAt, (int)(x + textWidth), (int)strikeOutAt);
                }
                if (attributes.isWaved()) {
                    if (attributes.getWaveColor() != null) {
                        g.setColor(attributes.getWaveColor());
                    }
                    int wavedAt = textBaseline + 1;
                    for (int waveX = x; waveX <= x + textWidth; waveX += 4) {
                        UIUtil.drawLine((Graphics)g, (int)waveX, (int)wavedAt, (int)(waveX + 2), (int)(wavedAt + 2));
                        UIUtil.drawLine((Graphics)g, (int)(waveX + 3), (int)(wavedAt + 1), (int)(waveX + 4), (int)wavedAt);
                    }
                }
                if (attributes.isUnderline()) {
                    int underlineAt = textBaseline + 1;
                    UIUtil.drawLine((Graphics)g, (int)x, (int)underlineAt, (int)(x + textWidth), (int)underlineAt);
                }
                if (attributes.isBoldDottedLine()) {
                    int dottedAt = SystemInfo.isMac ? textBaseline : textBaseline + 1;
                    Color lineColor = attributes.getWaveColor();
                    UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x, (int)(x + textWidth), (int)dottedAt, (Color)bgColor, (Color)lineColor, (boolean)this.isOpaque());
                }
                if (attributes.isSearchMatch()) {
                    searchMatches.add(new Object[]{x, x + textWidth, textBaseline, textToDraw, g.getFont(), lineHeight});
                }
                x = (fixedWidth = this.myFixedWidths.get(i)) > 0 && textWidth < fixedWidth ? (x += fixedWidth) : (x += textWidth);
                range = this.nextFragmentLineRange(i, range);
            }
        }
        if (this.myPaintFocusBorder && this.myBorder != null) {
            if (focusAroundIcon) {
                this.myBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                this.myBorder.paintBorder(this, g, textStart, 0, this.getWidth() - textStart, this.getHeight());
            }
        }
        for (Object[] info : searchMatches) {
            UIUtil.drawSearchMatch((Graphics2D)g, (int)((Integer)info[0]), (int)((Integer)info[1]), (int)((Integer)info[5]));
            g.setFont((Font)info[4]);
            if (this.shouldDrawMacShadow()) {
                g.setColor(SHADOW_COLOR);
                g.drawString((String)info[3], (int)((Integer)info[0]), (Integer)info[2] + 1);
            }
            g.setColor((Color)new JBColor((Color)Gray._50, (Color)Gray._0));
            g.drawString((String)info[3], (int)((Integer)info[0]), (int)((Integer)info[2]));
        }
        return offset;
    }

    protected void beforePaintText(@NotNull Graphics g, int x, int textBaseLine) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "beforePaintText"));
        }
    }

    @Nullable
    private TextRange nextFragmentLineRange(int fragmentIndex, @Nullable TextRange previousFragmentLineRange) {
        TIntArrayList breakOffsets = (TIntArrayList)this.myBreakOffsets.get(fragmentIndex);
        String fragmentText = this.myFragments.get(fragmentIndex);
        if (breakOffsets == null || breakOffsets.isEmpty()) {
            if (previousFragmentLineRange == null) {
                return TextRange.allOf((String)fragmentText);
            }
            return null;
        }
        if (previousFragmentLineRange == null) {
            return TextRange.create((int)0, (int)breakOffsets.get(0));
        }
        for (int i = 0; i < breakOffsets.size(); ++i) {
            if (breakOffsets.get(i) != previousFragmentLineRange.getEndOffset()) continue;
            if (i < breakOffsets.size() - 1) {
                return TextRange.create((int)previousFragmentLineRange.getEndOffset(), (int)breakOffsets.get(i + 1));
            }
            return TextRange.create((int)previousFragmentLineRange.getEndOffset(), (int)fragmentText.length());
        }
        return null;
    }

    private int computeTextAlignShift(@NotNull Font font) {
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/android/tools/idea/ui/WrapAwareColoredComponent", "computeTextAlignShift"));
        }
        if (this.myTextAlign == 2 || this.myTextAlign == 10) {
            return 0;
        }
        int componentWidth = this.getSize().width;
        int excessiveWidth = componentWidth - this.computePreferredSize((boolean)false).width;
        if (excessiveWidth <= 0) {
            return 0;
        }
        Dimension textDimension = this.computeTextDimension(font, false, this.myWrapText ? this.getWidth() : 0);
        if (this.myTextAlign == 0) {
            return excessiveWidth / 2;
        }
        if (this.myTextAlign == 4 || this.myTextAlign == 11) {
            return excessiveWidth;
        }
        return 0;
    }

    protected boolean shouldDrawMacShadow() {
        return false;
    }

    protected boolean shouldDrawDimmed() {
        return false;
    }

    protected boolean shouldDrawBackground() {
        return false;
    }

    protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon, int offset) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "paintIcon"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/ui/WrapAwareColoredComponent", "paintIcon"));
        }
        int y = this.myLineHeights.size() <= 1 ? (this.getHeight() - icon.getIconHeight()) / 2 : (icon.getIconHeight() > this.myLineHeights.get(0) ? this.myIpad.top : this.myIpad.top + (this.myLineHeights.get(0) - icon.getIconHeight()) / 2);
        icon.paintIcon(this, g, offset, y);
    }

    protected void applyAdditionalHints(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "applyAdditionalHints"));
        }
    }

    @Override
    public int getBaseline(int width, int height) {
        super.getBaseline(width, height);
        return WrapAwareColoredComponent.getTextBaseLine(this.getFontMetrics(this.getFont()), height);
    }

    public boolean isTransparentIconBackground() {
        return this.myTransparentIconBackground;
    }

    public void setTransparentIconBackground(boolean transparentIconBackground) {
        this.myTransparentIconBackground = transparentIconBackground;
    }

    public void setWrapText(boolean wrapText) {
        if (this.myWrapText != wrapText) {
            this.resetTextLayoutCache();
        }
        this.myWrapText = wrapText;
    }

    public static int getTextBaseLine(@NotNull FontMetrics metrics, int height) {
        if (metrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metrics", "com/android/tools/idea/ui/WrapAwareColoredComponent", "getTextBaseLine"));
        }
        return (height - metrics.getHeight()) / 2 + metrics.getAscent();
    }

    private static void checkCanPaint(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/ui/WrapAwareColoredComponent", "checkCanPaint"));
        }
        if (UIUtil.isPrinting((Graphics)g)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.assertIsDispatchThread();
        } else if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException(Thread.currentThread().toString());
        }
    }

    @NotNull
    private String logSwingPath() {
        StringBuilder buffer = new StringBuilder("Components hierarchy:\n");
        for (Container c = this; c != null; c = c.getParent()) {
            buffer.append('\n');
            buffer.append(c);
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "logSwingPath"));
        }
        return string;
    }

    protected void setBorderInsets(@NotNull Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insets", "com/android/tools/idea/ui/WrapAwareColoredComponent", "setBorderInsets"));
        }
        if (this.myBorder instanceof MyBorder) {
            ((MyBorder)this.myBorder).setInsets(insets);
        }
        this.revalidateAndRepaint();
    }

    @NotNull
    public CharSequence getCharSequence(boolean mainOnly) {
        List<String> fragments = mainOnly && this.myMainTextLastIndex > -1 && this.myMainTextLastIndex + 1 < this.myFragments.size() ? this.myFragments.subList(0, this.myMainTextLastIndex + 1) : this.myFragments;
        String string = StringUtil.join(fragments, (String)"");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "getCharSequence"));
        }
        return string;
    }

    @Override
    @NotNull
    public String toString() {
        String string = ((Object)this.getCharSequence(false)).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent", "toString"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(@NotNull Runnable runnable, boolean autoInvalidate) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/ui/WrapAwareColoredComponent", "change"));
        }
        boolean old = this.myAutoInvalidate;
        this.myAutoInvalidate = autoInvalidate;
        try {
            runnable.run();
        }
        finally {
            this.myAutoInvalidate = old;
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.myContext;
    }

    static {
        STYLE_SEARCH_MATCH_BACKGROUND = SHADOW_COLOR = new JBColor(new Color(250, 250, 250, 140), Gray._0.withAlpha(50));
    }

    private class MyIterator
    implements ColoredIterator {
        int myIndex = -1;
        int myOffset;
        int myEndOffset;

        private MyIterator() {
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        @Override
        @NotNull
        public String getFragment() {
            String string = (String)WrapAwareColoredComponent.this.myFragments.get(this.myIndex);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent$MyIterator", "getFragment"));
            }
            return string;
        }

        @Override
        @NotNull
        public SimpleTextAttributes getTextAttributes() {
            SimpleTextAttributes simpleTextAttributes = (SimpleTextAttributes)WrapAwareColoredComponent.this.myAttributes.get(this.myIndex);
            if (simpleTextAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/WrapAwareColoredComponent$MyIterator", "getTextAttributes"));
            }
            return simpleTextAttributes;
        }

        @Override
        public int split(int offset, @NotNull SimpleTextAttributes attributes) {
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/ui/WrapAwareColoredComponent$MyIterator", "split"));
            }
            if (offset < 0 || offset > this.myEndOffset - this.myOffset) {
                throw new IllegalArgumentException(offset + " is not within [0, " + (this.myEndOffset - this.myOffset) + "]");
            }
            if (offset == this.myEndOffset - this.myOffset) {
                WrapAwareColoredComponent.this.myAttributes.set(this.myIndex, attributes);
            } else if (offset > 0) {
                String text = this.getFragment();
                WrapAwareColoredComponent.this.myFragments.set(this.myIndex, text.substring(0, offset));
                WrapAwareColoredComponent.this.myAttributes.add(this.myIndex, attributes);
                WrapAwareColoredComponent.this.myFragments.add(this.myIndex + 1, text.substring(offset));
                if (WrapAwareColoredComponent.this.myFragmentTags != null && WrapAwareColoredComponent.this.myFragmentTags.size() > this.myIndex) {
                    WrapAwareColoredComponent.this.myFragmentTags.add(this.myIndex, WrapAwareColoredComponent.this.myFragments.get(this.myIndex));
                }
                ++this.myIndex;
            }
            this.myOffset += offset;
            return this.myOffset;
        }

        @Override
        public boolean hasNext() {
            return this.myIndex + 1 < WrapAwareColoredComponent.this.myFragments.size();
        }

        @Override
        public String next() {
            ++this.myIndex;
            this.myOffset = this.myEndOffset;
            String text = this.getFragment();
            this.myEndOffset += text.length();
            return text;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ColoredIterator
    extends Iterator<String> {
        public int getOffset();

        public int getEndOffset();

        @NotNull
        public String getFragment();

        @NotNull
        public SimpleTextAttributes getTextAttributes();

        public int split(int var1, @NotNull SimpleTextAttributes var2);
    }

    public static class BrowserLauncherTag
    implements Runnable {
        private final String myUrl;

        public BrowserLauncherTag(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/ui/WrapAwareColoredComponent$BrowserLauncherTag", "<init>"));
            }
            this.myUrl = url;
        }

        @Override
        public void run() {
            BrowserUtil.browse((String)this.myUrl);
        }
    }

    private static class MyAccessibleContext
    extends AccessibleContext {
        private MyAccessibleContext() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        @Override
        public int getAccessibleIndexInParent() {
            return 0;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        @Nullable
        public Accessible getAccessibleChild(int i) {
            return null;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return Locale.getDefault();
        }
    }

    private static final class MyBorder
    implements Border {
        @NotNull
        private Insets myInsets = new Insets(1, 1, 1, 1);

        public void setInsets(@NotNull Insets insets) {
            if (insets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insets", "com/android/tools/idea/ui/WrapAwareColoredComponent$MyBorder", "setInsets"));
            }
            this.myInsets = insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor((Color)JBColor.BLACK);
            UIUtil.drawDottedRectangle((Graphics)g, (int)x, (int)y, (int)(x + width - 1), (int)(y + height - 1));
        }

        @Override
        public Insets getBorderInsets(@NotNull Component c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/ui/WrapAwareColoredComponent$MyBorder", "getBorderInsets"));
            }
            return this.myInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

