/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.wizard.AssetStudioAssetGenerator;
import com.android.tools.idea.wizard.ComboBoxItem;
import com.android.tools.idea.wizard.FileTreeCellRenderer;
import com.android.tools.idea.wizard.FileTreeModel;
import com.android.tools.idea.wizard.NewTemplateObjectWizard;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseOutputResDirStep
extends TemplateWizardStep {
    public static final String ATTR_TARGET_MODULE = "targetModule";
    public static final String ATTR_TARGET_VARIANT = "targetVariant";
    public static final String ATTR_OUTPUT_FOLDER = "outputFolder";
    private final VirtualFile myTargetFile;
    private JComboBox myModuleComboBox;
    private JLabel myDescription;
    private JPanel myPanel;
    private JComboBox myVariantComboBox;
    private Tree myOutputPreviewTree;
    private JLabel myResDirLabel;
    private Module mySelectedModule;
    private Module[] myModuleArray;
    private boolean myComputeNewSourceSet;
    private static final TreeModel EMPTY_MODEL = new DefaultTreeModel(null);
    private final FileTreeCellRenderer myFileTreeRenderer;
    private FileTreeModel myTreeModel;
    private AssetStudioAssetGenerator myAssetGenerator;

    public ChooseOutputResDirStep(@NotNull TemplateWizardState state, @NotNull Project project, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, @Nullable Module module, @Nullable VirtualFile invocationTarget) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/wizard/ChooseOutputResDirStep", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/wizard/ChooseOutputResDirStep", "<init>"));
        }
        super(state, project, module, sidePanelIcon, updateListener);
        this.$$$setupUI$$$();
        this.myFileTreeRenderer = new FileTreeCellRenderer();
        this.myAssetGenerator = new AssetStudioAssetGenerator(state);
        this.myTargetFile = invocationTarget;
        this.init();
    }

    public void init() {
        File resDir;
        Iterator<SourceProvider> sourceProvidersIter;
        AndroidFacet facet;
        if (this.myTargetFile != null && (facet = AndroidFacet.getInstance(this.myModule)) != null && (sourceProvidersIter = IdeaSourceProvider.getSourceProvidersForFile(facet, this.myTargetFile, null).iterator()).hasNext() && (resDir = NewTemplateObjectWizard.findResDirectory(sourceProvidersIter.next())) != null) {
            this.myTemplateState.put(ATTR_OUTPUT_FOLDER, FileUtil.toSystemIndependentName((String)resDir.getPath()));
        }
        this.setUpUiComponents();
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JLabel jLabel = this.myDescription;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ChooseOutputResDirStep", "getDescription"));
        }
        return jLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JLabel jLabel = this.myDescription;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ChooseOutputResDirStep", "getError"));
        }
        return jLabel;
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateStep() {
        super.updateStep();
        this.myComputeNewSourceSet = true;
        this.update();
    }

    private void setUpUiComponents() {
        this.myModuleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        ChooseOutputResDirStep.populateComboBox(this.myModuleComboBox, this.myModuleArray);
        this.register(ATTR_TARGET_MODULE, this.myModuleComboBox);
        this.register(ATTR_TARGET_VARIANT, this.myVariantComboBox);
        if (this.myModule != null) {
            int index = -1;
            for (int i = 0; i < this.myModuleArray.length; ++i) {
                if (!this.myModuleArray[i].equals(this.myModule)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.myModuleComboBox.setSelectedIndex(index);
            }
        }
        this.myOutputPreviewTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.myOutputPreviewTree.setRowHeight(-1);
    }

    @Override
    public void update() {
        if (this.myVisible) {
            super.update();
        }
    }

    @Override
    public void updateParams() {
        super.updateParams();
        this.mySelectedModule = this.myModuleArray[this.myModuleComboBox.getSelectedIndex()];
    }

    @Override
    public void deriveValues() {
        if (this.myIdsWithNewValues.contains(ATTR_TARGET_MODULE)) {
            AndroidFacet facet = AndroidFacet.getInstance(this.mySelectedModule);
            if (facet == null) {
                this.myVariantComboBox.setModel(new DefaultComboBoxModel());
                this.myOutputPreviewTree.setModel(EMPTY_MODEL);
                return;
            }
            IdeaAndroidProject gradleProject = facet.getIdeaAndroidProject();
            if (gradleProject != null) {
                this.show(this.myVariantComboBox, this.myResDirLabel);
                DefaultComboBoxModel<ComboBoxItem> comboBoxModel = new DefaultComboBoxModel<ComboBoxItem>();
                String moduleRoot = FileUtil.toSystemIndependentName((String)AndroidRootUtil.getModuleDirPath(facet.getModule()));
                File resDir = new File(FileUtil.toSystemDependentName((String)this.myTemplateState.getString(ATTR_OUTPUT_FOLDER)));
                int index = 0;
                int selectedIndex = 0;
                for (SourceProvider sourceProvider : IdeaSourceProvider.getAllSourceProviders(facet)) {
                    for (File f : sourceProvider.getResDirectories()) {
                        String resPath = FileUtil.getRelativePath((String)moduleRoot, (String)FileUtil.toSystemIndependentName((String)f.getPath()), (char)'/');
                        comboBoxModel.addElement(new ComboBoxItem(f, resPath, 1, 1));
                        if (resDir != null && resDir.equals(f)) {
                            selectedIndex = index;
                        }
                        ++index;
                    }
                }
                this.myVariantComboBox.setModel(comboBoxModel);
                this.myVariantComboBox.setSelectedIndex(selectedIndex);
            } else {
                this.hide(this.myVariantComboBox, this.myResDirLabel);
                VirtualFile resourceDir = facet.getPrimaryResourceDir();
                if (resourceDir != null) {
                    this.myTemplateState.put(ATTR_TARGET_VARIANT, new File(resourceDir.getPath()));
                } else {
                    return;
                }
            }
            this.myIdsWithNewValues.add(ATTR_TARGET_VARIANT);
        }
        if (this.myIdsWithNewValues.contains(ATTR_TARGET_VARIANT) || this.myComputeNewSourceSet) {
            Object selectedVariant;
            File resDir = (File)this.myTemplateState.get(ATTR_TARGET_VARIANT);
            if (resDir == null && (selectedVariant = this.myVariantComboBox.getSelectedItem()) instanceof ComboBoxItem) {
                resDir = (File)((ComboBoxItem)selectedVariant).id;
            }
            if (resDir != null) {
                this.myTreeModel = new FileTreeModel(resDir, true);
                this.myTemplateState.put(ATTR_OUTPUT_FOLDER, resDir);
                try {
                    Map<String, Map<String, BufferedImage>> images = this.myAssetGenerator.generateImages(false);
                    for (String density : images.keySet()) {
                        Map<String, BufferedImage> filenameMap = images.get(density);
                        for (String filename : filenameMap.keySet()) {
                            Image image = filenameMap.get(filename);
                            ImageIcon ic = null;
                            if (image != null) {
                                while (image.getHeight(null) > 200) {
                                    image = image.getScaledInstance(image.getWidth(null) / 2, image.getHeight(null) / 2, 4);
                                }
                                ic = new ImageIcon(image);
                            }
                            this.myTreeModel.forceAddFile(new File(resDir, filename), ic);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.myOutputPreviewTree.setModel((TreeModel)this.myTreeModel);
                this.myOutputPreviewTree.setCellRenderer((TreeCellRenderer)((Object)this.myFileTreeRenderer));
                this.expandTree();
            }
        }
        this.myComputeNewSourceSet = false;
    }

    private void expandTree() {
        for (int i = 0; i < this.myOutputPreviewTree.getRowCount(); ++i) {
            this.myOutputPreviewTree.expandRow(i);
        }
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.mySelectedModule);
        if (facet == null) {
            this.setErrorHtml("The selected module does not have an Android Facet. Please choose an Android module");
            return false;
        }
        if (this.myTreeModel.hasConflicts()) {
            this.setErrorHtml("Some existing files will be overwritten by this operation. Files which replace existing files are marked red in the preview above.");
        }
        return true;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Tree tree;
        JComboBox jComboBox;
        JLabel jLabel;
        JLabel jLabel2;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Target Module: ");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleComboBox = jComboBox2 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 3, 8, 1, 2, 0, null, null, null));
        this.myResDirLabel = jLabel2 = new JLabel();
        jLabel2.setText("Res Directory:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Output Directories:");
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myDescription = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 4, 0, 1, 3, 3, new Dimension(-1, 50), new Dimension(-1, 50), null));
        this.myVariantComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel2);
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 3, 8, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 1, 1, 1, 7, 1, null, null, new Dimension(-1, 500)));
        this.myOutputPreviewTree = tree = new Tree();
        tree.setToolTipText("A preview rendering of the output tree");
        jBScrollPane.setViewportView((Component)tree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

