/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopedStateStore
implements Function<Key<?>, Object> {
    private Map<Key, Object> myState;
    private Set<Key> myRecentlyUpdated;
    private Scope myScope;
    @Nullable
    private ScopedStoreListener myListener;
    @Nullable
    private ScopedStateStore myParent;

    public ScopedStateStore(@NotNull Scope scope, @Nullable ScopedStateStore parent, @Nullable ScopedStoreListener listener) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/wizard/ScopedStateStore", "<init>"));
        }
        this.myState = Maps.newHashMap();
        this.myRecentlyUpdated = Sets.newHashSet();
        this.myScope = scope;
        this.myListener = listener;
        if (this.myParent != null && this.myScope.isGreaterThan(this.myParent.myScope)) {
            throw new IllegalArgumentException("Attempted to add store of scope " + this.myScope.toString() + " as child of lesser scope " + this.myParent.myScope.toString());
        }
        this.myParent = parent;
    }

    @Nullable
    public <T> T get(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedStateStore", "get"));
        }
        if (this.myScope.equals((Object)key.scope) && this.myState.containsKey(key)) {
            try {
                return key.expectedClass.cast(this.myState.get(key));
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        if (this.myParent != null) {
            return this.myParent.get(key);
        }
        return null;
    }

    public <T> boolean put(@NotNull Key<T> key, @Nullable T value) {
        boolean stateChanged;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedStateStore", "put"));
        }
        if (this.myScope.isGreaterThan(key.scope)) {
            throw new IllegalArgumentException("Attempted to store a value of scope " + key.scope.name() + " in greater scope of " + this.myScope.name());
        }
        if (this.myScope.equals((Object)key.scope)) {
            stateChanged = !this.myState.containsKey(key) || !ScopedStateStore.equals(this.myState.get(key), value);
            this.myState.put(key, value);
        } else if (key.scope.isGreaterThan(this.myScope) && this.myParent != null) {
            stateChanged = this.myParent.put(key, value);
        } else {
            throw new IllegalArgumentException("Attempted to store a value of scope " + key.scope.toString() + " in lesser scope of " + this.myScope.toString() + " which does not have a parent of the proper scope");
        }
        if (stateChanged) {
            this.myRecentlyUpdated.add(key);
            if (this.myListener != null) {
                this.myListener.invokeUpdate(key);
            }
        }
        return stateChanged;
    }

    public <T extends List> boolean listPush(@NotNull Key<T> key, @Nullable Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedStateStore", "listPush"));
        }
        boolean stateChanged = false;
        if (value != null) {
            ArrayList<Object> list = null;
            if (this.containsKey(key)) {
                list = (ArrayList<Object>)this.get(key);
            }
            if (list == null) {
                list = new ArrayList<Object>();
            }
            stateChanged = list.add(value);
            this.put(key, list);
        }
        if (stateChanged) {
            this.myRecentlyUpdated.add(key);
            if (this.myListener != null) {
                this.myListener.invokeUpdate(key);
            }
        }
        return stateChanged;
    }

    public <T extends List> int listSize(@NotNull Key<T> key) {
        List list;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedStateStore", "listSize"));
        }
        if (this.containsKey(key) && (list = (List)this.get(key)) != null) {
            return list.size();
        }
        return 0;
    }

    public <T extends List, V> boolean listRemove(@NotNull Key<T> key, @Nullable V value) {
        List list;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedStateStore", "listRemove"));
        }
        boolean stateChanged = false;
        if (value != null && this.containsKey(key) && (list = (List)this.get(key)) != null) {
            stateChanged = list.remove(value);
        }
        if (stateChanged) {
            this.myRecentlyUpdated.add(key);
            if (this.myListener != null) {
                this.myListener.invokeUpdate(key);
            }
        }
        return stateChanged;
    }

    public <T> void unsafePut(Key<T> key, @Nullable Object object) {
        this.put(key, key.expectedClass.cast(object));
    }

    private static boolean equals(@Nullable Object o, @Nullable Object o2) {
        if (o == null && o2 == null) {
            return true;
        }
        if (o != null) {
            return o.equals(o2);
        }
        return false;
    }

    public <T> void putAll(@NotNull Map<Key<T>, T> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/android/tools/idea/wizard/ScopedStateStore", "putAll"));
        }
        for (Key<T> key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    public <T> boolean remove(@NotNull Key<T> key) {
        boolean stateChanged;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedStateStore", "remove"));
        }
        if (this.myScope.isGreaterThan(key.scope)) {
            throw new IllegalArgumentException("Attempted to remove a value of scope " + (Object)((Object)key.scope) + " from greater scope of " + this.myScope.name());
        }
        if (this.myScope.equals((Object)key.scope)) {
            stateChanged = this.myState.containsKey(key);
            this.myState.remove(key);
        } else if (key.scope.isGreaterThan(this.myScope) && this.myParent != null) {
            stateChanged = this.myParent.remove(key);
        } else {
            throw new IllegalArgumentException("Attempted to remove a value of scope " + (Object)((Object)key.scope) + " from lesser scope of " + this.myScope.toString() + " which does not have a parent of the proper scope");
        }
        if (stateChanged) {
            this.myRecentlyUpdated.add(key);
            if (this.myListener != null) {
                this.myListener.invokeUpdate(key);
            }
        }
        return stateChanged;
    }

    public <T> boolean containsKey(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/ScopedStateStore", "containsKey"));
        }
        if (this.myScope.equals((Object)key.scope)) {
            return this.myState.containsKey(key);
        }
        if (this.myParent != null && key.scope.isGreaterThan(this.myScope)) {
            return this.myParent.containsKey(key);
        }
        return false;
    }

    public Map<String, Object> flatten() {
        HashMap toReturn = this.myParent != null ? this.myParent.flatten() : Maps.newHashMapWithExpectedSize((int)this.myState.size());
        for (Key key : this.myState.keySet()) {
            toReturn.put(key.name, this.myState.get(key));
        }
        return toReturn;
    }

    public Set<Key> getRecentUpdates() {
        return this.myRecentlyUpdated;
    }

    public void clearRecentUpdates() {
        this.myRecentlyUpdated.clear();
    }

    public static <T> Key<T> createKey(@NotNull String name, @NotNull Scope scope, @NotNull Class<T> clazz) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/wizard/ScopedStateStore", "createKey"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/wizard/ScopedStateStore", "createKey"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/wizard/ScopedStateStore", "createKey"));
        }
        return new Key(name, scope, clazz);
    }

    public <T> Key<T> createKey(@NotNull String name, @NotNull Class<T> clazz) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/wizard/ScopedStateStore", "createKey"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/wizard/ScopedStateStore", "createKey"));
        }
        return ScopedStateStore.createKey(name, this.myScope, clazz);
    }

    public Object apply(Key<?> input) {
        return this.get(input);
    }

    public Set<Key> getAllKeys() {
        if (this.myParent == null) {
            return ImmutableSet.copyOf(this.myState.keySet());
        }
        return ImmutableSet.copyOf((Iterable)Iterables.concat(this.myState.keySet(), this.myParent.getAllKeys()));
    }

    public static enum Scope {
        STEP,
        PATH,
        WIZARD;


        public boolean isGreaterThan(@Nullable Scope other) {
            if (other == null) {
                return false;
            }
            return this.ordinal() > other.ordinal();
        }
    }

    public static class Key<T> {
        @NotNull
        public final Class<T> expectedClass;
        @NotNull
        public final String name;
        @NotNull
        public final Scope scope;

        private Key(@NotNull String name, @NotNull Scope scope, @NotNull Class<T> clazz) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/wizard/ScopedStateStore$Key", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/wizard/ScopedStateStore$Key", "<init>"));
            }
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/wizard/ScopedStateStore$Key", "<init>"));
            }
            this.expectedClass = clazz;
            this.name = name;
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.expectedClass.equals(key.expectedClass)) {
                return false;
            }
            if (!this.name.equals(key.name)) {
                return false;
            }
            return this.scope == key.scope;
        }

        public int hashCode() {
            int result = this.expectedClass.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.scope.hashCode();
            return result;
        }

        public String toString() {
            return "Key{" + this.expectedClass.getSimpleName() + " " + (Object)((Object)this.scope) + "#" + this.name + '}';
        }
    }

    public static interface ScopedStoreListener {
        public <T> void invokeUpdate(@Nullable Key<T> var1);
    }
}

