/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.TIntArrayList;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectorUtils {
    public static final Comparator<TextRange> RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange o1, TextRange o2) {
            if (o1.intersects(o2)) {
                return 0;
            }
            return o1.getStartOffset() - o2.getStartOffset();
        }
    };
    private static final Map<String, LanguageInjectionSupport> ourSupports = new LinkedHashMap<String, LanguageInjectionSupport>();
    private static final Pattern MAP_ENTRY_PATTERN;

    private InjectorUtils() {
    }

    public static boolean registerInjectionSimple(@NotNull PsiLanguageInjectionHost host, @NotNull BaseInjection injection, @Nullable LanguageInjectionSupport support, @NotNull MultiHostRegistrar registrar) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "registerInjectionSimple"));
        }
        if (injection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injection", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "registerInjectionSimple"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "registerInjectionSimple"));
        }
        Language language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId());
        if (language == null) {
            return false;
        }
        InjectedLanguage injectedLanguage = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
        List<TextRange> ranges = injection.getInjectedArea((PsiElement)host);
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)ranges.size());
        for (TextRange range : ranges) {
            list.add(Trinity.create((Object)host, (Object)injectedLanguage, (Object)range));
        }
        InjectorUtils.registerInjection(language, list, host.getContainingFile(), registrar);
        if (support != null) {
            InjectorUtils.registerSupport(support, true, registrar);
        }
        return !ranges.isEmpty();
    }

    public static void registerInjection(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, PsiFile containingFile, MultiHostRegistrar registrar) {
        if (language == null) {
            return;
        }
        boolean injectionStarted = false;
        for (Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange> trinity : list) {
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)trinity.first;
            if (host.getContainingFile() != containingFile) continue;
            TextRange textRange = (TextRange)trinity.third;
            InjectedLanguage injectedLanguage = (InjectedLanguage)trinity.second;
            if (!injectionStarted) {
                registrar.startInjecting(language);
                injectionStarted = true;
            }
            registrar.addPlace(injectedLanguage.getPrefix(), injectedLanguage.getSuffix(), host, textRange);
        }
        if (injectionStarted) {
            registrar.doneInjecting();
        }
    }

    @NotNull
    public static Collection<String> getActiveInjectionSupportIds() {
        Set<String> set = ourSupports.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "getActiveInjectionSupportIds"));
        }
        return set;
    }

    public static Collection<LanguageInjectionSupport> getActiveInjectionSupports() {
        return ourSupports.values();
    }

    @Nullable
    public static LanguageInjectionSupport findInjectionSupport(String id) {
        return ourSupports.get(id);
    }

    @NotNull
    public static Class[] getPatternClasses(String supportId) {
        LanguageInjectionSupport support = InjectorUtils.findInjectionSupport(supportId);
        Class[] classArray = support == null ? ArrayUtil.EMPTY_CLASS_ARRAY : support.getPatternClasses();
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "getPatternClasses"));
        }
        return classArray;
    }

    @NotNull
    public static LanguageInjectionSupport findNotNullInjectionSupport(String id) {
        LanguageInjectionSupport result = InjectorUtils.findInjectionSupport(id);
        assert (result != null) : id + " injector not found";
        LanguageInjectionSupport languageInjectionSupport = result;
        if (languageInjectionSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "findNotNullInjectionSupport"));
        }
        return languageInjectionSupport;
    }

    public static StringBuilder appendStringPattern(@NotNull StringBuilder sb, @NotNull String prefix, @NotNull String text, @NotNull String suffix) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "appendStringPattern"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "appendStringPattern"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "appendStringPattern"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "appendStringPattern"));
        }
        sb.append(prefix).append("string().");
        String[] parts = text.split("[,|\\s]+");
        boolean useMatches = false;
        for (String part : parts) {
            if (!InjectorUtils.isRegexp(part)) continue;
            useMatches = true;
            break;
        }
        if (useMatches) {
            sb.append("matches(\"").append(text).append("\")");
        } else if (parts.length > 1) {
            sb.append("oneOf(");
            boolean first = true;
            for (String part : parts) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("\"").append(part).append("\"");
            }
            sb.append(")");
        } else {
            sb.append("equalTo(\"").append(text).append("\")");
        }
        sb.append(suffix);
        return sb;
    }

    public static boolean isRegexp(String s) {
        boolean hasReChars = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '_' || c == '-' || Character.isLetterOrDigit(c)) continue;
            hasReChars = true;
            break;
        }
        if (hasReChars) {
            try {
                new URL(s);
            }
            catch (MalformedURLException e) {
                return true;
            }
        }
        return false;
    }

    public static void registerSupport(@NotNull LanguageInjectionSupport support, boolean settingsAvailable, @NotNull MultiHostRegistrar registrar) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "registerSupport"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "registerSupport"));
        }
        InjectorUtils.putInjectedFileUserData(registrar, LanguageInjectionSupport.INJECTOR_SUPPORT, support);
        if (settingsAvailable) {
            InjectorUtils.putInjectedFileUserData(registrar, LanguageInjectionSupport.SETTINGS_EDITOR, support);
        }
    }

    public static <T> void putInjectedFileUserData(MultiHostRegistrar registrar, Key<T> key, T value) {
        PsiFile psiFile = InjectorUtils.getInjectedFile(registrar);
        if (psiFile != null) {
            psiFile.putUserData(key, value);
        }
    }

    public static PsiFile getInjectedFile(MultiHostRegistrar registrar) {
        List result = ((MultiHostRegistrarImpl)registrar).getResult();
        return result == null || result.isEmpty() ? null : (PsiFile)((Pair)result.get((int)(result.size() - 1))).second;
    }

    public static Configuration getEditableInstance(Project project) {
        return Configuration.getInstance();
    }

    public static boolean canBeRemoved(BaseInjection injection) {
        if (injection.isEnabled()) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)injection.getPrefix()) || StringUtil.isNotEmpty((String)injection.getSuffix())) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)injection.getValuePattern());
    }

    @Nullable
    public static BaseInjection findCommentInjection(@NotNull PsiElement context, @NotNull String supportId, @Nullable Ref<PsiElement> causeRef) {
        Map.Entry<TextRange, BaseInjection> entry;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "findCommentInjection"));
        }
        if (supportId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supportId", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "findCommentInjection"));
        }
        PsiElement target = CompletionUtil.getOriginalOrSelf((PsiElement)context);
        PsiFile file = target.getContainingFile();
        TreeMap<TextRange, BaseInjection> map = InjectorUtils.getInjectionMap(file);
        Map.Entry<TextRange, BaseInjection> entry2 = entry = map == null ? null : map.lowerEntry(target.getTextRange());
        if (entry == null) {
            return null;
        }
        PsiComment psiComment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)entry.getKey().getStartOffset(), PsiComment.class, (boolean)false);
        if (psiComment == null) {
            return null;
        }
        TextRange r0 = psiComment.getTextRange();
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)psiComment, (PsiElement)target);
        int h1 = 0;
        int h2 = 0;
        PsiComment e1 = psiComment;
        PsiElement e2 = target;
        PsiComment e = e1;
        while (e != commonParent) {
            e1 = e;
            e = e.getParent();
            ++h1;
        }
        e = e2;
        while (e != commonParent) {
            e2 = e;
            e = e.getParent();
            ++h2;
        }
        int off1 = r0.getEndOffset();
        int off2 = e2.getTextRange().getStartOffset();
        if (off2 - off1 > 120) {
            return null;
        }
        if (off2 - off1 > 2) {
            PsiElement e3;
            Producer<PsiElement> producer = InjectorUtils.prevWalker(e2, commonParent);
            while ((e3 = (PsiElement)producer.produce()) != null && e3 != psiComment) {
                if (!(e3 instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)e3).isValidHost() || StringUtil.isEmptyOrSpaces((String)e3.getText())) continue;
                return null;
            }
        }
        if (causeRef != null) {
            causeRef.set((Object)psiComment);
        }
        return new BaseInjection(supportId).copyFrom(entry.getValue());
    }

    @Nullable
    private static TreeMap<TextRange, BaseInjection> getInjectionMap(final @Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        return (TreeMap)CachedValuesManager.getCachedValue((PsiElement)file, (CachedValueProvider)new CachedValueProvider<TreeMap<TextRange, BaseInjection>>(){

            @Nullable
            public CachedValueProvider.Result<TreeMap<TextRange, BaseInjection>> compute() {
                TreeMap<TextRange, BaseInjection> map = InjectorUtils.calcInjections(file);
                return CachedValueProvider.Result.create(map.isEmpty() ? null : map, (Object[])new Object[]{file});
            }
        });
    }

    @NotNull
    protected static TreeMap<TextRange, BaseInjection> calcInjections(PsiFile file) {
        TreeMap<TextRange, BaseInjection> injectionMap = new TreeMap<TextRange, BaseInjection>(RANGE_COMPARATOR);
        TIntArrayList ints = new TIntArrayList();
        StringSearcher searcher = new StringSearcher("language=", true, true, false);
        CharSequence contents = file.getViewProvider().getContents();
        char[] contentsArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)contents);
        int s0 = 0;
        int s1 = contents.length();
        int idx = searcher.scan(contents, contentsArray, s0, s1);
        while (idx != -1) {
            String str;
            BaseInjection injection;
            ints.add(idx);
            PsiComment element = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)idx, PsiComment.class, (boolean)false);
            if (element != null && (injection = InjectorUtils.detectInjectionFromText("", str = ElementManipulators.getValueText((PsiElement)element).trim())) != null) {
                injectionMap.put(element.getTextRange(), injection);
            }
            idx = searcher.scan(contents, contentsArray, idx + 1, s1);
        }
        TreeMap<TextRange, BaseInjection> treeMap = injectionMap;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectorUtils", "calcInjections"));
        }
        return treeMap;
    }

    public static Map<String, String> decodeMap(CharSequence charSequence) {
        if (StringUtil.isEmpty((CharSequence)charSequence)) {
            return Collections.emptyMap();
        }
        Matcher matcher = MAP_ENTRY_PATTERN.matcher(charSequence);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            map.put(StringUtil.unescapeStringCharacters((String)matcher.group(1)), StringUtil.unescapeStringCharacters((String)StringUtil.unquoteString((String)matcher.group(2))));
        }
        return map;
    }

    @Nullable
    public static BaseInjection detectInjectionFromText(String supportId, String text) {
        if (text == null || !text.startsWith("language=")) {
            return null;
        }
        Map<String, String> map = InjectorUtils.decodeMap(text);
        String languageId = map.get("language");
        String prefix = (String)ObjectUtils.notNull((Object)map.get("prefix"), (Object)"");
        String suffix = (String)ObjectUtils.notNull((Object)map.get("suffix"), (Object)"");
        BaseInjection injection = new BaseInjection(supportId);
        injection.setDisplayName(text);
        injection.setInjectedLanguageId(languageId);
        injection.setPrefix(prefix);
        injection.setSuffix(suffix);
        return injection;
    }

    private static Producer<PsiElement> prevWalker(final PsiElement element, final PsiElement scope) {
        return new Producer<PsiElement>(){
            PsiElement e;
            {
                this.e = element;
            }

            @Nullable
            public PsiElement produce() {
                if (this.e == null || this.e == scope) {
                    return null;
                }
                PsiElement prev = this.e.getPrevSibling();
                if (prev != null) {
                    this.e = PsiTreeUtil.getDeepestLast((PsiElement)prev);
                    return this.e;
                }
                PsiElement parent = this.e.getParent();
                this.e = parent == scope || parent instanceof PsiFile ? null : parent;
                return this.e;
            }
        };
    }

    static {
        for (LanguageInjectionSupport languageInjectionSupport : Arrays.asList(Extensions.getExtensions(LanguageInjectionSupport.EP_NAME))) {
            ourSupports.put(languageInjectionSupport.getId(), languageInjectionSupport);
        }
        MAP_ENTRY_PATTERN = Pattern.compile("([\\S&&[^=]]+)=(\"(?:[^\"]|\\\\\")*\"|\\S*)");
    }
}

