/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class VarTypeProcessor {
    public static final int VAR_NONFINAL = 1;
    public static final int VAR_FINALEXPLICIT = 2;
    public static final int VAR_FINAL = 3;
    private HashMap<VarVersionPaar, VarType> mapExprentMinTypes = new HashMap();
    private HashMap<VarVersionPaar, VarType> mapExprentMaxTypes = new HashMap();
    private HashMap<VarVersionPaar, Integer> mapFinalVars = new HashMap();

    private void setInitVars(RootStatement root) {
        StructMethod mt = (StructMethod)DecompilerContext.getProperty("CURRENT_METHOD");
        boolean thisvar = !mt.hasModifier(8);
        MethodDescriptor md = (MethodDescriptor)DecompilerContext.getProperty("CURRENT_METHOD_DESCRIPTOR");
        if (thisvar) {
            VarType cltype = new VarType(8, 0, ((StructClass)DecompilerContext.getProperty((String)"CURRENT_CLASS")).qualifiedName);
            this.mapExprentMinTypes.put(new VarVersionPaar(0, 1), cltype);
            this.mapExprentMaxTypes.put(new VarVersionPaar(0, 1), cltype);
        }
        int varindex = 0;
        for (int i = 0; i < md.params.length; ++i) {
            this.mapExprentMinTypes.put(new VarVersionPaar(varindex + (thisvar ? 1 : 0), 1), md.params[i]);
            this.mapExprentMaxTypes.put(new VarVersionPaar(varindex + (thisvar ? 1 : 0), 1), md.params[i]);
            varindex += md.params[i].stack_size;
        }
        LinkedList<RootStatement> stack = new LinkedList<RootStatement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement stat = (Statement)stack.removeFirst();
            List<VarExprent> lstVars = null;
            if (stat.type == 12) {
                lstVars = ((CatchAllStatement)stat).getVars();
            } else if (stat.type == 7) {
                lstVars = ((CatchStatement)stat).getVars();
            }
            if (lstVars != null) {
                for (VarExprent var : lstVars) {
                    this.mapExprentMinTypes.put(new VarVersionPaar(var.getIndex(), 1), var.getVartype());
                    this.mapExprentMaxTypes.put(new VarVersionPaar(var.getIndex(), 1), var.getVartype());
                }
            }
            stack.addAll(stat.getStats());
        }
    }

    public void calculateVarTypes(RootStatement root, DirectGraph dgraph) {
        this.setInitVars(root);
        VarTypeProcessor.resetExprentTypes(dgraph);
        while (!this.processVarTypes(dgraph)) {
        }
    }

    private static void resetExprentTypes(DirectGraph dgraph) {
        dgraph.iterateExprents(new DirectGraph.ExprentIterator(){

            @Override
            public int processExprent(Exprent exprent) {
                List<Exprent> lst = exprent.getAllExprents(true);
                lst.add(exprent);
                for (Exprent expr : lst) {
                    if (expr.type == 12) {
                        ((VarExprent)expr).setVartype(VarType.VARTYPE_UNKNOWN);
                        continue;
                    }
                    if (expr.type != 3) continue;
                    ConstExprent cexpr = (ConstExprent)expr;
                    if (cexpr.getConsttype().type_family != 2) continue;
                    cexpr.setConsttype(new ConstExprent(cexpr.getIntValue(), cexpr.isBoolPermitted()).getConsttype());
                }
                return 0;
            }
        });
    }

    private boolean processVarTypes(DirectGraph dgraph) {
        return dgraph.iterateExprents(new DirectGraph.ExprentIterator(){

            @Override
            public int processExprent(Exprent exprent) {
                return VarTypeProcessor.this.checkTypeExprent(exprent) ? 0 : 1;
            }
        });
    }

    private boolean checkTypeExprent(Exprent exprent) {
        for (Exprent expr : exprent.getAllExprents()) {
            if (this.checkTypeExprent(expr)) continue;
            return false;
        }
        if (exprent.type == 3) {
            VarVersionPaar cpaar;
            ConstExprent cexpr = (ConstExprent)exprent;
            if (cexpr.getConsttype().type_family <= 2 && !this.mapExprentMinTypes.containsKey(cpaar = new VarVersionPaar(cexpr.id, -1))) {
                this.mapExprentMinTypes.put(cpaar, cexpr.getConsttype());
            }
        }
        CheckTypesResult result = exprent.checkExprTypeBounds();
        for (CheckTypesResult.ExprentTypePair entry : result.getLstMaxTypeExprents()) {
            if (entry.type.type_family == 6) continue;
            this.changeExprentType(entry.exprent, entry.type, 1);
        }
        boolean res = true;
        for (CheckTypesResult.ExprentTypePair entry : result.getLstMinTypeExprents()) {
            res &= this.changeExprentType(entry.exprent, entry.type, 0);
        }
        return res;
    }

    private boolean changeExprentType(Exprent exprent, VarType newtype, int minmax) {
        boolean res = true;
        block0 : switch (exprent.type) {
            case 3: {
                VarType mininteger;
                ConstExprent cexpr = (ConstExprent)exprent;
                VarType consttype = cexpr.getConsttype();
                if (newtype.type_family > 2 || consttype.type_family > 2) {
                    return true;
                }
                if (newtype.type_family == 2 && (mininteger = new ConstExprent((Integer)((ConstExprent)exprent).getValue(), false).getConsttype()).isStrictSuperset(newtype)) {
                    newtype = mininteger;
                }
            }
            case 12: {
                VarType newMaxType;
                VarVersionPaar varpaar = null;
                if (exprent.type == 3) {
                    varpaar = new VarVersionPaar(((ConstExprent)exprent).id, -1);
                } else if (exprent.type == 12) {
                    varpaar = new VarVersionPaar((VarExprent)exprent);
                }
                if (minmax == 0) {
                    VarType newMinType;
                    VarType currentMinType = this.mapExprentMinTypes.get(varpaar);
                    if (currentMinType == null || newtype.type_family > currentMinType.type_family) {
                        newMinType = newtype;
                    } else {
                        if (newtype.type_family < currentMinType.type_family) {
                            return true;
                        }
                        newMinType = VarType.getCommonSupertype(currentMinType, newtype);
                    }
                    this.mapExprentMinTypes.put(varpaar, newMinType);
                    if (exprent.type == 3) {
                        ((ConstExprent)exprent).setConsttype(newMinType);
                    }
                    if (currentMinType == null || newMinType.type_family <= currentMinType.type_family && !newMinType.isStrictSuperset(currentMinType)) break;
                    return false;
                }
                VarType currentMaxType = this.mapExprentMaxTypes.get(varpaar);
                if (currentMaxType == null || newtype.type_family < currentMaxType.type_family) {
                    newMaxType = newtype;
                } else {
                    if (newtype.type_family > currentMaxType.type_family) {
                        return true;
                    }
                    newMaxType = VarType.getCommonMinType(currentMaxType, newtype);
                }
                this.mapExprentMaxTypes.put(varpaar, newMaxType);
                break;
            }
            case 2: {
                return this.changeExprentType(((AssignmentExprent)exprent).getRight(), newtype, minmax);
            }
            case 6: {
                FunctionExprent func = (FunctionExprent)exprent;
                switch (func.getFunctype()) {
                    case 36: {
                        res &= this.changeExprentType(func.getLstOperands().get(1), newtype, minmax);
                        res &= this.changeExprentType(func.getLstOperands().get(2), newtype, minmax);
                        break block0;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        res &= this.changeExprentType(func.getLstOperands().get(0), newtype, minmax);
                        res &= this.changeExprentType(func.getLstOperands().get(1), newtype, minmax);
                    }
                }
            }
        }
        return res;
    }

    public HashMap<VarVersionPaar, VarType> getMapExprentMaxTypes() {
        return this.mapExprentMaxTypes;
    }

    public HashMap<VarVersionPaar, VarType> getMapExprentMinTypes() {
        return this.mapExprentMinTypes;
    }

    public HashMap<VarVersionPaar, Integer> getMapFinalVars() {
        return this.mapFinalVars;
    }

    public void setVarType(VarVersionPaar varpaar, VarType type) {
        this.mapExprentMinTypes.put(varpaar, type);
    }

    public VarType getVarType(VarVersionPaar varpaar) {
        return this.mapExprentMinTypes.get(varpaar);
    }
}

