/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarTypeProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;

public class VarVersionsProcessor {
    private HashMap<Integer, Integer> mapOriginalVarIndices = new HashMap();
    private VarTypeProcessor typeproc;

    public void setVarVersions(RootStatement root) {
        StructMethod mt = (StructMethod)DecompilerContext.getProperty("CURRENT_METHOD");
        SSAConstructorSparseEx ssa = new SSAConstructorSparseEx();
        ssa.splitVariables(root, mt);
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flatthelper.buildDirectGraph(root);
        VarVersionsProcessor.mergePhiVersions(ssa, dgraph);
        this.typeproc = new VarTypeProcessor();
        this.typeproc.calculateVarTypes(root, dgraph);
        VarVersionsProcessor.simpleMerge(this.typeproc, dgraph, mt);
        VarVersionsProcessor.eliminateNonJavaTypes(this.typeproc);
        this.setNewVarIndices(this.typeproc, dgraph);
    }

    private static void mergePhiVersions(SSAConstructorSparseEx ssa, DirectGraph dgraph) {
        ArrayList<HashSet> lst = new ArrayList<HashSet>();
        for (Map.Entry<VarVersionPaar, FastSparseSetFactory.FastSparseSet<Integer>> ent : ssa.getPhi().entrySet()) {
            HashSet set = new HashSet();
            set.add(ent.getKey());
            for (Integer vers : ent.getValue()) {
                set.add(new VarVersionPaar(ent.getKey().var, (int)vers));
            }
            for (int i = lst.size() - 1; i >= 0; --i) {
                HashSet tset = (HashSet)lst.get(i);
                HashSet intersection = new HashSet(set);
                intersection.retainAll(tset);
                if (intersection.isEmpty()) continue;
                set.addAll(tset);
                lst.remove(i);
            }
            lst.add(set);
        }
        final HashMap<VarVersionPaar, Integer> phivers = new HashMap<VarVersionPaar, Integer>();
        for (HashSet set : lst) {
            int min = Integer.MAX_VALUE;
            for (VarVersionPaar paar : set) {
                if (paar.version >= min) continue;
                min = paar.version;
            }
            for (VarVersionPaar paar : set) {
                phivers.put(new VarVersionPaar(paar.var, paar.version), min);
            }
        }
        dgraph.iterateExprents(new DirectGraph.ExprentIterator(){

            @Override
            public int processExprent(Exprent exprent) {
                List<Exprent> lst = exprent.getAllExprents(true);
                lst.add(exprent);
                for (Exprent expr : lst) {
                    VarExprent var;
                    Integer vers;
                    if (expr.type != 12 || (vers = (Integer)phivers.get(new VarVersionPaar(var = (VarExprent)expr))) == null) continue;
                    var.setVersion(vers);
                }
                return 0;
            }
        });
    }

    private static void eliminateNonJavaTypes(VarTypeProcessor typeproc) {
        HashMap<VarVersionPaar, VarType> mapExprentMaxTypes = typeproc.getMapExprentMaxTypes();
        HashMap<VarVersionPaar, VarType> mapExprentMinTypes = typeproc.getMapExprentMinTypes();
        HashSet<VarVersionPaar> set = new HashSet<VarVersionPaar>(mapExprentMinTypes.keySet());
        for (VarVersionPaar paar : set) {
            VarType type = mapExprentMinTypes.get(paar);
            VarType maxtype = mapExprentMaxTypes.get(paar);
            if (type.type == 15 || type.type == 16) {
                type = maxtype != null && maxtype.type == 1 ? VarType.VARTYPE_CHAR : (type.type == 15 ? VarType.VARTYPE_BYTE : VarType.VARTYPE_SHORT);
                mapExprentMinTypes.put(paar, type);
                continue;
            }
            if (type.type != 13) continue;
            mapExprentMinTypes.put(paar, VarType.VARTYPE_OBJECT);
        }
    }

    private static void simpleMerge(VarTypeProcessor typeproc, DirectGraph dgraph, StructMethod mt) {
        HashMap<VarVersionPaar, VarType> mapExprentMaxTypes = typeproc.getMapExprentMaxTypes();
        HashMap<VarVersionPaar, VarType> mapExprentMinTypes = typeproc.getMapExprentMinTypes();
        HashMap<Integer, HashSet<Integer>> mapVarVersions = new HashMap<Integer, HashSet<Integer>>();
        for (VarVersionPaar varpaar : mapExprentMinTypes.keySet()) {
            if (varpaar.version < 0) continue;
            HashSet<Integer> set = (HashSet<Integer>)mapVarVersions.get(varpaar.var);
            if (set == null) {
                set = new HashSet<Integer>();
                mapVarVersions.put(varpaar.var, set);
            }
            set.add(varpaar.version);
        }
        boolean is_method_static = mt.hasModifier(8);
        final HashMap<VarVersionPaar, Integer> mapMergedVersions = new HashMap<VarVersionPaar, Integer>();
        for (Map.Entry ent : mapVarVersions.entrySet()) {
            if (((HashSet)ent.getValue()).size() <= 1) continue;
            ArrayList lstVersions = new ArrayList((Collection)ent.getValue());
            Collections.sort(lstVersions);
            for (int i = 0; i < lstVersions.size(); ++i) {
                VarVersionPaar firstpaar = new VarVersionPaar((Integer)ent.getKey(), (Integer)lstVersions.get(i));
                VarType firsttype = mapExprentMinTypes.get(firstpaar);
                if (firstpaar.var == 0 && firstpaar.version == 1 && !is_method_static) continue;
                for (int j = i + 1; j < lstVersions.size(); ++j) {
                    VarVersionPaar secpaar = new VarVersionPaar((Integer)ent.getKey(), (Integer)lstVersions.get(j));
                    VarType sectype = mapExprentMinTypes.get(secpaar);
                    if (!firsttype.equals(sectype) && (!firsttype.equals(VarType.VARTYPE_NULL) || sectype.type != 8) && (!sectype.equals(VarType.VARTYPE_NULL) || firsttype.type != 8)) continue;
                    VarType firstMaxType = mapExprentMaxTypes.get(firstpaar);
                    VarType secMaxType = mapExprentMaxTypes.get(secpaar);
                    mapExprentMaxTypes.put(firstpaar, firstMaxType == null ? secMaxType : (secMaxType == null ? firstMaxType : VarType.getCommonMinType(firstMaxType, secMaxType)));
                    mapMergedVersions.put(secpaar, firstpaar.version);
                    mapExprentMaxTypes.remove(secpaar);
                    mapExprentMinTypes.remove(secpaar);
                    if (firsttype.equals(VarType.VARTYPE_NULL)) {
                        mapExprentMinTypes.put(firstpaar, sectype);
                        firsttype = sectype;
                    }
                    typeproc.getMapFinalVars().put(firstpaar, 1);
                    lstVersions.remove(j);
                    --j;
                }
            }
        }
        if (!mapMergedVersions.isEmpty()) {
            dgraph.iterateExprents(new DirectGraph.ExprentIterator(){

                @Override
                public int processExprent(Exprent exprent) {
                    List<Exprent> lst = exprent.getAllExprents(true);
                    lst.add(exprent);
                    for (Exprent expr : lst) {
                        VarExprent varex;
                        Integer newversion;
                        if (expr.type != 12 || (newversion = (Integer)mapMergedVersions.get(new VarVersionPaar(varex = (VarExprent)expr))) == null) continue;
                        varex.setVersion(newversion);
                    }
                    return 0;
                }
            });
        }
    }

    private void setNewVarIndices(VarTypeProcessor typeproc, DirectGraph dgraph) {
        final HashMap<VarVersionPaar, VarType> mapExprentMaxTypes = typeproc.getMapExprentMaxTypes();
        HashMap<VarVersionPaar, VarType> mapExprentMinTypes = typeproc.getMapExprentMinTypes();
        HashMap<VarVersionPaar, Integer> mapFinalVars = typeproc.getMapFinalVars();
        CounterContainer ccon = DecompilerContext.getCounterContainer();
        final HashMap<VarVersionPaar, Integer> mapVarPaar = new HashMap<VarVersionPaar, Integer>();
        HashMap<Integer, Integer> mapOriginalVarIndices = new HashMap<Integer, Integer>();
        HashSet<VarVersionPaar> set = new HashSet<VarVersionPaar>(mapExprentMinTypes.keySet());
        for (VarVersionPaar vpaar : set) {
            if (vpaar.version < 0) continue;
            int newindex = vpaar.version == 1 ? vpaar.var : ccon.getCounterAndIncrement(2);
            VarVersionPaar newvar = new VarVersionPaar(newindex, 0);
            mapExprentMinTypes.put(newvar, mapExprentMinTypes.get(vpaar));
            mapExprentMaxTypes.put(newvar, mapExprentMaxTypes.get(vpaar));
            if (mapFinalVars.containsKey(vpaar)) {
                mapFinalVars.put(newvar, mapFinalVars.remove(vpaar));
            }
            mapVarPaar.put(vpaar, newindex);
            mapOriginalVarIndices.put(newindex, vpaar.var);
        }
        dgraph.iterateExprents(new DirectGraph.ExprentIterator(){

            @Override
            public int processExprent(Exprent exprent) {
                List<Exprent> lst = exprent.getAllExprents(true);
                lst.add(exprent);
                for (Exprent expr : lst) {
                    VarType maxType;
                    if (expr.type == 12) {
                        VarExprent varex = (VarExprent)expr;
                        Integer newvarindex = (Integer)mapVarPaar.get(new VarVersionPaar(varex));
                        if (newvarindex == null) continue;
                        varex.setIndex(newvarindex);
                        varex.setVersion(0);
                        continue;
                    }
                    if (expr.type != 3 || (maxType = (VarType)mapExprentMaxTypes.get(new VarVersionPaar(expr.id, -1))) == null || !maxType.equals(VarType.VARTYPE_CHAR)) continue;
                    ((ConstExprent)expr).setConsttype(maxType);
                }
                return 0;
            }
        });
        this.mapOriginalVarIndices = mapOriginalVarIndices;
    }

    public VarType getVarType(VarVersionPaar varpaar) {
        return this.typeproc == null ? null : this.typeproc.getVarType(varpaar);
    }

    public void setVarType(VarVersionPaar varpaar, VarType type) {
        this.typeproc.setVarType(varpaar, type);
    }

    public int getVarFinal(VarVersionPaar varpaar) {
        int ret = 3;
        if (this.typeproc != null) {
            Integer fin = this.typeproc.getMapFinalVars().get(varpaar);
            ret = fin == null ? 3 : fin;
        }
        return ret;
    }

    public void setVarFinal(VarVersionPaar varpaar, int finaltype) {
        this.typeproc.getMapFinalVars().put(varpaar, finaltype);
    }

    public HashMap<Integer, Integer> getMapOriginalVarIndices() {
        return this.mapOriginalVarIndices;
    }
}

