/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor;

import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public class JavaEditorFileSwapper
extends EditorFileSwapper {
    @Override
    public Pair<VirtualFile, Integer> getFileToSwapTo(Project project, EditorWithProviderComposite editor) {
        VirtualFile file = editor.getFile();
        VirtualFile sourceFile = JavaEditorFileSwapper.findSourceFile(project, file);
        if (sourceFile == null) {
            return null;
        }
        Integer position = null;
        TextEditorImpl oldEditor = JavaEditorFileSwapper.findSinglePsiAwareEditor(editor.getEditors());
        if (oldEditor != null) {
            PsiElement navigationElement;
            PsiCompiledFile clsFile = (PsiCompiledFile)PsiManager.getInstance((Project)project).findFile(file);
            assert (clsFile != null);
            int offset = oldEditor.getEditor().getCaretModel().getOffset();
            PsiElement elementAt = clsFile.findElementAt(offset);
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiMember.class, (boolean)false);
            if (member instanceof PsiClass) {
                boolean isFirstMember = true;
                for (PsiElement e = member.getFirstChild(); e != null; e = e.getNextSibling()) {
                    if (!(e instanceof PsiMember)) continue;
                    if (offset < e.getTextRange().getEndOffset()) {
                        if (isFirstMember) break;
                        member = (PsiMember)e;
                        break;
                    }
                    isFirstMember = false;
                }
            }
            if (member != null && Comparing.equal((Object)(navigationElement = member.getNavigationElement()).getContainingFile().getVirtualFile(), (Object)sourceFile)) {
                position = navigationElement.getTextOffset();
            }
        }
        return Pair.create((Object)sourceFile, position);
    }

    @Nullable
    public static VirtualFile findSourceFile(Project project, VirtualFile file) {
        PsiClass sourceClass;
        PsiClass clsClass;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof PsiCompiledFile && psiFile instanceof PsiClassOwner && (clsClass = ((PsiClassOwner)psiFile).getClasses()[0]) instanceof ClsClassImpl && (sourceClass = ((ClsClassImpl)clsClass).getSourceMirrorClass()) != null) {
            VirtualFile result = sourceClass.getContainingFile().getVirtualFile();
            assert (result != null) : sourceClass;
            return result;
        }
        return null;
    }
}

