/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LineMarkersUtil {
    static void setLineMarkersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<LineMarkerInfo> markers, int group) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        if (markers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<LineMarkerInfo> oldMarkers = DaemonCodeAnalyzerImpl.getLineMarkers(document, project);
        ArrayList<LineMarkerInfo> array = new ArrayList<LineMarkerInfo>(oldMarkers == null ? markers.size() : oldMarkers.size());
        MarkupModel markupModel = DocumentMarkupModel.forDocument(document, project, true);
        HighlightersRecycler toReuse = new HighlightersRecycler();
        if (oldMarkers != null) {
            for (LineMarkerInfo lineMarkerInfo : oldMarkers) {
                boolean toRemove;
                RangeHighlighter highlighter = lineMarkerInfo.highlighter;
                boolean bl = toRemove = !highlighter.isValid() || lineMarkerInfo.updatePass == group && startOffset <= highlighter.getStartOffset() && (highlighter.getEndOffset() < endOffset || highlighter.getEndOffset() == document.getTextLength());
                if (toRemove) {
                    toReuse.recycleHighlighter(highlighter);
                    continue;
                }
                array.add(lineMarkerInfo);
            }
        }
        for (LineMarkerInfo lineMarkerInfo : markers) {
            LineMarkerInfo.LineMarkerGutterIconRenderer oldRenderer;
            TextRange elementRange;
            TextRange textRange;
            PsiElement element = lineMarkerInfo.getElement();
            if (element == null || (textRange = element.getTextRange()) == null || startOffset > (elementRange = InjectedLanguageManager.getInstance((Project)project).injectedToHost(element, textRange)).getStartOffset() || elementRange.getEndOffset() > endOffset) continue;
            RangeHighlighter marker = toReuse.pickupHighlighterFromGarbageBin(lineMarkerInfo.startOffset, lineMarkerInfo.endOffset, 3000);
            if (marker == null) {
                marker = markupModel.addRangeHighlighter(lineMarkerInfo.startOffset, lineMarkerInfo.endOffset, 3000, null, HighlighterTargetArea.EXACT_RANGE);
            }
            LineMarkerInfo.LineMarkerGutterIconRenderer renderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)lineMarkerInfo.createGutterRenderer();
            LineMarkerInfo.LineMarkerGutterIconRenderer lineMarkerGutterIconRenderer = oldRenderer = marker.getGutterIconRenderer() instanceof LineMarkerInfo.LineMarkerGutterIconRenderer ? (LineMarkerInfo.LineMarkerGutterIconRenderer)marker.getGutterIconRenderer() : null;
            if (oldRenderer == null || renderer == null || !renderer.equals((Object)oldRenderer)) {
                marker.setGutterIconRenderer((GutterIconRenderer)renderer);
            }
            if (!Comparing.equal((Object)marker.getLineSeparatorColor(), (Object)lineMarkerInfo.separatorColor)) {
                marker.setLineSeparatorColor(lineMarkerInfo.separatorColor);
            }
            if (!Comparing.equal((Object)marker.getLineSeparatorPlacement(), (Object)lineMarkerInfo.separatorPlacement)) {
                marker.setLineSeparatorPlacement(lineMarkerInfo.separatorPlacement);
            }
            lineMarkerInfo.highlighter = marker;
            array.add(lineMarkerInfo);
        }
        for (RangeHighlighter rangeHighlighter : toReuse.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
        }
        DaemonCodeAnalyzerImpl.setLineMarkers(document, array, project);
    }
}

