/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsHandler;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncapsulateFieldAction
extends BaseRefactoringIntentionAction {
    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.encapsulate.field.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/EncapsulateFieldAction", "getText"));
        }
        return string;
    }

    @NotNull
    public final String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/EncapsulateFieldAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/EncapsulateFieldAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/EncapsulateFieldAction", "isAvailable"));
        }
        if (element instanceof SyntheticElement) {
            return false;
        }
        PsiField field = EncapsulateFieldAction.getField(element);
        return field != null && !field.hasModifierProperty("final") && !field.hasModifierProperty("private");
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/EncapsulateFieldAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/EncapsulateFieldAction", "invoke"));
        }
        PsiField field = EncapsulateFieldAction.getField(element);
        if (field == null) {
            return;
        }
        new EncapsulateFieldsHandler().invoke(project, new PsiElement[]{field}, null);
    }

    @Nullable
    protected static PsiField getField(@Nullable PsiElement element) {
        if (element == null || !(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null || !(parent instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)parent;
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiThisExpression) {
            return null;
        }
        PsiElement resolved = ref.resolve();
        if (resolved == null || !(resolved instanceof PsiField)) {
            return null;
        }
        return (PsiField)resolved;
    }
}

