/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateContext {
    private final Map<String, Boolean> myContextStates = ContainerUtil.newLinkedHashMap();

    public TemplateContext createCopy() {
        TemplateContext cloneResult = new TemplateContext();
        cloneResult.myContextStates.putAll(this.myContextStates);
        return cloneResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<TemplateContextType, Boolean> getDifference(@Nullable TemplateContext defaultContext) {
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            Map<String, Boolean> map2 = defaultContext == null ? this.myContextStates : defaultContext.myContextStates;
            synchronized (map2) {
                for (TemplateContextType contextType : TemplateManagerImpl.getAllContextTypes()) {
                    Boolean ownValue = this.getOwnValue(contextType);
                    if (ownValue == null || defaultContext != null && this.isEnabled(contextType) == defaultContext.isEnabled(contextType)) continue;
                    result.put(contextType, ownValue);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(TemplateContextType contextType) {
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            Boolean storedValue = this.getOwnValue(contextType);
            if (storedValue == null) {
                TemplateContextType baseContextType = contextType.getBaseContextType();
                if (baseContextType != null && !(baseContextType instanceof EverywhereContextType)) {
                    return this.isEnabled(baseContextType);
                }
                return false;
            }
            return storedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putValue(TemplateContextType context, boolean enabled) {
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            this.myContextStates.put(context.getContextId(), enabled);
        }
    }

    public boolean isExplicitlyEnabled(TemplateContextType contextType) {
        return Boolean.TRUE.equals(this.getOwnValue(contextType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Boolean getOwnValue(TemplateContextType contextType) {
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            return this.myContextStates.get(contextType.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(TemplateContextType contextType, boolean value) {
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            this.myContextStates.put(contextType.getContextId(), value);
        }
    }

    void setDefaultContext(@NotNull TemplateContext defContext) {
        if (defContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defContext", "com/intellij/codeInsight/template/impl/TemplateContext", "setDefaultContext"));
        }
        HashMap<String, Boolean> copy = new HashMap<String, Boolean>(this.myContextStates);
        this.myContextStates.clear();
        this.myContextStates.putAll(defContext.myContextStates);
        this.myContextStates.putAll(copy);
    }

    void readTemplateContext(Element element) throws InvalidDataException {
        List options = element.getChildren("option");
        for (Object e : options) {
            if (!(e instanceof Element)) continue;
            Element option = (Element)e;
            String name = option.getAttributeValue("name");
            String value = option.getAttributeValue("value");
            if (name == null || value == null) continue;
            this.myContextStates.put(name, Boolean.parseBoolean(value));
        }
    }

    void writeTemplateContext(Element element, @Nullable TemplateContext defaultContext) throws WriteExternalException {
        Map<TemplateContextType, Boolean> diff = this.getDifference(defaultContext);
        for (TemplateContextType type : diff.keySet()) {
            Element optionElement = new Element("option");
            optionElement.setAttribute("name", type.getContextId());
            optionElement.setAttribute("value", diff.get(type).toString());
            element.addContent(optionElement);
        }
    }
}

