/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class JavaEditorTextProviderImpl
implements EditorTextProvider {
    private static final Logger LOG = Logger.getInstance(JavaEditorTextProviderImpl.class);

    @Override
    public TextWithImports getEditorText(PsiElement elementAtCaret) {
        String result = null;
        PsiElement element = JavaEditorTextProviderImpl.findExpression(elementAtCaret);
        if (element == null) {
            return null;
        }
        if (element instanceof PsiVariable) {
            result = JavaEditorTextProviderImpl.qualifyEnumConstant(element, ((PsiVariable)element).getName());
        } else if (element instanceof PsiMethod) {
            result = ((PsiMethod)element).getName() + "()";
        } else if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression reference = (PsiReferenceExpression)element;
            result = JavaEditorTextProviderImpl.qualifyEnumConstant(reference.resolve(), element.getText());
        } else {
            result = element.getText();
        }
        return result != null ? new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, result) : null;
    }

    @Nullable
    private static PsiElement findExpression(PsiElement element) {
        PsiElement e = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiVariable.class, PsiExpression.class, PsiMethod.class});
        if (!(e instanceof PsiVariable)) {
            if (e instanceof PsiMethod && element.getParent() != e) {
                e = null;
            } else if (e instanceof PsiReferenceExpression) {
                PsiElement resolve;
                if (e.getParent() instanceof PsiCallExpression) {
                    e = e.getParent();
                } else if (e.getParent() instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)e).resolve()) instanceof PsiClass) {
                    e = e.getParent();
                }
            }
        }
        if (e instanceof PsiNewExpression && ((PsiNewExpression)e).getAnonymousClass() != null) {
            return null;
        }
        return e;
    }

    @Override
    @Nullable
    public Pair<PsiElement, TextRange> findExpression(PsiElement element, boolean allowMethodCalls) {
        PsiElement e;
        PsiElement expression = null;
        PsiElement parent = element.getParent();
        if (parent instanceof PsiLiteralExpression) {
            element = parent;
            parent = parent.getParent();
        }
        if (parent instanceof PsiVariable) {
            expression = element;
        } else if (parent instanceof PsiReferenceExpression) {
            PsiElement resolve;
            PsiElement pparent = parent.getParent();
            if (pparent instanceof PsiCallExpression) {
                parent = pparent;
            } else if (pparent instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)parent).resolve()) instanceof PsiClass) {
                parent = pparent;
            }
            if (allowMethodCalls || !DebuggerUtils.hasSideEffects((PsiElement)parent)) {
                expression = parent;
            }
        } else if (parent instanceof PsiThisExpression) {
            expression = parent;
        } else if (parent instanceof PsiExpression && !(parent instanceof PsiNewExpression)) {
            if (allowMethodCalls || !DebuggerUtils.hasSideEffects((PsiElement)parent)) {
                expression = parent;
            }
        } else if (allowMethodCalls && (e = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiVariable.class, PsiExpression.class, PsiMethod.class})) instanceof PsiNewExpression && ((PsiNewExpression)e).getAnonymousClass() == null) {
            expression = e;
        }
        if (expression != null) {
            try {
                PsiElement context;
                if (parent instanceof PsiParameter) {
                    try {
                        context = ((PsiMethod)((PsiParameter)parent).getDeclarationScope()).getBody();
                    }
                    catch (Throwable ignored) {}
                } else {
                    for (context = element; context != null && !(context instanceof PsiStatement) && !(context instanceof PsiClass); context = context.getParent()) {
                    }
                }
                TextRange textRange = expression.getTextRange();
                PsiExpression psiExpression = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory().createExpressionFromText(expression.getText(), context);
                return Pair.create((Object)psiExpression, (Object)textRange);
            }
            catch (IncorrectOperationException e2) {
                LOG.debug((Throwable)e2);
            }
        }
        return null;
    }

    @Nullable
    private static String qualifyEnumConstant(PsiElement resolved, @Nullable String def) {
        PsiEnumConstant enumConstant;
        PsiClass enumClass;
        if (resolved instanceof PsiEnumConstant && (enumClass = (enumConstant = (PsiEnumConstant)resolved).getContainingClass()) != null) {
            return enumClass.getName() + "." + enumConstant.getName();
        }
        return def;
    }
}

