/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunToCursorBreakpoint
extends LineBreakpoint {
    private final boolean myRestoreBreakpoints;
    @NotNull
    protected final SourcePosition myCustomPosition;
    private String mySuspendPolicy;

    protected RunToCursorBreakpoint(@NotNull Project project, @NotNull SourcePosition pos, boolean restoreBreakpoints) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "<init>"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "<init>"));
        }
        super(project, (XBreakpoint)null);
        this.myCustomPosition = pos;
        this.setVisible(false);
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    @Override
    public SourcePosition getSourcePosition() {
        return this.myCustomPosition;
    }

    @Override
    public void reload() {
    }

    @Override
    public String getSuspendPolicy() {
        return this.mySuspendPolicy;
    }

    @Override
    public void setSuspendPolicy(String policy) {
        this.mySuspendPolicy = policy;
    }

    @Override
    protected boolean isLogEnabled() {
        return false;
    }

    @Override
    protected boolean isLogExpressionEnabled() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isCountFilterEnabled() {
        return false;
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return false;
    }

    @Override
    public boolean isInstanceFiltersEnabled() {
        return false;
    }

    @Override
    protected boolean isConditionEnabled() {
        return false;
    }

    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    protected boolean isMuted(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "isMuted"));
        }
        return false;
    }

    @Nullable
    protected static RunToCursorBreakpoint create(@NotNull Project project, @NotNull Document document, int lineIndex, boolean restoreBreakpoints) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "create"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "create"));
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        SourcePosition pos = SourcePosition.createFromLine((PsiFile)psiFile, (int)lineIndex);
        return new RunToCursorBreakpoint(project, pos, restoreBreakpoints);
    }

    @Override
    protected boolean shouldCreateRequest(DebugProcessImpl debugProcess) {
        return debugProcess.isAttached() && debugProcess.getRequestsManager().findRequests(this).isEmpty();
    }
}

