/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui.statistics;

import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColumnDuration;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColumnResults;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColumnTest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsTableModel
extends ListTableModel<SMTestProxy> {
    private static final Logger LOG = Logger.getInstance((String)StatisticsTableModel.class.getName());
    private SMTestProxy myCurrentSuite;

    public StatisticsTableModel() {
        super(new ColumnInfo[]{new ColumnTest(), new ColumnDuration(), new ColumnResults()});
        this.setSortable(true);
    }

    public void updateModelOnProxySelected(SMTestProxy proxy) {
        SMTestProxy newCurrentSuite = this.getCurrentSuiteFor(proxy);
        if (this.myCurrentSuite != newCurrentSuite) {
            this.myCurrentSuite = newCurrentSuite;
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                StatisticsTableModel.this.updateModel();
            }
        });
    }

    @Nullable
    public SMTestProxy getTestAt(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.getItems().size()) {
            return null;
        }
        return (SMTestProxy)this.getItems().get(rowIndex);
    }

    public int getIndexOf(SMTestProxy test) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            SMTestProxy child = (SMTestProxy)this.getItems().get(i);
            if (child != test) continue;
            return i;
        }
        return -1;
    }

    protected void updateModel() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        this.setItems(this.getItemsForSuite(this.myCurrentSuite));
    }

    @NotNull
    private List<SMTestProxy> getItemsForSuite(@Nullable SMTestProxy suite) {
        if (suite == null) {
            List<SMTestProxy> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/ui/statistics/StatisticsTableModel", "getItemsForSuite"));
            }
            return list;
        }
        ArrayList<SMTestProxy> list = new ArrayList<SMTestProxy>();
        list.addAll(suite.getChildren());
        ArrayList<SMTestProxy> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/ui/statistics/StatisticsTableModel", "getItemsForSuite"));
        }
        return arrayList;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        LOG.error("value: " + aValue + " row: " + rowIndex + " column: " + columnIndex);
    }

    @Nullable
    private SMTestProxy getCurrentSuiteFor(@Nullable SMTestProxy proxy) {
        if (proxy == null) {
            return null;
        }
        SMTestProxy suite = proxy.isSuite() ? proxy : proxy.getParent();
        return suite;
    }

    protected boolean shouldUpdateModelByTest(SMTestProxy test) {
        return this.isSomeSuiteSelected() && test.getParent() == this.myCurrentSuite;
    }

    protected boolean shouldUpdateModelBySuite(SMTestProxy suite) {
        return this.isSomeSuiteSelected() && (suite == this.myCurrentSuite || suite.getParent() == this.myCurrentSuite);
    }

    private boolean isSomeSuiteSelected() {
        return this.myCurrentSuite != null;
    }
}

