/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryHelper {
    @NonNls
    public static final String PLUGIN_LIST_FILE = "availables.xml";

    public static List<IdeaPluginDescriptor> loadPluginsFromRepository(@Nullable ProgressIndicator indicator) throws Exception {
        return RepositoryHelper.loadPluginsFromRepository(indicator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IdeaPluginDescriptor> loadPluginsFromRepository(@Nullable ProgressIndicator indicator, BuildNumber buildnumber) throws Exception {
        File pluginListFile;
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String url = appInfo.getPluginsListUrl() + "?build=" + (buildnumber != null ? buildnumber.asString() : appInfo.getApiVersion());
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{appInfo.getPluginManagerUrl()}));
        }
        if ((pluginListFile = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE)).length() > 0L) {
            try {
                url = url + "&crc32=" + Files.hash((File)pluginListFile, (HashFunction)Hashing.crc32()).toString();
            }
            catch (NoSuchMethodError e) {
                String guavaPath = PathUtil.getJarPathForClass(Hashing.class);
                throw new RuntimeException(guavaPath, e);
            }
        }
        HttpURLConnection connection = ApplicationManager.getApplication() != null ? HttpConfigurable.getInstance().openHttpConnection(url) : (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("Accept-Encoding", "gzip");
        connection.setReadTimeout(HttpConfigurable.CONNECTION_TIMEOUT);
        connection.setConnectTimeout(HttpConfigurable.CONNECTION_TIMEOUT);
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.waiting.for.reply.from.plugin.manager", (Object[])new Object[]{appInfo.getPluginManagerUrl()}));
        }
        connection.connect();
        try {
            List<IdeaPluginDescriptor> list;
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (connection.getResponseCode() == 304) {
                List<IdeaPluginDescriptor> guavaPath = RepositoryHelper.loadPluginList(pluginListFile);
                return guavaPath;
            }
            String encoding = connection.getContentEncoding();
            InputStream is = connection.getInputStream();
            try {
                if ("gzip".equalsIgnoreCase(encoding)) {
                    is = new GZIPInputStream(is);
                }
                if (indicator != null) {
                    indicator.setText2(IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[0]));
                }
                list = RepositoryHelper.readPluginsStream(is, indicator, PLUGIN_LIST_FILE);
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return list;
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized List<IdeaPluginDescriptor> readPluginsStream(InputStream is, ProgressIndicator indicator, String file) throws Exception {
        File temp = RepositoryHelper.createLocalPluginsDescriptions(file);
        FileOutputStream os = new FileOutputStream(temp, false);
        try {
            int size;
            byte[] buffer = new byte[1024];
            while ((size = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, size);
                if (indicator == null) continue;
                indicator.checkCanceled();
            }
        }
        finally {
            ((OutputStream)os).close();
        }
        return RepositoryHelper.loadPluginList(temp);
    }

    private static List<IdeaPluginDescriptor> loadPluginList(File file) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        RepositoryContentHandler handler = new RepositoryContentHandler();
        parser.parse(file, (DefaultHandler)handler);
        return handler.getPluginsList();
    }

    private static File createLocalPluginsDescriptions(String file) throws IOException {
        File basePath = new File(PathManager.getPluginsPath());
        if (!basePath.isDirectory() && !basePath.mkdirs()) {
            throw new IOException("Cannot create directory: " + basePath);
        }
        File temp = new File(basePath, file);
        if (temp.exists()) {
            FileUtil.delete((File)temp);
        }
        FileUtil.createIfDoesntExist((File)temp);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IdeaPluginDescriptor> loadPluginsFromDescription(InputStream is, ProgressIndicator indicator) throws Exception {
        try {
            List<IdeaPluginDescriptor> list = RepositoryHelper.readPluginsStream(is, indicator, "host.xml");
            return list;
        }
        finally {
            is.close();
        }
    }

    public static String getDownloadUrl() {
        return ApplicationInfoImpl.getShadowInstance().getPluginsDownloadUrl() + "?action=download&id=";
    }
}

