/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBus;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoConfiguration
implements NamedComponent,
JDOMExternalizable {
    private TodoPattern[] myTodoPatterns;
    private TodoFilter[] myTodoFilters;
    private IndexPattern[] myIndexPatterns;
    private final EventDispatcher<PropertyChangeListener> myPropertyChangeMulticaster;
    @NonNls
    public static final String PROP_TODO_PATTERNS = "todoPatterns";
    @NonNls
    public static final String PROP_TODO_FILTERS = "todoFilters";
    @NonNls
    private static final String ELEMENT_PATTERN = "pattern";
    @NonNls
    private static final String ELEMENT_FILTER = "filter";
    private final MessageBus myMessageBus;

    public TodoConfiguration(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/ide/todo/TodoConfiguration", "<init>"));
        }
        this.myPropertyChangeMulticaster = EventDispatcher.create(PropertyChangeListener.class);
        this.myMessageBus = messageBus;
        this.resetToDefaultTodoPatterns();
    }

    public void resetToDefaultTodoPatterns() {
        this.myTodoPatterns = new TodoPattern[]{new TodoPattern("\\btodo\\b.*", TodoAttributesUtil.createDefault(), false), new TodoPattern("\\bfixme\\b.*", TodoAttributesUtil.createDefault(), false)};
        this.myTodoFilters = new TodoFilter[0];
        this.buildIndexPatterns();
    }

    private void buildIndexPatterns() {
        this.myIndexPatterns = new IndexPattern[this.myTodoPatterns.length];
        for (int i = 0; i < this.myTodoPatterns.length; ++i) {
            this.myIndexPatterns[i] = this.myTodoPatterns[i].getIndexPattern();
        }
    }

    public static TodoConfiguration getInstance() {
        return (TodoConfiguration)ServiceManager.getService(TodoConfiguration.class);
    }

    @NotNull
    public String getComponentName() {
        if ("TodoConfiguration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/TodoConfiguration", "getComponentName"));
        }
        return "TodoConfiguration";
    }

    @NotNull
    public TodoPattern[] getTodoPatterns() {
        if (this.myTodoPatterns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/TodoConfiguration", "getTodoPatterns"));
        }
        return this.myTodoPatterns;
    }

    @NotNull
    public IndexPattern[] getIndexPatterns() {
        if (this.myIndexPatterns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/TodoConfiguration", "getIndexPatterns"));
        }
        return this.myIndexPatterns;
    }

    public void setTodoPatterns(@NotNull TodoPattern[] todoPatterns) {
        if (todoPatterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PROP_TODO_PATTERNS, "com/intellij/ide/todo/TodoConfiguration", "setTodoPatterns"));
        }
        this.doSetTodoPatterns(todoPatterns, true);
    }

    private void doSetTodoPatterns(@NotNull TodoPattern[] todoPatterns, boolean shouldNotifyIndices) {
        if (todoPatterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PROP_TODO_PATTERNS, "com/intellij/ide/todo/TodoConfiguration", "doSetTodoPatterns"));
        }
        Object[] oldTodoPatterns = this.myTodoPatterns;
        Object[] oldIndexPatterns = this.myIndexPatterns;
        this.myTodoPatterns = todoPatterns;
        this.buildIndexPatterns();
        if (shouldNotifyIndices && !Arrays.deepEquals(this.myIndexPatterns, oldIndexPatterns)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "indexPatterns", oldTodoPatterns, todoPatterns);
            ((PropertyChangeListener)this.myMessageBus.syncPublisher(IndexPatternProvider.INDEX_PATTERNS_CHANGED)).propertyChange(event);
        }
        if (!Arrays.deepEquals(this.myTodoPatterns, oldTodoPatterns)) {
            PropertyChangeListener multicaster = (PropertyChangeListener)this.myPropertyChangeMulticaster.getMulticaster();
            multicaster.propertyChange(new PropertyChangeEvent(this, PROP_TODO_PATTERNS, oldTodoPatterns, todoPatterns));
        }
    }

    public TodoFilter getTodoFilter(String name) {
        for (TodoFilter filter : this.myTodoFilters) {
            if (!filter.getName().equals(name)) continue;
            return filter;
        }
        return null;
    }

    @NotNull
    public TodoFilter[] getTodoFilters() {
        if (this.myTodoFilters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/todo/TodoConfiguration", "getTodoFilters"));
        }
        return this.myTodoFilters;
    }

    public void setTodoFilters(@NotNull TodoFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/ide/todo/TodoConfiguration", "setTodoFilters"));
        }
        TodoFilter[] oldFilters = this.myTodoFilters;
        this.myTodoFilters = filters;
        ((PropertyChangeListener)this.myPropertyChangeMulticaster.getMulticaster()).propertyChange(new PropertyChangeEvent(this, PROP_TODO_FILTERS, oldFilters, filters));
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/todo/TodoConfiguration", "addPropertyChangeListener"));
        }
        this.myPropertyChangeMulticaster.addListener((EventListener)listener);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/todo/TodoConfiguration", "addPropertyChangeListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ide/todo/TodoConfiguration", "addPropertyChangeListener"));
        }
        this.myPropertyChangeMulticaster.addListener((EventListener)listener, parentDisposable);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/todo/TodoConfiguration", "removePropertyChangeListener"));
        }
        this.myPropertyChangeMulticaster.removeListener((EventListener)listener);
    }

    public void readExternal(Element element) throws InvalidDataException {
        ArrayList<TodoPattern> patternsList = new ArrayList<TodoPattern>();
        ArrayList<TodoFilter> filtersList = new ArrayList<TodoFilter>();
        for (Element child : element.getChildren()) {
            if (ELEMENT_PATTERN.equals(child.getName())) {
                TodoPattern pattern = new TodoPattern(TodoAttributesUtil.createDefault());
                pattern.readExternal(child, TodoAttributesUtil.getDefaultColorSchemeTextAttributes());
                patternsList.add(pattern);
                continue;
            }
            if (!ELEMENT_FILTER.equals(child.getName())) continue;
            TodoPattern[] patterns = patternsList.toArray(new TodoPattern[patternsList.size()]);
            TodoFilter filter = new TodoFilter();
            filter.readExternal(child, patterns);
            filtersList.add(filter);
        }
        this.doSetTodoPatterns(patternsList.toArray(new TodoPattern[patternsList.size()]), false);
        this.setTodoFilters(filtersList.toArray(new TodoFilter[filtersList.size()]));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element child;
        TodoPattern[] todoPatterns;
        for (TodoPattern todoPattern : todoPatterns = this.myTodoPatterns) {
            child = new Element(ELEMENT_PATTERN);
            todoPattern.writeExternal(child);
            element.addContent(child);
        }
        for (TodoFilter todoFilter : this.myTodoFilters) {
            child = new Element(ELEMENT_FILTER);
            todoFilter.writeExternal(child, todoPatterns);
            element.addContent(child);
        }
    }

    public void colorSettingsChanged() {
        for (TodoPattern pattern : this.myTodoPatterns) {
            TodoAttributes attributes = pattern.getAttributes();
            if (attributes.shouldUseCustomTodoColor()) continue;
            attributes.setUseCustomTodoColor(false, TodoAttributesUtil.getDefaultColorSchemeTextAttributes());
        }
    }
}

