/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.libraryJar;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarStatisticsService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class LibraryJarUsagesCollector
extends AbstractApplicationUsagesCollector {
    public static final Pattern MULTI_DIGIT_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+).*");
    private static final GroupDescriptor GROUP = GroupDescriptor.create("Libraries by jars", -100.0);
    private static final Pattern PATH_PATTERN = Pattern.compile(".*/[\\w|\\-|\\.]+-([\\w|\\.]+)jar!/.*");

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(final @NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/libraryJar/LibraryJarUsagesCollector", "getProjectUsages"));
        }
        final LibraryJarDescriptor[] descriptors = LibraryJarStatisticsService.getInstance().getTechnologyDescriptors();
        HashSet result = new HashSet(descriptors.length);
        ApplicationManager.getApplication().runReadAction(new Runnable((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            @Override
            public void run() {
                for (LibraryJarDescriptor descriptor : descriptors) {
                    Matcher matcher;
                    PsiClass psiClass;
                    String className = descriptor.myClass;
                    if (className == null || (psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, ProjectScope.getLibrariesScope((Project)project))) == null || !(matcher = PATH_PATTERN.matcher(psiClass.getContainingFile().getVirtualFile().getPath())).matches()) continue;
                    String fullVersion = matcher.group(1);
                    String version = (matcher = MULTI_DIGIT_VERSION_PATTERN.matcher(fullVersion)).matches() ? matcher.group(1) : fullVersion.substring(0, fullVersion.indexOf("."));
                    this.val$result.add(new UsageDescriptor(descriptor.myName + "_" + version, 1));
                }
            }
        });
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/libraryJar/LibraryJarUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GROUP;
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/libraryJar/LibraryJarUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

