/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.DocumentReferenceByVirtualFile;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import com.intellij.util.containers.WeakValueHashMap;
import com.intellij.util.io.fs.FilePath;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DocumentReferenceManagerImpl
extends DocumentReferenceManager
implements ApplicationComponent {
    private static final Key<List<VirtualFile>> DELETED_FILES = Key.create((String)(DocumentReferenceManagerImpl.class.getName() + ".DELETED_FILES"));
    private final Map<Document, DocumentReference> myDocToRef = new WeakKeyWeakValueHashMap();
    private static final Key<Reference<DocumentReference>> FILE_TO_REF_KEY = Key.create((String)"FILE_TO_REF_KEY");
    private final Map<FilePath, DocumentReference> myDeletedFilePathToRef = new WeakValueHashMap();

    @NotNull
    public String getComponentName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl", "getComponentName"));
        }
        return string;
    }

    public void initComponent() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl$1", "fileCreated"));
                }
                VirtualFile f = event.getFile();
                DocumentReference ref = (DocumentReference)DocumentReferenceManagerImpl.this.myDeletedFilePathToRef.remove(new FilePath(f.getUrl()));
                if (ref != null) {
                    f.putUserData(FILE_TO_REF_KEY, new WeakReference<DocumentReference>(ref));
                    ((DocumentReferenceByVirtualFile)ref).update(f);
                }
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl$1", "beforeFileDeletion"));
                }
                VirtualFile f = event.getFile();
                f.putUserData(DELETED_FILES, (Object)DocumentReferenceManagerImpl.collectDeletedFiles(f, new ArrayList()));
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl$1", "fileDeleted"));
                }
                VirtualFile f = event.getFile();
                List files = (List)f.getUserData(DELETED_FILES);
                f.putUserData(DELETED_FILES, null);
                assert (files != null) : f;
                for (VirtualFile each : files) {
                    DocumentReference ref = (DocumentReference)SoftReference.dereference((Reference)((Reference)each.getUserData(FILE_TO_REF_KEY)));
                    each.putUserData(FILE_TO_REF_KEY, null);
                    if (ref == null) continue;
                    DocumentReferenceManagerImpl.this.myDeletedFilePathToRef.put(new FilePath(each.getUrl()), ref);
                }
            }
        });
    }

    private static List<VirtualFile> collectDeletedFiles(VirtualFile f, List<VirtualFile> files) {
        if (!(f instanceof NewVirtualFile)) {
            return files;
        }
        if (!f.isDirectory()) {
            files.add(f);
        } else {
            for (VirtualFile each : ((NewVirtualFile)f).iterInDbChildren()) {
                DocumentReferenceManagerImpl.collectDeletedFiles(each, files);
            }
        }
        return files;
    }

    public void disposeComponent() {
    }

    @NotNull
    public DocumentReference create(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl", "create"));
        }
        DocumentReferenceManagerImpl.assertInDispatchThread();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        DocumentReference documentReference = file == null ? this.createFromDocument(document) : this.create(file);
        if (documentReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl", "create"));
        }
        return documentReference;
    }

    @NotNull
    private DocumentReference createFromDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl", "createFromDocument"));
        }
        DocumentReference result = this.myDocToRef.get(document);
        if (result == null) {
            result = new DocumentReferenceByDocument(document);
            this.myDocToRef.put(document, result);
        }
        DocumentReference documentReference = result;
        if (documentReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl", "createFromDocument"));
        }
        return documentReference;
    }

    @NotNull
    public DocumentReference create(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl", "create"));
        }
        DocumentReferenceManagerImpl.assertInDispatchThread();
        assert (file.isValid()) : "file is invalid: " + file;
        DocumentReference result = (DocumentReference)SoftReference.dereference((Reference)((Reference)file.getUserData(FILE_TO_REF_KEY)));
        if (result == null) {
            result = new DocumentReferenceByVirtualFile(file);
            file.putUserData(FILE_TO_REF_KEY, new WeakReference<DocumentReference>(result));
        }
        DocumentReference documentReference = result;
        if (documentReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl", "create"));
        }
        return documentReference;
    }

    private static void assertInDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }
}

