/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.UIBundle;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;

public class MultiplePasteAction
extends AnAction
implements DumbAware {
    public MultiplePasteAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Component focusedComponent = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (!(focusedComponent instanceof JComponent)) {
            return;
        }
        final CopyPasteManagerEx copyPasteManager = CopyPasteManagerEx.getInstanceEx();
        ContentChooser<Transferable> chooser = new ContentChooser<Transferable>(project, UIBundle.message((String)"choose.content.to.paste.dialog.title", (Object[])new Object[0]), true, true){

            @Override
            protected String getStringRepresentationFor(Transferable content) {
                try {
                    return (String)content.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException e1) {
                    return "";
                }
                catch (IOException e1) {
                    return "";
                }
            }

            @Override
            protected List<Transferable> getContents() {
                return Arrays.asList(CopyPasteManager.getInstance().getAllContents());
            }

            @Override
            protected void removeContentAt(Transferable content) {
                copyPasteManager.removeContent(content);
            }
        };
        if (!chooser.getAllContents().isEmpty()) {
            chooser.show();
        } else {
            chooser.close(1);
        }
        if (chooser.isOK()) {
            int[] selectedIndices = chooser.getSelectedIndices();
            if (selectedIndices.length == 1) {
                copyPasteManager.moveContentToStackTop((Transferable)chooser.getAllContents().get(selectedIndices[0]));
            } else {
                copyPasteManager.setContents(new StringSelection(chooser.getSelectedText()));
            }
            if (editor != null) {
                if (editor.isViewer()) {
                    return;
                }
                if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
                    return;
                }
                AnAction pasteAction = ActionManager.getInstance().getAction("$Paste");
                AnActionEvent newEvent = new AnActionEvent(e.getInputEvent(), DataManager.getInstance().getDataContext(focusedComponent), e.getPlace(), e.getPresentation(), ActionManager.getInstance(), e.getModifiers());
                pasteAction.actionPerformed(newEvent);
            } else {
                Action pasteAction = ((JComponent)focusedComponent).getActionMap().get("paste-from-clipboard");
                if (pasteAction != null) {
                    pasteAction.actionPerformed(new ActionEvent(focusedComponent, 1001, ""));
                }
            }
        }
    }

    public void update(AnActionEvent e) {
        boolean enabled = MultiplePasteAction.isEnabled(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setEnabled(enabled);
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        Object component = e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (!(component instanceof JComponent)) {
            return false;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            return !editor.isViewer();
        }
        Action pasteAction = ((JComponent)component).getActionMap().get("paste-from-clipboard");
        return pasteAction != null;
    }
}

