/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.roots.ui.configuration.ConfigurationErrors;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorPaneConfigurable
extends JPanel
implements Configurable,
Disposable,
ConfigurationErrors {
    private final Alarm myAlarm;
    private final ArrayList<ConfigurationError> myErrors = new ArrayList();
    private final JTextPane myContent = new JTextPane();
    private Runnable myOnErrorsChanged;

    public ErrorPaneConfigurable(Project project, StructureConfigurableContext context, Runnable onErrorsChanged) {
        super(new BorderLayout());
        this.myOnErrorsChanged = onErrorsChanged;
        this.myContent.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myContent.setEditable(false);
        this.myContent.setBackground(UIUtil.getListBackground());
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myContent, (boolean)true);
        pane.setHorizontalScrollBarPolicy(31);
        this.add(pane);
        this.myAlarm = new Alarm((Disposable)this);
        project.getMessageBus().connect((Disposable)this).subscribe(ConfigurationErrors.TOPIC, (Object)this);
        this.myContent.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                URL url = e.getURL();
                AWTEvent awtEvent = EventQueue.getCurrentEvent();
                if (!(awtEvent instanceof MouseEvent)) {
                    return;
                }
                MouseEvent me = (MouseEvent)awtEvent;
                if (url != null) {
                    ConfigurationError error = null;
                    for (Element element = e.getSourceElement(); element != null; element = element.getParentElement()) {
                        if (!"li".equals(element.getName())) continue;
                        Element ol = element.getParentElement();
                        for (int i = 0; i < ol.getElementCount(); ++i) {
                            if (ol.getElement(i) != element) continue;
                            error = (ConfigurationError)ErrorPaneConfigurable.this.myErrors.get(i);
                        }
                        break;
                    }
                    if (error == null) {
                        return;
                    }
                    String host = url.getHost();
                    String path = url.getPath();
                    if (path != null && path.startsWith("/")) {
                        path = StringUtil.unescapeXml((String)path.substring(1));
                    }
                    if (path != null) {
                        if ("fix".equals(host)) {
                            MouseEvent mouseEvent = new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX() - 15, me.getY() + 10, me.getClickCount(), me.isPopupTrigger());
                            error.fix(ErrorPaneConfigurable.this.myContent, new RelativePoint(mouseEvent));
                        } else {
                            error.navigate();
                        }
                    }
                }
            }
        });
        this.refresh();
    }

    public void refresh() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                String html = "<html><header><style type='text/css'>body {  color: #" + ColorUtil.toHex((Color)new JBColor((Color)Gray.x33, UIUtil.getLabelForeground())) + ";" + "  font-family: '" + UIUtil.getLabelFont().getName() + ",serif';" + "  font-size: " + UIUtil.getLabelFont().getSize() + ";" + "}" + "li {" + "  margin-bottom: 5;" + "}" + "ol {" + "}" + "a {" + " text-decoration: none;" + "}" + "</style>" + "</header>" + "<body>";
                int i = 0;
                html = html + "<ol>";
                for (ConfigurationError error : ErrorPaneConfigurable.this.myErrors) {
                    ++i;
                    String description = error.getDescription();
                    if (description.startsWith("<html>") && description.endsWith("</html>")) {
                        description = description.substring(6, description.length() - 7);
                    }
                    if (description.startsWith("Module '")) {
                        int start = 8;
                        int end = description.indexOf("'", 9);
                        String moduleName = description.substring(8, end);
                        description = "Module <a href='http://module/" + StringUtil.escapeXml((String)moduleName) + "'>" + StringUtil.escapeXml((String)moduleName) + "</a> " + description.substring(end + 1);
                    }
                    if (error.canBeFixed()) {
                        description = description + " <a href='http://fix/" + i + "'>[Fix]</a>";
                    }
                    html = html + "<li>" + description + "</li>";
                }
                html = html + "</ol></body></html>";
                ErrorPaneConfigurable.this.myContent.setText(html);
                if (ErrorPaneConfigurable.this.myOnErrorsChanged != null) {
                    ErrorPaneConfigurable.this.myOnErrorsChanged.run();
                }
            }
        }, 100);
    }

    @Nls
    public String getDisplayName() {
        return "Problems";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    @Override
    public void addError(@NotNull ConfigurationError error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/openapi/roots/ui/configuration/ErrorPaneConfigurable", "addError"));
        }
        this.myErrors.add(error);
        this.refresh();
    }

    @Override
    public void removeError(@NotNull ConfigurationError error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/openapi/roots/ui/configuration/ErrorPaneConfigurable", "removeError"));
        }
        this.myErrors.remove(error);
        this.refresh();
    }

    public int getErrorsCount() {
        return this.myErrors.size();
    }
}

