/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vcs.ex.DocumentWrapper;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.ArrayUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RangesBuilder {
    @NotNull
    private final List<Range> myRanges;

    public RangesBuilder(@NotNull Document current, @NotNull Document vcs) throws FilesTooBigForDiffException {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "<init>"));
        }
        this(new DocumentWrapper(current).getLines(), new DocumentWrapper(vcs).getLines(), 0, 0);
    }

    public RangesBuilder(@NotNull List<String> current, @NotNull List<String> vcs, int shift, int vcsShift) throws FilesTooBigForDiffException {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "<init>"));
        }
        this.myRanges = new LinkedList<Range>();
        Diff.Change ch = Diff.buildChanges((Object[])ArrayUtil.toStringArray(vcs), (Object[])ArrayUtil.toStringArray(current));
        while (ch != null) {
            Range range = Range.createOn(ch, shift, vcsShift);
            this.myRanges.add(range);
            ch = ch.link;
        }
    }

    @NotNull
    public List<Range> getRanges() {
        List<Range> list = this.myRanges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder", "getRanges"));
        }
        return list;
    }
}

